/*
  S_Tiles.inc
  created by Steven L. Reid
  v1.0 23 Jul 97

  This file creates square bricks centered on the right front stud.
  S_Tiles.inc is used by L_Tiles, and should only be used to
  create new bricks!  Note be sure to include L_Standard.inc!

  To use:
    #declare SX = 1     // width of brick (i.e. 1)
    #declare SY = 4     // length of brick (i.e. 4)
    #declare l_tile1x4 = #include "S_Tiles.inc"   // creates a 1x4 tile!

  v1.0 23 Jul 97 File created.
*/

// POV-Ray Version
#version 3.0

// Tiled Brick
#declare TX = SX
#declare TY = SY
#declare SZ = F-TE
#declare t_top    = #include "S_Box.inc"
#declare SX = TX-2*TE
#declare SY = TY-2*TE
#declare SZ = TE+C
#declare t_bottom = #include "S_Box.inc"

#if ((TX+TY)>3)
merge {
#end
    difference {
#if (l_highq)
        union {
            // top box
            object { t_top translate TE*z }
            // bottom box
            object { t_bottom translate <TE,TE,0> }
        }
        plane {-z,0 rotate  45*x translate <   0,   0,F-TE>}
        plane {-z,0 rotate -45*x translate <   0,TY*W,F-TE>}
        plane {-z,0 rotate  45*y translate <TX*W,   0,F-TE>}
        plane {-z,0 rotate -45*y translate <   0,   0,F-TE>}
#else
        box { 0, <TX*W,TY*W,F> }
#end
        box { <E,E,-E>, <TX*W-E,TY*W-E,F-E> }
#if ((TX+TY)>3)
    }
#end

    // put in cylinders
        // determine support
    #if ((TX+TY)>3)                 // no supports for 1x1 or 1x2!!!
        #if (TX=1)                  // only small supports
            #declare s_support = object {l_csf}
            #declare s_row = TX-.5
        #else                       // large supports!
            #declare s_support = object {l_cbf}
            #declare s_row = TX-1
        #end
        #while (s_row > 0)
            #declare s_col = TY-1
            #while (s_col > 0)
                object {s_support translate <s_row*W,s_col*W,0>}
                #declare s_col = s_col-1
            #end
            #declare s_row = s_row-1
        #end
    #end

    translate <-WR, -WR, 0>
}
