/*
  S_Slopes.inc
  created by Steven L. Reid
  v1.0 23 Jul 97

  This file creates sloped bricks centered on the right front stud.
  S_Slopes.inc is used by L_slopes, and should only be used to
  create new bricks!  Note be sure to include L_Standard.inc!

  To use:
    #declare SX = 2     // width of brick (i.e. 2 or 3, negative if inverted)
    #declare SY = 4     // length of brick (i.e. 4)
    #declare l_s45w2x4 = #include "S_Slopes.inc"   // creates a 2x4 west slope

  v1.0 23 Jul 97 File created.
*/

// POV-Ray Version
#version 3.0

#if (SX=2)
    #declare A = A45
#else
    #declare A = A25
#end
#declare AX = C*sin(radians(90-A))
#declare AY = C*cos(radians(90-A))

// Sloped brick
union {
#if (l_highq)
    difference {
        merge {
            difference {
                merge {
                    box {<C,0,C>,<SX*W-C,SY*W  ,H-C>}
                    box {<0,C,C>,<SX*W  ,SY*W-C,H-C>}
                    box {<C,C,0>,<SX*W-C,SY*W-C,H  >}
                }
                plane{-z,0
#ifdef (s_sticker)
                    texture {
                        s_sticker
                        rotate z*90 rotate x*180
                        scale <s_scale,SY*W,1>
                    }
#end
                    rotate A*y translate <W-C+AY,0,H-C+AX>
                }
                    // slope
                difference {
                    plane{-z,0 rotate A*y translate <W-C,0,H-C>}
                    box {<W-C+AY,C,SH-C+AX>,<SX*W-C+AY,SY*W-C,H-C+AX>}
                    plane {x,0 translate (W-C)*x}
                    plane {z,0 translate (SH-C)*z}
                }
            }
            union { // right back
                sphere {C*z,C}
                cylinder{C*z,(H-C)*z,C}
                sphere {(H-C)*z,C}
                translate <C,C,0>
            }
            union { // left back
                sphere {C*z,C}
                cylinder{C*z,(SH-C)*z,C}
                sphere {(SH-C)*z,C}
                translate <SX*W-C,C,0>
            }
            union { // right front
                sphere {C*z,C}
                cylinder{C*z,(H-C)*z,C}
                sphere {(H-C)*z,C}
                translate <C,SY*W-C,0>
            }
            union { // left front
                sphere {C*z,C}
                cylinder{C*z,(SH-C)*z,C}
                sphere {(SH-C)*z,C}
                translate <SX*W-C,SY*W-C,0>
            }
            sphere {<W-C,C,H-C>,C}  // top slope
            sphere {<W-C,SY*W-C,H-C>,C}
            cylinder {<SX*W-C,     C,SH-C>,<   W-C,     C, H-C>,C}  // angles!
            cylinder {<SX*W-C,SY*W-C,SH-C>,<   W-C,SY*W-C, H-C>,C}

            cylinder {<SX*W-C,     C,SH-C>,<SX*W-C,SY*W-C,SH-C>,C}  // front
            cylinder {<   W-C,     C, H-C>,<   W-C,SY*W-C, H-C>,C}  // top

            cylinder {<     C,     C,   C>,<SX*W-C,     C,   C>,C}
            cylinder {<SX*W-C,     C,   C>,<SX*W-C,SY*W-C,   C>,C}
            cylinder {<     C,     C,   C>,<SX*W-C,     C,   C>,C}
            cylinder {<SX*W-C,SY*W-C,   C>,<     C,SY*W-C,   C>,C}
            cylinder {<     C,SY*W-C,   C>,<     C,     C,   C>,C}
            cylinder {<     C,     C, H-C>,<   W-C,     C, H-C>,C}
            cylinder {<     C,SY*W-C, H-C>,<   W-C,SY*W-C, H-C>,C}
            cylinder {<     C,     C, H-C>,<     C,SY*W-C, H-C>,C}
        }
        difference {
            box {<E,E,-E>,<SX*W-E,SY*W-E,H-E>}
            plane{-z,0 rotate A*y translate <W,0,H-E>}
        }
    }
#else
    difference {
        box {<0,0,0>,<SX*W,SY*W,H>}
        plane{-z,0 rotate A*y translate <W,0,H>}
        difference {
            box {<E,E,-E>,<SX*W-E,SY*W-E,H-E>}
            plane{-z,0 rotate A*y translate <W,0,H-E>}
        }
    }
#end

    // put in studs!
    #declare s_col = SY
    #while (s_col > 0)
        object { l_stud translate <W/2, s_col*W-W/2, H>}
        #declare s_col = s_col-1
    #end

    // put in cylinders
        // determine support
    #if ((SX+SY)>3)                 // no support for ramp 2x1!!!
        #if (SY=1)                  // only small supports
            union {
                object {l_cs translate <2*W,W/2,0>}
                box {<W-E,E,0>,<W,W-E,H>}
                box {<W,W/2-.05,G>,<W+E,W/2+.05,H>}
        #else                       // large supports!
        #if ((SX+SY)=4)
            object {
                l_cb translate <W,W,0>
        #else
            union {
                #declare s_col = SY-1
                #while (s_col > 0)
                    #declare s_row = SX-1
                    #while (s_row > 0)
                        object {l_cb translate <s_row*W,s_col*W,0>}
                        #declare s_row = s_row-1
                    #end
                    #declare s_col = s_col-1
                #end
            #end
        #end
            // everything gets clipped!
            clipped_by {plane{z,0 rotate A*y translate <W,0,H-E>}}
        }
    #end

    translate <-W/2,-W/2,0>
//    bounded_by {box{<-1,-1,-1>,<SX,SY,H+1>}}
}
