/*
  S_Roofs.inc
  created by Steven L. Reid
  v1.0 14 Sep 97

  This file creates roof bricks (inverted slopes) centered on the right
  front stud.
  S_Roofs.inc is used by L_Slopes, and should only be used to
  create new bricks!  Note be sure to include L_Standard.inc!

  To use:
    #declare SX = 2     // width of brick (i.e. 2 or 3)
    #declare SY = 4     // length of brick (i.e. 4)
    #declare l_r2x4w = #include "S_Roofs.inc"   // creates a 2x4 west roof

  v1.0 14 Sep 97 File created.
*/

// POV-Ray Version
#version 3.0

#if (SX=2)
    #declare A = A45
#else
    #declare A = A25
#end
#declare AX = C*sin(radians(90-A))
#declare AY = C*cos(radians(90-A))

// Sloped brick
union {
    difference {
#if (l_highq)
        merge {
            difference {
                merge {
                    box {<C,0,C>,<SX*W-C,SY*W  ,H-C>}
                    box {<0,C,C>,<SX*W  ,SY*W-C,H-C>}
                    box {<C,C,0>,<SX*W-C,SY*W-C,H  >}
                }
                plane{z,0
#ifdef (s_sticker)
                    texture {
                        s_sticker
                        rotate -90*z rotate 180*x
                        scale <s_scale,SY*W,1>
                    }
#end
                    rotate -A*y translate <W-C+AY,0,C-AX>
                }
                    // slope
                difference {
                    plane{z,0 rotate -A*y translate <W-C,0,C>}
                    box {<W-C+AY,C,C-AX>,<SX*W-C+AY,SY*W-C,H-SH+C-AX>}
                    plane {x,0 translate (W-C)*x}
                    plane {-z,0 translate (H-SH+C)*z}
                }
            }
            union { // right back
                sphere {C*z,C}
                cylinder{C*z,(H-C)*z,C}
                sphere {(H-C)*z,C}
                translate <C,C,0>
            }
            union { // left back
                sphere {C*z,C}
                cylinder{C*z,(SH-C)*z,C}
                sphere {(SH-C)*z,C}
                translate <SX*W-C,C,H-SH>
            }
            union { // right front
                sphere {C*z,C}
                cylinder{C*z,(H-C)*z,C}
                sphere {(H-C)*z,C}
                translate <C,SY*W-C,0>
            }
            union { // left front
                sphere {C*z,C}
                cylinder{C*z,(SH-C)*z,C}
                sphere {(SH-C)*z,C}
                translate <SX*W-C,SY*W-C,H-SH>
            }
            sphere {<W-C,     C,C>,C}  // bottom slope
            sphere {<W-C,SY*W-C,C>,C}
            cylinder {<SX*W-C,     C,H-SH+C>,<   W-C,     C,     C>,C}  // angles!
            cylinder {<SX*W-C,SY*W-C,H-SH+C>,<   W-C,SY*W-C,     C>,C}


            cylinder {<     C,     C,   C>,<   W-C,     C,   C>,C}  // bottom
            cylinder {<   W-C,     C,   C>,<   W-C,SY*W-C,   C>,C}
            cylinder {<   W-C,SY*W-C,   C>,<     C,SY*W-C,   C>,C}
            cylinder {<     C,SY*W-C,   C>,<     C,     C,   C>,C}

            cylinder {<     C,     C, H-C>,<SX*W-C,     C, H-C>,C}  // top
            cylinder {<SX*W-C,     C, H-C>,<SX*W-C,SY*W-C, H-C>,C}
            cylinder {<SX*W-C,SY*W-C, H-C>,<     C,SY*W-C, H-C>,C}
            cylinder {<     C,SY*W-C, H-C>,<     C,     C, H-C>,C}

            cylinder {<SX*W-C, C,H-SH+C>,<SX*W-C,SY*W-C,H-SH+C>,C}  // front
        }
#else
        box {<0,0,0>,<SX*W,SY*W,H>}
        plane{z,0 rotate -A*y translate W*x}
#end
        box {<E,E,-E>,<W-E,SY*W-E,H-E>}
        difference {
             box {<W,E,0>,<SX*W-E,SY*W-E,H+E>}
             plane{z,0 rotate -A*y translate  (W-E)*x}
        }
    }

    // put in studs!
    #declare s_col = SY
    #while (s_col > 0)
        object { l_stud translate <W/2, s_col*W-W/2, H>}
        #declare s_col = s_col-1
    #end
    #declare s_row = SX
    #while (s_row > 1)
        #declare s_col = SY
        #while (s_col > 0)
            object {
                l_studhh translate <s_row*W-W/2, s_col*W-W/2, 0>
                clipped_by { plane{-z,0 rotate -A*y translate (W-E)*x} }
            }
            #declare s_col = s_col-1
        #end
        #declare s_row = s_row-1
    #end
    // put in cylinders
        // determine support type
    #if (SY=2)
        merge {
            cylinder {0, (H-E)*z,.05 translate <WR,W-E+.05,0>}
            box {<WR-.05,W-E+.05,0>,<WR+.05,W+E-.05,H-E>}
            cylinder {0, (H-E)*z,.05 translate <WR,W+E-.05,0>}
        }
    #end

    translate <-W/2,-W/2,0>
//    bounded_by {box{<-1,-1,-1>,<SX,SY,H+1>}}
}
