/*
  S_MiniFig.inc
  created by Steven L. Reid
  v1.1  6 Jan 98

  This file creates minifigures centered on the left leg (foward facing).
  S_MiniFig.inc is used by includes or files to "easily" make mini-figures.
  L_Standard.inc and L_MiniFig.inc must be included first!

  To use: (this is rather long list!)
    /*
     * rotations and angles
     */
        // head roation in degrees relative to body (none or front)
    #declare s_head = -5
        // hand rotations in degrees relative to arms(none or up)
    #declare s_hand_r = 20
    #declare s_hand_l = 45
        // arm rotations in degrees relative to top(none or level)
    #declare s_arm_r = 20
    #declare s_arm_l = 45
        // body rotation in degrees relative to ground (none or standing)
    #declare s_body = 10
        // leg rotations in degrees relative to body(none or standing)
    #declare s_leg_r = 20
    #declare s_leg_l = 45
        // sitting (declare this if you want a sitting mini-fig)
    #declare s_sitting = true
    /*
     * textures of pieces (if default is none, you need to specify later)
     */
        // face type (smile face)
    #declare st_face = texture {l_mm_smile_face}
        // front sticker texture (no sticker)
    #declare st_front = texture {mm_space_red}
        // hands (yellow)
    #declare st_hands = texture {l_yellow}
        // arms (none)
    #declare st_arms = texture {l_blue}
        // body (none)
    #declare st_body = texture {l_red}
        // groin (none or legs if not defined)
    #declare st_groin = texture {l_white}
        // legs (none)
    #declare st_legs = texture {l_black}
        // default (none) use this as the defaults for undeclared items
        // you could just use an object include and add a texture, but
        // this is here just in case
    #declare st_default = texture {l_red}
    /*
     * objects passed -- center on axis where you want hand
     */
        // hat or hair piece
    #declare s_hat = object {l_mf_helmet}
        // things on their back (standard height only!)
    #declare s_back = object {mf_airtanks}
        // in hands (will get same rotations as above)
    #declare s_holding_r = object {l_wrench}
    #declare s_holding_l = object {l_walky_talky}
    /*
     * how to call it!
     */
    #declare mf_mixed_space_man = #include "S_MiniFig.inc"
        // or
    #declare mf_mixed_space_man2 = object {
        #include "S_MiniFig.inc"
        texture {l_red}
        translate <0,0,5*F> rotate 10   // examples of post transformations
    }
    #declare l_box1x4 = #include "S_Box.inc"   // creates a 4x1 box!

  v1.0  1 Nov 97 File created.
  v1.1  6 Jan 98 Sitting default was incorrect -- fixed!
*/

// POV-Ray Version
#version 3.0

// Ensure required libraries are included
#ifndef (L_Standard)
    #include "L_Standard.inc"
#end
#ifndef (L_MiniFig)
    #include "L_MiniFig.inc"
#end

// Set up defaults
    // used for positioning arm
#declare s_ctr = sqrt(.25/2)
    // right hand rotations
#ifdef (s_hand_r)
    #declare sr_hand_r = (s_hand_r-38)
#else
    #declare sr_hand_r = 35 // was 38
#end
    // left hand rotations
#ifdef (s_hand_l)
    #declare sr_hand_l = (s_hand_l+38)
#else
    #declare sr_hand_l = -35 // was -38
#end
    // default sitting to false
#ifndef (s_sitting)
    #declare s_sitting = false
#end
#if (s_sitting)
    #declare ss_leg_r = -90
    #declare ss_leg_l = -90
#else
    #ifdef (s_leg_r)
        #declare ss_leg_r = s_leg_r
    #else
        #declare ss_leg_r = 0
    #end
    #ifdef (s_leg_l)
        #declare ss_leg_l = s_leg_l
    #else
        #declare ss_leg_l = 0
    #end
#end

/*
 * Set up mini-figure
 */

union {
    // upper body (union needed for groin off-set and body rotate
    union {
        // head
        object {
            #ifndef (s_face)
                mf_smile_face
            #else
                l_rd1lrg_sh
                texture {
                    s_face
                    // set up face texture
                    rotate <90,0,90>    translate -.5*z
                    scale <1.75,1.0,1.75> translate .45*z
                }
            #end
            #ifdef (s_back)
                translate E*z
            #end
            translate <WR,0,9*F>
            #ifdef (s_head)
                rotate s_head*z
            #end
        }
        // head gear (if exists)
        #ifdef (s_hat)
            object {
                s_hat
                #ifdef (s_back)
                    translate E*z
                #end
                translate <WR,0,9*F>
                #ifdef (s_head)
                    rotate s_head*z
                #end
            }
        #end
        #ifdef (s_back)
            object {s_back translate <WR,0,9*F>}
        #end
        // body
        #ifndef (st_front)
            object {mf_body translate 5*F*z}
        #else
            union {
                object {mf_body_shell}
                object {
                    mf_body_front
                    texture {
                        st_front
                        // set up body sticker
                        rotate <90,0,180>
                        scale <2*W-2*TE,1,4*F-2*TE>
                        translate <TE-WR,-WR,TE>
                    }
                }
                #ifdef (st_body)
                    texture {st_body}
                #end
                translate 5*F*z
            }
        #end
        // arms
        union { // right hand and arm
            object {
                mf_hand
                rotate sr_hand_r*y
                #ifndef (st_hands)
                    texture {l_yellow}
                #else
                    texture {st_hands}
                #end
            }
            #ifdef (s_holding_r)
                object {
                    s_holding_r
                    translate -SR*y rotate 15*x translate -E*y
                    rotate sr_hand_r*y
                }
            #end
            object {mf_arm}
            translate <0,-s_ctr-.3,-s_ctr>
            rotate -25*y // was 20 and 18 (new was 23 and 15) & -18 * -15
            #ifdef (s_arm_r)
                rotate s_arm_r*x
            #else
                #ifdef (st_body)
                    texture {st_body}
                #end
            #end
            rotate -15*y // 18
            //rotate 10*z
            translate <W+.25,0,8*F>
            #ifdef (st_arms)
                texture {st_arms}
            #end
        }
        union { // left hand and arm
            object {
                mf_hand
                rotate sr_hand_l*y
                #ifndef (st_hands)
                    texture {l_yellow}
                #else
                    texture {st_hands}
                #end
            }
            #ifdef (s_holding_l)
                object {
                    s_holding_l
                    translate -SR*y rotate 15*x translate -E*y
                    rotate sr_hand_l*y
                }
            #end
            object {mf_arm}
            translate <0,-s_ctr-.3,-s_ctr>
            rotate 25*y // was 20 and 18, then 23 and 15
            #ifdef (s_arm_l)
                rotate s_arm_l*x
            #end
            rotate 15*y
            //rotate -10*z
            translate <-.25,0,8*F>
            #ifdef (st_arms)
                texture {st_arms}
            #else
                #ifdef (st_body)
                    texture {st_body}
                #end
            #end
        }
        // groin
        object {
            mf_groin
            translate -TE*y
            #ifdef (st_groin)
                texture {st_groin}
            #else
                #ifdef (st_legs)
                    texture {st_legs}
                #end
            #end
        }
#ifdef (s_body) // rotate top
        translate -3.5*F*z rotate s_body translate 3.5*F*z
#end
        translate TE*y
    }
    // legs
    object {
        mf_right_leg
        #ifdef (ss_leg_r)
            translate <0,-TE,-3.5*F> rotate ss_leg_r*x translate <0,TE,3.5*F>
        #end
        #ifdef (st_legs)
            texture {st_legs}
        #end
    }
    object {
        mf_left_leg
        #ifdef (ss_leg_l)
            translate <0,-TE,-3.5*F> rotate ss_leg_l*x translate <0,TE,3.5*F>
        #end
        #ifdef (st_legs)
            texture {st_legs}
        #end
    }
    #if (s_sitting)
        translate <0,-2*TE,-3.5*F+WR-TE>
    #end
    #ifdef (st_default)
        texture {st_default}
    #end
}
