/*
  S_Bricks.inc
  created by Steven L. Reid
  v1.1 30 Aug 97

  This file creates bricks centered on the right front stud.
  S_Bricks.inc is used by L_Bricks, L_Flats and L_Glass, and should only
  be used to create new bricks!  Note: Be sure to include L_Standard.inc!

  To use:
    #declare SX = 1     // width of brick (i.e. 1)
    #declare SY = 4     // length of brick (i.e. 4)
    #declare SZ = H     // height of brick (set to H or F)
                        // set SZ negative for glass (no supports)
    #declare l_sq1x4 = #include "S_Bricks.inc"   // creates a 4x1 brick!

  v1.0 22 Jul 97 File created.
  v1.1 30 Aug 97 Added definition for glass bricks.
*/

// POV-Ray Version
#version 3.0

// Do we show supports?
#if (SZ < 0)            // is it glass (no supports)?
    #declare SZ = -SZ
    #declare SS = false
#else
    #if ((SX+SY)>2)     // is there room for supports?
        #declare SS = true
    #else               // not glass, and room...show supports!
        #declare SS = false
    #end
#end

// Brick
union {
    intersection {
#if (l_highq)
        merge {
            union {
                sphere {C*z,C}
                cylinder{C*z,(SZ-C)*z,C}
                sphere {(SZ-C)*z,C}
                translate <C,C,0>
            }
            union {
                sphere {C*z,C}
                cylinder{C*z,(SZ-C)*z,C}
                sphere {(SZ-C)*z,C}
                translate <SX*W-C,C,0>
            }
            union {
                sphere {C*z,C}
                cylinder{C*z,(SZ-C)*z,C}
                sphere {(SZ-C)*z,C}
                translate <C,SY*W-C,0>
            }
            union {
                sphere {C*z,C}
                cylinder{C*z,(SZ-C)*z,C}
                sphere {(SZ-C)*z,C}
                translate <SX*W-C,SY*W-C,0>
            }
            cylinder {<     C,     C,   C>,<SX*W-C,     C,   C>,C}
            cylinder {<SX*W-C,     C,   C>,<SX*W-C,SY*W-C,   C>,C}
            cylinder {<SX*W-C,SY*W-C,   C>,<     C,SY*W-C,   C>,C}
            cylinder {<     C,SY*W-C,   C>,<     C,     C,   C>,C}
            cylinder {<     C,     C,SZ-C>,<SX*W-C,     C,SZ-C>,C}
            cylinder {<SX*W-C,     C,SZ-C>,<SX*W-C,SY*W-C,SZ-C>,C}
            cylinder {<SX*W-C,SY*W-C,SZ-C>,<     C,SY*W-C,SZ-C>,C}
            cylinder {<     C,SY*W-C,SZ-C>,<     C,     C,SZ-C>,C}
            box {<C,0,C>,<SX*W-C,SY*W  ,SZ-C>}
#ifndef (s_sticker)
            box {<0,C,C>,<SX*W  ,SY*W-C,SZ-C>}
#else
            box {<G,C,C>,<SX*W-G,SY*W-C,SZ-C>}
            box { // front
                <SX*W-G,C,C>,<SX*W,SY*W-C,SZ-C>
                texture {
                    s_sticker
                    rotate <90,0,270>
                    scale <SX*W,SY*W,SZ>
                }
            }
            box { // back
                <0,C,C>,<G,SY*W-C,SZ-C>
                texture {
                    s_sticker
                    rotate <90,0,90>
                    scale <SX*W,SY*W,SZ>
                }
            }
#end
            box {<C,C,0>,<SX*W-C,SY*W-C,SZ  >}
        }
#else
        box { 0, <SX*W,SY*W,SZ> }
#end
        box { <E,E,-E>, <SX*W-E,SY*W-E,SZ-E> inverse}
        bounded_by { box {<0,0,0>,<SX*W,SY*W,SZ+F>}}
    }

    // put in studs!
    #declare s_row = SX
    #while (s_row > 0)
        #declare s_col = SY
        #while (s_col > 0)
            object { l_stud translate <s_row*W-W/2, s_col*W-W/2, SZ> }
            #declare s_col = s_col-1
        #end
        #declare s_row = s_row-1
    #end

    // put in cylinders
        // determine support
    #if (SS)                 // do we show supports?
        #if (SX=1)                  // only small supports
            #if (SZ = H)            // is flat
                #declare s_support = object {l_cs}
            #else
                #declare s_support = object {l_csf}
            #end
            #declare s_row = SX-.5
        #else                       // large supports!
            #if (SZ = H)            // is flat
                #declare s_support = object {l_cb}
            #else
                #declare s_support = object {l_cbf}
            #end
            #declare s_row = SX-1
        #end
        #while (s_row > 0)
            #declare s_col = SY-1
            #while (s_col > 0)
                object {s_support translate <s_row*W,s_col*W,0>}
                #declare s_col = s_col-1
            #end
            #declare s_row = s_row-1
        #end
    #end

    translate <-W/2, -W/2, 0>
//    bounded_by {box{<-1,-1,-1>,<SX,SY,SZ+1>}}
}
