/*
  S_Box.inc
  created by Steven L. Reid
  v1.0 31 Aug 97

  This file creates boxes.  Note:  These are not centered on stud!
  S_Box.inc is used by includes that require just the box for custom
  defines.
  L_Standard.inc must be included first!

  To use:
    #declare SX = 1     // width of box (i.e. 1)
    #declare SY = 4     // length of box (i.e. 4)
    #declare SZ = H     // height of box (i.e. H, F, ES, etc.)
    #declare l_box1x4 = #include "S_Box.inc"   // creates a 4x1 box!

  v1.0 31 Aug 97 File created.
*/

// POV-Ray Version
#version 3.0

// Box
#if (l_highq)
merge {
    union {
        sphere {C*z,C}
        cylinder{C*z,(SZ-C)*z,C}
        sphere {(SZ-C)*z,C}
        translate <C,C,0>
    }
    union {
        sphere {C*z,C}
        cylinder{C*z,(SZ-C)*z,C}
        sphere {(SZ-C)*z,C}
        translate <SX*W-C,C,0>
    }
    union {
        sphere {C*z,C}
        cylinder{C*z,(SZ-C)*z,C}
        sphere {(SZ-C)*z,C}
        translate <C,SY*W-C,0>
    }
    union {
        sphere {C*z,C}
        cylinder{C*z,(SZ-C)*z,C}
        sphere {(SZ-C)*z,C}
        translate <SX*W-C,SY*W-C,0>
    }
    cylinder {<     C,     C,   C>,<SX*W-C,     C,   C>,C}
    cylinder {<SX*W-C,     C,   C>,<SX*W-C,SY*W-C,   C>,C}
    cylinder {<SX*W-C,SY*W-C,   C>,<     C,SY*W-C,   C>,C}
    cylinder {<     C,SY*W-C,   C>,<     C,     C,   C>,C}
    cylinder {<     C,     C,SZ-C>,<SX*W-C,     C,SZ-C>,C}
    cylinder {<SX*W-C,     C,SZ-C>,<SX*W-C,SY*W-C,SZ-C>,C}
    cylinder {<SX*W-C,SY*W-C,SZ-C>,<     C,SY*W-C,SZ-C>,C}
    cylinder {<     C,SY*W-C,SZ-C>,<     C,     C,SZ-C>,C}
    box {<C,0,C>,<SX*W-C,SY*W  ,SZ-C>}
    box {<0,C,C>,<SX*W  ,SY*W-C,SZ-C>}
    box {<C,C,0>,<SX*W-C,SY*W-C,SZ  >}
    bounded_by {box {<0,0,0>,<SX*W,SY*W,SZ>}}
}
#else
    box { 0, <SX*W,SY*W,SZ> }
#end
