/*
  MF_Space.inc
  created by Steven L. Reid
  v1.0 11 Sep 97

  This file defines space mini-figures centered on the right front
  stud.
  L_Standard.inc and L_MiniFig.inc must be included first!

  v1.0 11 Sep 97 File created.
*/

// POV Version
#version 3

#ifndef (MF_Space)
    #declare MF_Space = true
    // include library!

// Ensure required libraries are included
#ifndef (L_Standard)
    #include "L_Standard.inc"
#end
#ifndef (L_MiniFig)
    #include "L_MiniFig.inc"
#end

// set-up textures
#declare mm_space_red = texture {
    material_map {
        gif "p_mf_space.gif"
        texture {l_white}   // 0
        texture {l_red}     // 1
        texture {l_yellow}  // 2
        texture {l_red}    // 3-14
    }
}
#declare mm_space_white = texture {
    material_map {
        gif "p_mf_space.gif"
        texture {l_white}   // 0
        texture {l_red}     // 1
        texture {l_yellow}  // 2
        texture {l_white}    // 3-14
    }
}

// create space men!
    // space man red
#declare s_hat = object {mf_helmet}
#declare s_back = object {mf_airtanks_n}
#declare s_arm_r = -15
#declare s_arm_l = -15
#declare s_leg_r = -90
#declare st_front = texture {mm_space_red}
#declare st_hands = texture {l_red}
#declare st_default = texture {l_red}
#declare mf_space_red = #include "S_MiniFig.inc"
    // space man red sitting
#declare s_sitting = true
#declare mf_space_red_sitting = #include "S_MiniFig.inc"
    // space man white
#declare s_sitting = false
#declare st_front = texture {mm_space_white}
#declare mf_space_white = #include "S_MiniFig.inc"
    // space man white sitting
#declare s_sitting = true
#declare mf_space_white_sitting = #include "S_MiniFig.inc"

#end    // end library incude
