/*
  MF_Forest.inc
  created by Steven L. Reid
  v1.0 11 Sep 97

  This file defines forest mini-figures centered on the right front
  stud.
  L_Standard.inc and L_MiniFig.inc must be included first!

  v1.0 30 Jun 98 File created.
*/

// POV Version
#version 3

#ifndef (MF_Space)
    #declare MF_Forest = true
    // include library!

// Ensure required libraries are included
#ifndef (L_Standard)
    #include "L_Standard.inc"
#end
#ifndef (L_MiniFig)
    #include "L_MiniFig.inc"
#end

// set-up textures
#declare mm_bandit = texture {
    material_map {
        gif "p_mf_bandit.gif"
        texture {l_black}   // 0
        texture {l_brown}   // 1
        texture {l_green}   // 2
        texture {l_gray}    // 3
        texture {l_dkgray}  // 4-15
    }
}
#declare mm_bandit_face = texture {
    material_map {
        gif "p_bandit_face.gif"
        map_type 2
        texture {l_black}   // 0
        texture {l_yellow}  // 1-14
    }
}
#declare mm_thief = texture {
    material_map {
        gif "p_mf_thief.gif"
        texture {l_black}   // 0
        texture {l_yellow}  // 1
        texture {l_green}   // 2
        texture {l_ltbrown} // 3-15
    }
}
#declare mm_girl_face = texture {
    material_map {
        gif "p_girl_face.gif"
        map_type 2
        texture {l_black}   // 0
        texture {l_brown}   // 1
        texture {l_yellow}  // 2-14
    }
}

// create forest men and women!
    // Bandit
#declare s_face = texture {mm_bandit_face}
#declare s_hat = object {mf_hood}
#declare s_holding_r = object {mf_sword texture {l_gray}}
#declare st_front = texture {mm_bandit}
#declare st_arms = texture {l_red}
#declare st_body = texture {l_green}
#declare st_default = texture {l_brown}
#declare s_arm_r =  40
#declare s_arm_l =  25
#declare mf_bandit = #include "S_MiniFig.inc"
    // Thief
#declare s_face = texture {mm_girl_face}
#declare s_hat = object {mf_hood texture {l_black}}
#declare s_holding_r = object {s_nothing}
#declare s_holding_l = object {mf_sword texture {l_gray}}
#declare st_front = texture {mm_thief}
#declare st_legs = texture {l_gray}
#declare st_default = texture {l_green}
#declare s_arm_r =  35
#declare s_arm_l =  10
#declare mf_thief = #include "S_MiniFig.inc"

#end    // end library incude
