/*
  L_Trees.inc
  created by Steven L. Reid
  v1.0  7 Oct 97

  This file defines trees centered on the right front stud.
  L_Standard.inc must be included first!

  v1.0 7 Oct 97 File created.
*/

// POV-Ray Version
#version 3.0

#ifndef (L_Trees)
    #declare L_Trees = true
    // include library!

// Ensure required libraries are included
#ifndef (L_Standard)
    #include "L_Standard.inc"
#end

// Ye Standard Pinetree
#declare l_pinetree = merge {
    // base
    difference {
        cylinder {0,(F  )*z, H  }
        cylinder {0,(F-E)*z, W-E}
    }
    cylinder {0,(F+2*C)*z, H-2*C}
    torus {H-2*C,2*C rotate 90*x translate F*z}
    object {l_csf}
    // trunk
    cone {F*z,CBR, (6.1-SR)*z,.2}
    // branches
    difference {
        merge {
            cone {(1.5)*z, 11/2*F,(6.1-SR)*z, SR}
            sphere {(6.1-SR)*z,SR}
        }
        merge {
            #declare s_top = 0
            #while (s_top <9)
                box {<-2, -2, .2>, <2, 2, .45> translate (1.5+s_top*.45)*z}
                #declare s_top = s_top + 1
            #end
        }
        merge {
            box {< E,E,0>< 2,-E,8> translate -4*F*y}
            box {<-E,E,0><-2,-E,8> translate -4*F*y}
            box {< E,E,0>< 2,-E,8> translate -2*F*y}
            box {<-E,E,0><-2,-E,8> translate -2*F*y}
            box {< SR,E,0>< 2,-E,8>}
            box {<-SR,E,0><-2,-E,8>}
            box {< E,E,0>< 2,-E,8> translate  2*F*y}
            box {<-E,E,0><-2,-E,8> translate  2*F*y}
            box {< E,E,0>< 2,-E,8> translate  4*F*y}
            box {<-E,E,0><-2,-E,8> translate  4*F*y}
       }
    }
    translate <WR,WR,0>
}

/*
 * Tree brances and leaves
 */

// Large green branch
#declare s_small_leaf = difference {
#if (l_highq)
    merge {
        torus {SR-C,C rotate -90*x translate (SH+C)*z}
        cylinder {(SH+C)*z,(F+SH-C)*z, SR}
        cylinder {    SH*z,(F+SH)*z, SR-C}
        torus {SR-C,C rotate -90*x translate (F+SH-C)*z}
    }
#else
    cylinder {<0,0,SH>,<0,0,F+SH>, SR}
#end
    cylinder {<0,0, 0>,<0,0,H     >,CSR}
}
#declare s_big_leaf = difference {
    merge {
#if (l_highq)
        torus {WR-C,C rotate -90*x translate (F-C)*z}
        cylinder { C*z,(F-C)*z, WR}
        cylinder { 0  , F   *z, WR-C}
        torus {WR-C,C rotate -90*x translate    C *z}
        torus {SR-C,C rotate -90*x translate (F+SH-C)*z}
        cylinder {SH*z,(F+SH-C)*z, SR}
        cylinder { F*z,(F+SH)  *z, SR-C}
#else
        cylinder { 0  , F    *z, WR}
        cylinder {SH*z,(F+SH)*z, SR}
#end
    }
    cylinder {   0, H*z,CSR}
    cylinder {-G*z,SH*z, SR}
}
#declare l_tree_leaves_large = union { // may have to cut some!
    // Middle
    difference {
        union {
            object {s_big_leaf}
            #declare SX = CSD/W
            #declare SY = 4-SD/W
            #declare SZ = F-SH
            object {#include "S_Box.inc" translate <-CSR,-2*W+SR,SH>}
            //box {<-CSR,-2*W+SR,SH>,<CSR,2*W-SR,F>}
            cylinder {<0,0,SH>,<0,0,F>,WR+E}
        }
        cylinder {<0,0, 0>,<0,0, H>,CSR}
    }
    // side branches
    object {s_big_leaf translate <0, 2*W,0>}
    object {s_big_leaf translate <0,-2*W,0>}
    // right back bunch
    object {s_small_leaf translate <-2*W,W,0>}
    #declare SX = 1-CSR/W
    #declare SY = CSD/W
    object {#include "S_Box.inc" translate <CSR-2*W,W-CSR,SH>}
    object {s_small_leaf translate <-W,2*W,0>}
    #declare SX = CSD/W
    #declare SY = 1-CSR/W
    object {#include "S_Box.inc" translate <-CSR-W,-W+2*W,SH>}
    object {s_big_leaf translate <-2*W,2*W,0>}
    #declare SX = (2-CSR)/W
    #declare SY = CSD/W
    object {#include "S_Box.inc" translate <CSR,-CSR,SH> rotate -45*z translate <-2*W,2*W,0>}
    // right front bunch
    object {s_small_leaf translate <-2*W,-W,0>}
    #declare SX = 1-CSR/W
    #declare SY = CSD/W
    object {#include "S_Box.inc" translate <CSR-2*W,-CSR-W,SH>}
    object {s_small_leaf translate <-W,-2*W,0>}
    #declare SX = CSD/W
    #declare SY = 1-CSR/W
    object {#include "S_Box.inc" translate <-CSR-W,CSR-2*W,SH>}
    object {s_big_leaf translate <-2*W,-2*W,0>}
    #declare SX = (2-CSR)/W
    #declare SY = CSD/W
    object {#include "S_Box.inc" translate <CSR,-CSR,SH> rotate 45*z translate <-2*W,-2*W,0>}
    // left bunch
    object {s_small_leaf translate <W,W,0>}
    #declare SX = (1-CSR)/W
    #declare SY = CSD/W
    object {#include "S_Box.inc" translate <-1,-CSR,SH> rotate 45*z translate <W,W,0>}
    object {s_small_leaf translate <W,-W,0>}
    #declare SX = (1-CSR)/W
    #declare SY = CSD/W
    object {#include "S_Box.inc" translate <-1,-CSR,SH> rotate -45*z translate <W,-W,0>}
    object {s_small_leaf translate <2*W,W,0>}
    #declare SX = (1-CSR)/W
    #declare SY = CSD/W
    object {#include "S_Box.inc" translate <-1,-CSR,SH> rotate 45*z translate <2*W,W,0>}
    object {s_small_leaf translate <2*W,-W,0>}
    #declare SX = (1-CSR)/W
    #declare SY = CSD/W
    object {#include "S_Box.inc" translate <-1,-CSR,SH> rotate -45*z translate <2*W,-W,0>}
    object {s_big_leaf translate <3*W,0,0>}
    #declare SX = (2.1-CSR)/W
    #declare SY = CSD/W
    object {#include "S_Box.inc" translate <-2.1+3*W,-CSR,SH>}
}
// Transformations
#declare l_tree_leaves_large_n = object {l_tree_leaves_large rotate  90*z}
#declare l_tree_leaves_large_s = object {l_tree_leaves_large rotate -90*z}
#declare l_tree_leaves_large_e = object {l_tree_leaves_large rotate 180*z}
#declare l_tree_leaves_large_w = object {l_tree_leaves_large }

// Branch
#declare l_branch = union {
    difference {
        merge {
            // bottom
            #declare SX = 2 #declare SY = 1 #declare SZ = 2*H
            #include "S_Box.inc"
            // middle 1
            #declare SX = 3 #declare SY = 1 #declare SZ = 1*H+2*C
            object{#include "S_Box.inc" translate <W,0,2*H-2*C>}
            // middle 2
            #declare SX = 2+(2*C)/W #declare SY = 1 #declare SZ = 2*F+2*C
            object{#include "S_Box.inc" translate <3*W-2*C,0,3*H-2*C>}
            // top
            #declare SX = 1 #declare SY = 1 #declare SZ = H+2*C
            object{#include "S_Box.inc" translate <2*W,0,3*H-2*C>}
        }
        // cut
        cylinder {
            <0,-1,0>,<0,1,0>,1
            scale <4*W,1,3*H+F> translate <5*W,0,0>
        }
        box {<E,E,-G>,<W-E,W-E,2*H-E>}
        box {<W+E,E,H>,<3*W,W-E,3*H-E>}
        box {<2*W+E,E,2*H>,<3*W-E,W-E,4*H-E>}
        box {<2*W+WR,E,3*H>,<5*W-E,W-E,3*H+F2-E>}
    }
    object {l_stud translate <0.5*W,WR,2*H>}
    object {l_stud translate <1.5*W,WR,3*H>}
    object {l_stud translate <2.5*W,WR,4*H>}
    object {l_stud translate <3.5*W,WR,3*H+F2>}
    object {l_stud translate <4.5*W,WR,3*H+F2>}
    translate <-WR,-WR,0>
}
#declare l_branch_s = object {l_branch rotate z*-90}
#declare l_branch_n = object {l_branch rotate z*90}
#declare l_branch_w = object {l_branch }
#declare l_branch_e = object {l_branch rotate z*180}

#end    // end library include
