/*
  L_Tiles.inc
  created by Steven L. Reid
   v1.1  1 Sep 97

  This file defines tiled and semi-tiled bricks centered where the right
  front stud would be.
  L_Standard.inc must be included first!

  v1.0 23 Jul 97 File created.
  v1.1  1 Sep 97 Added semi-tiled bricks and library check.
*/

// POV-Ray Version
#version 3.0

#ifndef (L_Tiles)
    #declare L_Tiles = true
    // include library!

// Ensure required libraries are included
#ifndef (L_Standard)
    #include "L_Standard.inc"
#end

// Tile 1x1
#declare SX = 1
#declare SY = 1
#declare l_tile1x1 = #include "S_Tiles.inc"

// Tile 1x2
#declare SX = 1
#declare SY = 2
#declare l_tile1x2 = #include "S_Tiles.inc"
#declare l_tile2x1 = object {l_tile1x2 rotate -90*z}

// Tile 1x4
#declare SX = 1
#declare SY = 4
#declare l_tile1x4 = #include "S_Tiles.inc"
#declare l_tile4x1 = object {l_tile1x4 rotate -90*z}

// Tile 1x8
#declare SX = 1
#declare SY = 8
#declare l_tile1x8 = #include "S_Tiles.inc"
#declare l_tile8x1 = object {l_tile1x8 rotate -90*z}

// Tile 2x2
#declare SX = 2
#declare SY = 2
#declare l_tile2x2= #include "S_Tiles.inc"

// Tile 2x2 Stud Hole
#declare SX = 1
#declare SY = 2
#declare l_tile1x2sh = union {
    #include "S_Tiles.inc"
    object {l_studh translate <0,WR,F>}
}
#declare l_tile2x1sh = object {l_tile1x2sh rotate -90*z}

#end    // end library include
