/*
  L_Stickers.inc
  created by Steven L. Reid
  v1.0  1 Oct 97

  This file defines bricks with stickers centered on the right front stud.
  L_Standard.inc and L_Flats.inc must be included first!

  v1.0  1 Oct 97 File created.
*/

// POV-Ray Version
#version 3.0

#ifndef (L_Stickers)
    #declare L_Stickers = true
    // include library!

// Ensure required libraries are included
#ifndef (L_Standard)
    #include "L_Standard.inc"
#end

// Phone 2x1 brick
#declare SX = 1
#declare SY = 2
#declare SZ = H
#declare s_sticker = texture {
    material_map {
        gif "p_phone.gif"
        texture {l_black}   // 0
        texture {l_white}   // 1-14
    }
}
#declare l_br1x2_phone = object {#include "S_Bricks.inc" texture {l_white}}
#declare l_br2x1_phone = object {l_br1x2_phone rotate -90*z}

// Police 6x1 brick
#declare SX = 1
#declare SY = 6
#declare SZ = H
#declare s_sticker = texture {
    material_map {
        gif "p_police.gif"
        texture {l_black}   // 0
        texture {l_white}   // 1-14
    }
}
#declare l_br1x6_police = object {#include "S_Bricks.inc" texture {l_white}}
#declare l_br6x1_police = object {l_br1x6_police rotate -90*z}

// Phone 2x1 slope
#declare SX = 2
#declare SY = 1
#declare s_sticker = texture {
    material_map {
        gif "p_phonedial.gif"
        texture {l_white}   // 0
        texture {l_red}     // 1-14
    }
}
#declare s_scale = 1.1
#declare l_s2x1w_phone = object{#include "S_Slopes.inc" texture {l_red}}
#declare l_s1x2n_phone = object {l_s2x1w_phone rotate  90*z}
#declare l_s2x1e_phone = object {l_s2x1w_phone rotate 180*z translate <W,0,0>}
#declare l_s1x2s_phone = object {l_s2x1w_phone rotate 270*z translate <0,W,0>}

// Controls 2x2 slope gray
#declare SX = 2
#declare SY = 2
#declare s_sticker = texture {
    material_map {
        gif "p_controls.gif"
        texture {l_white}   // 0
        texture {l_red}     // 1
        texture {l_green}   // 2
        texture {l_gray}    // 3-14
    }
}
#declare s_scale = 1.1
#declare l_s2x2w_controls_gray = object{#include "S_Slopes.inc" texture {l_gray}}
#declare l_s2x2n_controls_gray = object {l_s2x2w_controls_gray rotate  90*z translate <W,0,0>}
#declare l_s2x2e_controls_gray = object {l_s2x2w_controls_gray rotate 180*z translate <W,W,0>}
#declare l_s2x2s_controls_gray = object {l_s2x2w_controls_gray rotate 270*z translate <0,W,0>}

// Controls 2x2 slope blue
#declare SX = 2
#declare SY = 2
#declare s_sticker = texture {
    material_map {
        gif "p_controls.gif"
        texture {l_white}   // 0
        texture {l_red}     // 1
        texture {l_green}   // 2
        texture {l_blue}    // 3-14
    }
}
#declare s_scale = 1.1
#declare l_s2x2w_controls_blue = object{#include "S_Slopes.inc" texture {l_blue}}
#declare l_s2x2n_controls_blue = object {l_s2x2w_controls_blue rotate  90*z translate <W,0,0>}
#declare l_s2x2e_controls_blue = object {l_s2x2w_controls_blue rotate 180*z translate <W,W,0>}
#declare l_s2x2s_controls_blue = object {l_s2x2w_controls_blue rotate 270*z translate <0,W,0>}

// Display 2x2 slope
#declare SX = 2
#declare SY = 2
#declare s_sticker = texture {
    material_map {
        gif "p_display2.gif"
        texture {l_white}   // 0
        texture {l_red}     // 1
        texture {l_green}   // 2
        texture {l_yellow}  // 3
        texture {l_blue}    // 4-14
    }
}
#declare s_scale = 1.1
#declare l_s2x2w_display = object{#include "S_Slopes.inc" texture {l_blue}}
#declare l_s2x2n_display = object {l_s2x2w_display rotate  90*z translate <W,0,0>}
#declare l_s2x2e_display = object {l_s2x2w_display rotate 180*z translate <W,W,0>}
#declare l_s2x2s_display = object {l_s2x2w_display rotate 270*z translate <0,W,0>}

// Display 2x2 Roof
#declare SX = 2
#declare SY = 2
#declare s_sticker = texture {
    material_map {
        gif "p_display.gif"
        texture {l_white}   // 0
        texture {l_red}     // 1
        texture {l_green}   // 2
        texture {l_yellow}  // 3
        texture {l_blue}    // 4-14
    }
}
#declare s_scale = 1.1
#declare l_r2x2w_display = object{#include "S_Roofs.inc" texture {l_blue}}
#declare l_r2x2n_display = object {l_r2x2w_display rotate  90*z translate <W,0,0>}
#declare l_r2x2e_display = object {l_r2x2w_display rotate 180*z translate <W,W,0>}
#declare l_r2x2s_display = object {l_r2x2w_display rotate 270*z translate <0,W,0>}

// 3x2 slope
#declare SX = 3
#declare SY = 2
#declare s_sticker = texture {
    material_map {
        gif "p_space.gif"
        texture {l_white}   // 0
        texture {l_red}     // 1
        texture {l_yellow}  // 2
        texture {l_gray}    // 3-14
    }
}
#declare s_scale = 1.65
#declare l_s3x2w_space_gray = object {#include "S_Slopes.inc" texture {l_gray}}
#declare l_s2x3n_space_gray = object {l_s3x2w_space_gray rotate  90*z translate <  W,  0,0>}
#declare l_s3x2e_space_gray = object {l_s3x2w_space_gray rotate 180*z translate <2*W,  W,0>}
#declare l_s2x3s_space_gray = object {l_s3x2w_space_gray rotate 270*z translate <  0,2*W,0>}

#end
