/*
  L_Space.inc
  created by Steven L. Reid
  v1.0 30 Aug 97

  This file defines space style bricks centered on the right front stud.
  L_Standard.inc and L_Flats.inc must be included first!

  v1.0 30 Aug 97 File created.
*/

// POV-Ray Version
#version 3.0

#ifndef (L_Space)
    #declare L_Space = true
    // include library!

// Ensure required libraries are included
#ifndef (L_Standard)
    #include "L_Standard.inc"
#end
#ifndef (L_Flats)
    #include "L_Flats.inc"
#end

// Ray Gun
#declare l_raygun = union {
    difference {
        union {
            // nozzle
#if (l_highq)
                // main nozzle
            cylinder {C*z, F2*z, CBR}
            cylinder {  0, F2*z, CBR-C}
            torus {CBR-C,C rotate -90*x translate C*z}

                // edge of cone
            torus {WR-C,C rotate -90*x translate (F2-C)*z}
            cylinder {(F2-C)*z,(F2-.035)*z,WR}
            cylinder {(F2)*z,(F2-.035)*z,WR-C}

                // cone
            cone {(F2-.035)*z,WR,(F2-.1)*z,CBR+C}

                // band w/ cone
            torus {CBR+-TE/2,TE/2 rotate -90*x
                translate (F2-.12   +0.5*TE)*z}

                // 4 bands
            torus {CBR+C-TE/2,TE/2 rotate -90*x
                translate (F2-.12-  C-0.5*TE)*z}
            torus {CBR+C-TE/2,TE/2 rotate -90*x
                translate (F2-.12-2*C-1.5*TE)*z}
            torus {CBR+C-TE/2,TE/2 rotate -90*x
                translate (F2-.12-3*C-2.5*TE)*z}
            torus {CBR+C-TE/2,TE/2 rotate -90*x
                translate (F2-.12-4*C-3.5*TE)*z}
#else
                // Main nozzle
            cylinder {0,F2*z,CBR}
                // edge of cone
            cylinder {F2*z,(F2-.035)*z,WR}
                // cone
            cone {(F2-.035)*z,WR,(F2-.1)*z,CBR+C}
                // band w/ cone
            cylinder {(F2-.1)*z,(F2-.12)*z,CBR+C}
                // 4 bands
            cylinder {(F2-.12-  C     )*z,(F2-.12-  C-  TE)*z,CBR+C}
            cylinder {(F2-.12-2*C-  TE)*z,(F2-.12-2*C-2*TE)*z,CBR+C}
            cylinder {(F2-.12-3*C-2*TE)*z,(F2-.12-3*C-3*TE)*z,CBR+C}
            cylinder {(F2-.12-4*C-3*TE)*z,(F2-.12-4*C-4*TE)*z,CBR+C}
#end
         }
        cylinder {-E*z,SH*z, SR}
        object {l_axlecut translate (-H-G+F2-E)*z}
    }
    // body
        // small cylinder
    cylinder {F2*z,2*H*z,CSR-C}
#if (l_highq)
        // body start
    torus {CSR-C,C rotate -90*x translate (F2+.9-C)*z}
    cylinder {F2*z,(F2+.9-C)*z,CSR}
    cylinder {F2*z,(F2+.9)*z,CSR-C}
        // bands
    torus {CSR-TE/2,TE/2 rotate -90*x translate (F2+.9+  C+0.5*TE)*z}
    torus {CSR-TE/2,TE/2 rotate -90*x translate (F2+.9+2*C+1.5*TE)*z}
    torus {CSR-TE/2,TE/2 rotate -90*x translate (F2+.9+3*C+2.5*TE)*z}

        // body end
    torus {CSR-C,C rotate -90*x translate (F2+.9+4*C+3*TE+C)*z}
    cylinder {(F2+.9+4*C+3*TE+C)*z,(2*H+SH-C)*z,CSR}
    cylinder {(F2+.9+4*C+3*TE)*z,(2*H+SH  )*z,CSR-C}
    torus {CSR-C,C rotate -90*x translate (2*H+SH-C)*z}
#else
        // body start
    cylinder {F2*z,(F2+.9)*z,CSR}
        // bands
    cylinder {(F2+.9+  C     )*z,(F2+.9+  C+  TE)*z,CSR}
    cylinder {(F2+.9+2*C+  TE)*z,(F2+.9+2*C+2*TE)*z,CSR}
    cylinder {(F2+.9+3*C+2*TE)*z,(F2+.9+3*C+3*TE)*z,CSR}
        // body end
    cylinder {(F2+.9+4*C+3*TE)*z,(2*H+SH)*z,CSR}
#end
    // handle
#if (l_highq)
    cylinder {<0,0,H>,<F2-C,0,H>,CSR}
    cylinder {<0,0,H>,<F2  ,0,H>,CSR-C}
    torus {CSR-C,C rotate 90*z translate <F2-C,0,H>}
#else
    cylinder {<0,0,H>,<F2,0,H>,CSR}
#end
}

// Prongs (new style, dropped)
#declare l_prongs_w = union {
    object {l_br1x2f translate <WR,WR,0>}
#if (l_highq)
    box {<C,  0,C>,<W-C,   -CSR,ES>}
    cylinder {0, 2*W   *x,CSR-C translate <0,   -CSR-ES,ES/2>}
    cylinder {0,(2*W-C)*x,CSR   translate <0,   -CSR-ES,ES/2>}
    torus {CSR-C,C rotate 90*z translate <2*W-C,-CSR-ES,ES/2>}
    box {<C,2*W,C>,<W-C,2*W+CSR,ES>}
    cylinder {0, 2*W   *x,CSR-C translate <0,2*W+CSR+ES,ES/2>}
    cylinder {0,(2*W-C)*x,CSR   translate <0,2*W+CSR+ES,ES/2>}
    torus {CSR-C,C rotate 90*z translate <2*W-C,2*W+CSR+ES,ES/2>}
#else
    box {<0,  0,0>,<W,   -CSR,ES>}
    cylinder {0,2*W*x,CSR translate <0,   -CSR-ES,ES/2>}
    box {<0,2*W,0>,<W,2*W+CSR,ES>}
    cylinder {0,2*W*x,CSR translate <0,2*W+CSR+ES,ES/2>}
#end
    translate <-WR,-WR,0>
}
#declare l_prongs_s = object {l_prongs_w rotate z*-90}
#declare l_prongs_n = object {l_prongs_w rotate z* 90 translate <W,0,0>}
#declare l_prongs_e = object {l_prongs_w rotate z*180 translate <0,W,0>}

// Prongs Flat(old or original style, flatter)
#declare l_prongsf_w = union {
    object {l_br1x2f translate <WR,WR,0>}
    box {<0,    C,F/2-ES/2>,<W,   -ES,F/2+ES/2>}
    cylinder {0,2*W*x,CSR translate <0,   -CSR-ES,F/2>}
    sphere {<2*W,   -CSR-ES,F/2>,CSR}
    box {<0,2*W-C,F/2-ES/2>,<W,2*W+ES,F/2+ES/2>}
    cylinder {0,2*W*x,CSR translate <0,2*W+CSR+ES,F/2>}
    sphere {<2*W,2*W+CSR+ES,F/2>,CSR}
    translate <-WR,-WR,0>
}
#declare l_prongsf_s = object {l_prongsf_w rotate z*-90}
#declare l_prongsf_n = object {l_prongsf_w rotate z* 90 translate <W,0,0>}
#declare l_prongsf_e = object {l_prongsf_w rotate z*180 translate <0,W,0>}


// Thruster
#declare l_thruster_cone = difference {
    union {
        cone {0,SR, (W-ES)*x,WR}
#if (l_highq)
        cylinder {(W-ES)*x,(W-C)*x, WR}
        cylinder {(W-ES)*x,    W*x, WR-C}
        torus {WR-C,C rotate 90*z translate (W-C)*x}
#else
        cylinder {(W-ES)*x,W*x, WR}
#end
    }
    cylinder {(W-SH)*x,(W+G)*x,SR}
    object {l_axlecut translate (-H-G-F-E)*z rotate -90*y}
    cylinder {0,W*x,CSR}
}
#declare l_thruster_s = union {
    difference {
        object {
            #declare SX = 1
            #declare SY = 2
            #declare SZ = F
            #include "S_Box.inc"
            translate -W*y
        }
        box { <E,-W+E,-E>, <W-E,W-E,F-E> }
    }
    difference {
        object {
            #declare SX = 1
            #declare SY = 1
            #declare SZ = H
            #include "S_Box.inc"
            translate <0,-W,-F2>
        }
        box { <E,-E,-H>, <W-E,-W+E,F-E> }
    }
    box {<WR-ES/2,0,0>,<WR+ES/2,E,F-E>}
    object { l_stud translate <WR, WR, F> }
    object { l_stud translate <WR,-WR, F> }
    object { l_thruster_cone              translate < W,-WR,F-WR>}
    object { l_thruster_cone rotate -90*z translate <WR,- W,F-WR>}
    object { l_thruster_cone rotate 180*z translate < 0,-WR,F-WR>}
    translate <-WR, -WR, 0>
}
#declare l_thruster_n = object {l_thruster_s rotate 180*z}
#declare l_thruster_e = object {l_thruster_s rotate -90*z}
#declare l_thruster_w = object {l_thruster_s rotate  90*z}

// Antenna
#declare l_antenna = merge {
    difference {
#if (l_highq)
        union {
            torus {WR-C,C rotate -90*x translate (F-C)*z}
            cylinder {C*z,(F-C)*z,WR  }
            cylinder {  0,    F*z,WR-C}
            torus {WR-C,C rotate -90*x translate C*z}
        }
#else
        cylinder {   0,    F*z,WR}
#end
        cylinder {-E*z,(F-E)*z,SR}
    }
    object {l_stud translate F*z}
    cylinder {F*z,4*H*z,CSR}
    sphere {4*H*z,CSR}
}

#end    // end library include
