/*
  L_Slopes.inc
  created by Steven L. Reid
  v1.2  1 Sep 97

  This file defines slope and roof bricks centered on the right front stud.
  L_Standard.inc must be included first!

  v1.0 23 Jul 97 File created.
  v1.1 29 Aug 97 Removed redundant angle which changed naming convention.
  v1.2  1 Sep 97 Added library includes check.
*/

// POV-Ray Version
#version 3.0

#ifndef (L_Slopes)
    #declare L_Slopes = true
    // include library!

// Ensure required libraries are included
#ifndef (L_Standard)
    #include "L_Standard.inc"
#end


/*
 * 2 wide slopes (2x1, 2x2, 2x3, 2x4)
 */
#declare SX=2

// 2x1 slope
#declare SY=1
#declare l_s2x1w = #include "S_Slopes.inc"
#declare l_s1x2n = object {l_s2x1w rotate  90*z}
#declare l_s2x1e = object {l_s2x1w rotate 180*z translate <W,0,0>}
#declare l_s1x2s = object {l_s2x1w rotate 270*z translate <0,W,0>}

// 2x2 slope
#declare SY=2
#declare l_s2x2w = #include "S_Slopes.inc"
#declare l_s2x2n = object {l_s2x2w rotate  90*z translate <W,0,0>}
#declare l_s2x2e = object {l_s2x2w rotate 180*z translate <W,W,0>}
#declare l_s2x2s = object {l_s2x2w rotate 270*z translate <0,W,0>}

// 2x3 slope
#declare SY=3
#declare l_s2x3w = #include "S_Slopes.inc"
#declare l_s3x2n = object {l_s2x3w rotate  90*z translate <2*W,  0,0>}
#declare l_s2x3e = object {l_s2x3w rotate 180*z translate <  W,2*W,0>}
#declare l_s3x2s = object {l_s2x3w rotate 270*z translate <  0,  W,0>}

// 2x4 slope
#declare SY=4
#declare l_s2x4w = #include "S_Slopes.inc"
#declare l_s4x2n = object {l_s2x4w rotate  90*z translate <3*W,  0,0>}
#declare l_s2x4e = object {l_s2x4w rotate 180*z translate <  W,3*W,0>}
#declare l_s4x2s = object {l_s2x4w rotate 270*z translate <  0,  W,0>}

/*
 * 3 wide slopes  3x1, 3x2, 3x3, 3x4, 3x6
 */
#declare SX=3

// 3x1 slope
#declare SY=1
#declare l_s3x1w = #include "S_Slopes.inc"
#declare l_s1x3n = object {l_s3x1w rotate  90*z}
#declare l_s3x1e = object {l_s3x1w rotate 180*z translate <2*W,  0,0>}
#declare l_s1x3s = object {l_s3x1w rotate 270*z translate <  0,2*W,0>}

// 3x2 slope
#declare SY=2
#declare l_s3x2w = #include "S_Slopes.inc"
#declare l_s2x3n = object {l_s3x2w rotate  90*z translate <  W,  0,0>}
#declare l_s3x2e = object {l_s3x2w rotate 180*z translate <2*W,  W,0>}
#declare l_s2x3s = object {l_s3x2w rotate 270*z translate <  0,2*W,0>}

// 3x4 slope
#declare SY=4
#declare l_s3x4w = #include "S_Slopes.inc"
#declare l_s4x3n = object {l_s3x4w rotate  90*z translate <3*W,  0,0>}
#declare l_s3x4e = object {l_s3x4w rotate 180*z translate <2*W,3*W,0>}
#declare l_s4x3s = object {l_s3x4w rotate 270*z translate <  0,2*W,0>}

/*
 * 2 wide roofs (2x1, 2x2) (inverted slopes)
 */
#declare SX=2

// 2x1 roof
#declare SY=1
#declare l_r2x1w = #include "S_Roofs.inc"
#declare l_r1x2n = object {l_r2x1w rotate  90*z}
#declare l_r2x1e = object {l_r2x1w rotate 180*z translate <W,0,0>}
#declare l_r1x2s = object {l_r2x1w rotate 270*z translate <0,W,0>}

// 2x2 roof
#declare SY=2
#declare l_r2x2w = #include "S_Roofs.inc"
#declare l_r2x2n = object {l_r2x2w rotate  90*z translate <W,0,0>}
#declare l_r2x2e = object {l_r2x2w rotate 180*z translate <W,W,0>}
#declare l_r2x2s = object {l_r2x2w rotate 270*z translate <0,W,0>}

/*
 * 3 wide roofs (3x1, 3x2, 3x6) (inverted slopes)
 */
#declare SX=2
/* to be done! */
// 3x1 roof  check?

// 3x2 roof (remove stud holes in S_Roofs.inc before rendering)

// 3x6 roof (special declare)

/*
 * Special sloped bricks---Two slopes, corner, tops and ends
 */

#end    // end library include
