/*
  L_Rounds.inc
  created by Steven L. Reid
  v1.1  1 Sep 97

  This file defines round and cone shaped bricks centered on the right
  front stud.
  L_Standard.inc must be included first!

  v1.0  1 Aug 97 File created.
  v1.1  1 Sep 97 Added library includes check.
*/

// POV-Ray Version
#version 3.0

#ifndef (L_Rounds)
    #declare L_Rounds = true
    // include library!

// Ensure required libraries are included
#ifndef (L_Standard)
    #include "L_Standard.inc"
#end

// Round 1 Base
#declare l_round = intersection {
    merge {
#if (l_highq)
        torus {WR-C,C rotate -90*x translate (H-C)*z}
        cylinder { (SH+C)*z,(H-C)*z, WR }
        cylinder { SH*z,H*z, WR-C }
        torus {WR-C,C rotate -90*x translate (SH+C)*z}
        cylinder { C*z,SH*z, CBR   }
        cylinder { 0  ,SH*z, CBR-C }
        torus {CBR-C,C rotate -90*x translate C*z}
#else
        cylinder { SH*z, H*z, WR }
        cylinder {    0,SH*z, CBR }
#end
    }
    cylinder { -E*z, (H-E)*z, SR inverse}
}

// Round 1
#declare l_rd1 = merge {
    object {l_round}
    object { l_stud translate H*z }
    bounded_by {box{<-WR,-WR,0>,<WR,WR,H+F>}}
}

// Round 1 hole
#declare l_rd1h = merge {
    intersection {
        object {l_round}
        cylinder { 0, (H+E)*z, CSR inverse}
    }
    object { l_studh translate H*z }
    bounded_by {box{<-WR,-WR,0>,<WR,WR,H+F>}}
}

// Round 1 Flat
#declare l_rd1f = merge {
    intersection {
        union {
#if (l_highq)
            torus {WR-C,C rotate -90*x translate (F-C)*z}
            cylinder { (SH+C)*z,(F-C)*z, WR }
            cylinder { SH*z,F*z, WR-C }
            torus {WR-C,C rotate -90*x translate (SH+C)*z}
            cylinder { C*z,SH*z, CBR   }
            cylinder { 0  ,SH*z, CBR-C }
            torus {CBR-C,C rotate -90*x translate C*z}
#else
            cylinder { SH*z, F*z, WR }
            cylinder {    0,SH*z, CBR }
#end
        }
        cylinder { -E*z, (F-E)*z, SR inverse}
    }
    object { l_stud translate F*z }
    bounded_by {box{<-WR,-WR,0>,<WR,WR,F2>}}
}

// Round 2
#declare l_rd2 = merge {
    intersection {
#if (l_highq)
        union {
            torus {W-C,C rotate -90*x translate <W,W,H-C>}
            cylinder { <W,W,C>,<W,W,H-C>, W   }
            cylinder { <W,W,0>,<W,W,H  >, W-C }
            torus {W-C,C rotate -90*x translate <W,W,C>}
        }
#else
        cylinder { <W,W, 0>,<W,W,H  >, W   }
#end
        difference {
            cylinder { <W,W,  -E>,<W,W,H-E>, W-E }
            cylinder { <W,W,SH+C+G>,<W,W,  H>, SR }
            inverse
        }
        box { <E,E,-E>,<2*W-E,2*W-E,SH+C> inverse}
        object {l_axlecut translate <W,W,0> inverse}
    }
    object { l_stud translate <0.5*W,0.5*W,H> }
    object { l_stud translate <0.5*W,1.5*W,H> }
    object { l_stud translate <1.5*W,0.5*W,H> }
    object { l_stud translate <1.5*W,1.5*W,H> }
    object{ l_cb translate <W,W,0> }
    bounded_by {box{<0,0,0>,<2*W,2*W,H+F>}}
    translate <-WR, -WR, 0>
}

// Round 2 flat
#declare l_rd2f = merge {
    difference {
#if (l_highq)
        merge {
            torus {W-C,C rotate -90*x translate <W,W,F-C>}
            cylinder { <W,W,C>,<W,W,F-C>, W   }
            cylinder { <W,W,0>,<W,W,F  >, W-C }
            torus {W-C,C rotate -90*x translate <W,W,C>}
        }
#else
        cylinder { <W,W, 0>,<W,W,F  >, W   }
#end
        cylinder { <W,W,-E>,<W,W,F-E>, W-E }
        box { <E,E,-E>,<2*W-E,2*W-E,SH+C> }
        object {l_axlecut translate <W,W,0>}
    }
    object { l_stud translate <0.5*W,0.5*W,F> }
    object { l_stud translate <0.5*W,1.5*W,F> }
    object { l_stud translate <1.5*W,0.5*W,F> }
    object { l_stud translate <1.5*W,1.5*W,F> }
    object{ l_cbf translate <W,W,0> }
    translate <-WR, -WR, 0>
}

// Round Brace
#declare l_rdbrace = union {
    difference {
        union {
#if (l_highq)
            torus {W-C,C rotate -90*x translate <W,W,C>}
            cylinder { <W,W,C>,<W,W,F-C>, W   }
            cylinder { <W,W,0>,<W,W,F  >, W-C }
            torus {W-C,C rotate -90*x translate <W,W,F-C>}
            cylinder { <W,W,F>,<W,W,H-C>, WR }
            cylinder { <W,W,F>,<W,W,H  >, WR-C }
            torus {WR-C,C rotate -90*x translate <W,W,H-C>}
            cylinder { <W,W,  H   >,<W,W,2*H>, SR  }
            torus {W-C,C rotate -90*x translate <W,W,2*H-ES+C>}
            cylinder { <W,W,2*H-ES+C>,<W,W,2*H-C>, W }
            cylinder { <W,W,2*H-ES  >,<W,W,2*H  >, W-C }
            torus {W-C,C rotate -90*x translate <W,W,2*H-C>}
#else
            cylinder { <W,W,  0   >,<W,W,  F>, W   }
            cylinder { <W,W,  F   >,<W,W,  H>, WR }
            cylinder { <W,W,  H   >,<W,W,2*H>, SR  }
            cylinder { <W,W,2*H-ES>,<W,W,2*H>, W   }
#end
        }
        box { <E,E,-E>,<2*W-E,2*W-E,SH+C> }
        cylinder { <W,W,2*H-ES>,<W,W,2*H+E>, CSR }
        cylinder { <W,W,-E>,<W,W,H-E>,SD/2 }
    }
    object { l_studh translate <0.5*W,0.5*W,2*H> }
    object { l_studh translate <0.5*W,1.5*W,2*H> }
    object { l_studh translate <1.5*W,0.5*W,2*H> }
    object { l_studh translate <1.5*W,1.5*W,2*H> }
    object { l_cbf translate <W,W,0>}
    translate <-WR, -WR, 0>
}

// Cone 1
#declare l_cone1 = difference {
     merge {
        object {l_studh translate H*z}
        cone {SH*z, WR, H*z, SR}
#if (l_highq)
        cylinder {C*z, SH*z, CBR}
        cylinder {  0, SH*z, CBR-C}
        torus {CBR-C,C rotate -90*x translate C*z}
#else
        cylinder {0, SH*z, CBR}
#end
    }
    cylinder {-E*z,SH*z, SR}
    cylinder {-E*z,(H+G)*z, CSR}
    object {l_axlecut translate (-H-G+F)*z}
}

// Cone 2x2
#declare l_cone2x2 = union {
    difference {
        union {
            cone {SH*z,W 2*H*z,WR}
#if (l_highq)
            cylinder {C*z, SH*z, W}
            cylinder {  0, SH*z, W-C}
            torus {W-C,C rotate -90*x translate C*z}
#else
            cylinder {0,SH*z,W}
#end
        }
        box {<-W+E,-W+E,-E>,<W-E,W-E,SH+C>}
        cone {SH*z,W-E (2*H-E)*z,WR-E}
    }
    object {l_cb2}
    object {l_stud translate 2*H*z}
    translate <WR, WR, 0>
}

// Cone 4x2
#declare l_cone4x2 = union {
    difference {
        union {
            cone {SH*z,2*W 2*H*z,W}
#if (l_highq)
            cylinder {C*z, SH*z, 2*W}
            cylinder {  0, SH*z, 2*W-C}
            torus {2*W-C,C rotate -90*x translate C*z}
#else
            cylinder {0,SH*z, 2*W}
#end
        }
        cone {SH*z,2*W-E (2*H-E)*z,W-E}
        cylinder {-G*z,(SH+C)*z, 2*W-ES}
        cylinder {                                  // stud cutout
            -G*z, (SH+C)*z,  SR
            translate <0.5*W,0.5*W,0>
        }
        cylinder {                                  // stud cutout
            -G*z, (SH+C)*z,  SR
            translate <0.5*W,3.5*W,0>
        }
        cylinder {                                  // stud cutout
            -G*z, (SH+C)*z,  SR
            translate <3.5*W,0.5*W,0>
        }
        cylinder {                                  // stud cutout
            -G*z, (SH+C)*z,  SR
            translate <3.5*W,3.5*W,0>
        }
        translate <2*W,2*W,0>
    }
    union { // bottom cylinders
        object { l_cb2 translate <2*W,  W,0> }
        object { l_cb2 translate <  W,2*W,0> }
        object { l_cb2 translate <2*W,2*W,0> }
        object { l_cb2 translate <3*W,2*W,0> }
        object { l_cb2 translate <2*W,3*W,0> }
        clipped_by{
            cone {<2*W,2*W,0>,2*W <2*W,2*W,2*H-E>, W-E}
        }
    }
    object { l_stud translate <1.5*W,1.5*W,2*H> }
    object { l_stud translate <1.5*W,2.5*W,2*H> }
    object { l_stud translate <2.5*W,1.5*W,2*H> }
    object { l_stud translate <2.5*W,2.5*W,2*H> }
    translate <-WR, -WR, 0>
}

// Curved corner
#declare l_curve_se = union {
#if (l_highq)
    intersection {
        union {
             intersection {   // curved edges
                union {
                    torus { 2*W-C,C rotate -90*x translate (H-C)*z }
                    torus {   W+C,C rotate -90*x translate (H-C)*z }
                    intersection {    // top & bottom
                        cylinder {    0,      H*z, 2*W-C }
                        cylinder { -G*z,  (H+G)*z,   W+C inverse}
                    }
                    intersection {    // curved sides
                        cylinder {  C*z,  (H-C)*z, 2*W }
                        cylinder { -G*z,  (H+G)*z,   W inverse}
                    }
                    torus { 2*W-C,C rotate -90*x translate C*z }
                    torus {   W+C,C rotate -90*x translate C*z }
                }
                box { <C,C,-G>,<2*W,2*W,H+G>}
            }
            // Edges
            intersection {
                cylinder {  C*z,  (H-C)*z, 2*W-C }
                cylinder { -G*z,  (H+G)*z,   W+C inverse}
                box { <0,0,-G>,<2*W,2*W,H+G>}
            }
            sphere { <  W+C,C,  C>,C }
            sphere { <2*W-C,C,  C>,C }
            sphere { <  W+C,C,H-C>,C }
            sphere { <2*W-C,C,H-C>,C }
            cylinder { C*z,(H-C)*z,C translate <  W+C,C,0> }
            cylinder { C*z,(H-C)*z,C translate <2*W-C,C,0> }
            cylinder { C*x,(W-C)*x,C translate <W,C,  C> }
            cylinder { C*x,(W-C)*x,C translate <W,C,H-C> }
            sphere { <C,  W+C,  C>,C }
            sphere { <C,2*W-C,  C>,C }
            sphere { <C,  W+C,H-C>,C }
            sphere { <C,2*W-C,H-C>,C }
            cylinder { C*z,(H-C)*z,C translate <C,  W+C,0> }
            cylinder { C*z,(H-C)*z,C translate <C,2*W-C,0> }
            cylinder { C*y,(W-C)*y,C translate <C,W,  C> }
            cylinder { C*y,(W-C)*y,C translate <C,W,H-C> }
        }
        cylinder {                                  // stud cutout
            -G*z, (SH+C)*z,  SR
            translate <1.5*W,1.5*W,0>
            inverse
        }
        intersection {                              // bottom hole
            box { <E,E,-G>,<2*W-E,2*W-E,H-E> }
            cylinder { -E*z, H*z, 2*W-CBR+SR }
            cylinder { -E*z, H*z, W+E+CBR-SR inverse }
            inverse
        }
    }
#else
    intersection {
        box { 0,<2*W,2*W,H> }
        cylinder { -G*z,  (H+G)*z, 2*W }            // main cylinder
        cylinder { -G*z,  (H+G)*z,   W inverse }    // rd2 cutout
        cylinder {                                  // stud cutout
            -G*z, (SH+C)*z,  SR
            translate <1.5*W,1.5*W,0> inverse
        }
        intersection {                              // bottom hole
            box { <E,E,-G>,<2*W-E,2*W-E,H-E> }
            cylinder { -E*z, H*z, 2*W-CBR+SR }
            cylinder { -E*z, H*z, W+E+CBR-SR inverse }
            inverse
        }
    }
#end

    object { l_stud translate <1.5*W,0.5*W,H> }
    object { l_stud translate <0.5*W,1.5*W,H> }
    translate <-WR, -WR, 0>
}
#declare l_curve_sw = object { l_curve_se rotate  90*z translate <W,0,0> }
#declare l_curve_ne = object { l_curve_se rotate -90*z translate <0,W,0> }
#declare l_curve_nw = object { l_curve_se rotate 180*z translate <W,W,0> }

// Radar dish 4 wide
#declare l_radardish4 = union {
#if (l_highq)
    difference {
        union {
            cylinder {(C-TE)*z,F2*z,2*W  }
            cylinder {   -TE*z, F2*z,2*W-C}
            torus {2*W-C,C rotate -90*x translate (C-TE)*z}
        }
        sphere {(F2-3)*z,3 inverse}
        intersection {
            sphere {(F2-3-E)*z,3}
            cylinder {-E*z,H*z,2*W-ES}
        }
    }
#else
    difference {
        cylinder {-TE*z,F2*z,2*W}
        sphere {(F2-3)*z,3 inverse}
        intersection {
            sphere {(F2-3-E)*z,3}
            cylinder {-E*z,H*z,2*W-ES}
        }
    }
#end
    difference {
        union {
#if (l_highq)
            cylinder { (SH+C)*z,(F2-C-E)*z, WR }
            cylinder { SH*z,(F2-E)*z, WR-C }
            torus {WR-C,C rotate -90*x translate (SH+C)*z}
            cylinder { C*z,SH*z, CBR   }
            cylinder { 0  ,SH*z, CBR-C }
            torus {CBR-C,C rotate -90*x translate C*z}
#else
            cylinder { SH*z,(F2-E)*z, WR }
            cylinder {    0,SH*z, CBR }
#end
        }
        cylinder {-E*z,SH*z, SR}
        object {l_axlecut translate (-H-G+F2-E)*z}
    }
    object { l_stud translate F2*z }
}

#end    // end library incude
