/*
  L_Plates.inc
  created by Steven L. Reid
  v1.0  7 Oct 97

  This file defines base plates centered on the right front stud.
  L_Standard.inc must be included first!

  v1.0 7 Oct 97 File created.
*/

// POV-Ray Version
#version 3.0

#ifndef (L_Plates)
    #declare L_Plates = true
    // include library!

// Ensure required libraries are included
#ifndef (L_Standard)
    #include "L_Standard.inc"
#end

// Road Plate
#declare l_road_plate = union {
    union {
        // plate
        #declare SX = 32
        #declare SY = 32
        #declare SZ = ES
        #include "S_Box.inc"
        // studs
        #declare s_row = 32
        #while (s_row > 0)
            #declare s_col = 32
            #while (s_col > 0)
                object { l_stud translate <s_row*W-W/2, s_col*W-W/2, ES> }
                #declare s_col = s_col-1
            #end
            #declare s_row = s_row-1
            #if (s_row = 23)
                #declare s_row = 9
            #end
        #end
        texture {l_gray}
    }
    union { // white lines
        // median
        #declare s_col = 0
        #declare SX = 6/5*W
        #while (s_col < 25)
            box {<16*W-SR,s_col     ,ES>,<16*W+SR,s_col+  W,ES+G>}
            box {<16*W-SR,s_col+W+SX,ES>,<16*W+SR,s_col+2*W+SX,ES+G>}
            #declare s_col=s_col+2*W+SX
        #end
        // cross walk
        #declare s_col = 0
        #declare SX = 12*W/28
        #while (s_col < 11*W)
            box {<10*W+SX+s_col,24*W,ES>,<10*W+3*SX+s_col,27*W,ES+G>}
            #declare s_col = s_col+SX*3
        #end
        texture {l_white}
    }
    union { // green lines
        box {< 9*W+E,0,ES>,<10*W-E,32*W,ES+G>}
        box {<22*W+E,0,ES>,<23*W-E,32*W,ES+G>}
        texture {l_green}
    }
    translate <-WR,-WR,0>
}

#end    // end library include
