/*
  L_Plane.inc
  created by Steven L. Reid
   v1.2 25 Jan 98

  This file defines air plane style bricks centered on the right front stud.
  L_Standard.inc and L_Flats.inc must be included first!

  v1.0 30 Aug 97 File created.
  v1.1  1 Sep 97 Added library includes check.
  v1.2 25 Jan 98 Added old propellers.
*/

// POV-Ray Version
#version 3.0

#ifndef (L_Plane)
    #declare L_Plane = true
    // include library!

// Ensure required libraries are included
#ifndef (L_Standard)
    #include "L_Standard.inc"
#end
#ifndef (L_Flats)
    #include "L_Flats.inc"
#end

// Tail
#declare s_tailcut = difference {
    box {<0,E,-G>,<W,W-E,F2>}
    plane { x,0 rotate  25*z translate   <E-C,WR,0>}
    plane { x,0 rotate -25*z translate   <E-C,WR,0>}
    plane {-x,0 rotate -25*z translate <W-E+C,WR,0>}
    plane {-x,0 rotate  25*z translate <W-E+C,WR,0>}
}
#declare l_tail_w = union {
    difference {
        box { <0,WR,0>,<3*W,1.5*W,SH> }
        object{ s_tailcut translate <  0,0,0> }
        object{ s_tailcut translate <  W,0,0> }
        object{ s_tailcut translate <2*W,0,0> }
        object{ s_tailcut translate <  0,W,0> }
        object{ s_tailcut translate <  W,W,0> }
        object{ s_tailcut translate <2*W,W,0> }
        plane { -x,0 rotate -45*z translate <3*W,  W-SH/2,0>}
        plane { -x,0 rotate  45*z translate <3*W,2*W+SH/2,0>}
    }
    object {
        #declare SX = 2
        #declare SY = 2
        #declare SZ = ES
        #include "S_Box.inc"
        translate <-W,0,2*H-ES>
    }
    object {l_studh translate <-WR,0.5*W,2*H> }
    object {l_studh translate < WR,0.5*W,2*H> }
    object {l_studh translate <-WR,1.5*W,2*H> }
    object {l_studh translate < WR,1.5*W,2*H> }
    polygon {   // left side
        5,
        <  0,W-SH/2, SH  >,
        <3*W,W-SH/2, SH  >,
        <  W,W-SH/2,2*H-C>,
        < -W,W-SH/2,2*H-C>,
        <  0,W-SH/2, SH  >
    }
    polygon {   // right side
        5,
        <  0,W+SH/2, SH  >,
        <3*W,W+SH/2, SH  >,
        <  W,W+SH/2,2*H-C>,
        < -W,W+SH/2,2*H-C>,
        <  0,W+SH/2, SH  >
    }
    polygon {   // back
        5,
        <  0,W-SH/2, SH  >,
        < -W,W-SH/2,2*H-C>,
        < -W,W+SH/2,2*H-C>,
        <  0,W+SH/2, SH  >,
        <  0,W-SH/2, SH  >
    }
    polygon {   // front
        5,
        <3*W,W-SH/2, SH  >,
        <  W,W-SH/2,2*H-C>,
        <  W,W+SH/2,2*H-C>,
        <3*W,W+SH/2, SH  >,
        <3*W,W-SH/2, SH  >
    }
    translate <-WR,-WR,0>
}
// different orientations
#declare l_tail_s = object {l_tail_w rotate z*-90 translate < 0,W,0>}
#declare l_tail_n = object {l_tail_w rotate z* 90 translate <2*W, 0,0>}
#declare l_tail_e = object {l_tail_w rotate z*180 translate <2*W,W,0>}

// Wing 8x4 Angles
#declare A = degrees(atan2((3*W),(7*W-SH)))
#declare AX = C*sin(radians(90-A))
#declare AY = C*cos(radians(90-A))

// Wing 8x4 right
#declare l_wing8x4r = union {
    difference {
        union {
            object {
                #declare SX = 8
                #declare SY = 3
                #declare SZ = F
                #include "S_Box.inc"
            }
            object {
                #declare SX = 4
                #declare SY = 2
                #declare SZ = F
                #include "S_Box.inc"
                translate <W,2*W,0>
            }
        }
#if (l_highq)
        plane{-y,0 rotate -A*z translate <8*W-C+AY,W-C+AX,0>}
        difference {
            plane{-y,0 rotate -A*z translate <8*W-C,W-C,0>}
            box {<8*W-C+AY,W-C+AX,C>,<W+SH-C+AY,4*W-C+AX,F-C>}
            plane {y,0 translate (W-C)*y}
            plane {x,0 translate (W+SH-C)*x}
        }
#else
        plane {-y,0 rotate -A*z translate <8*W,W,0>}
#end
        difference {
            union {
                box {<E,E,-G>,<8*W-E,3*W-E,E>}
                box {<W+E,3*W-C,-G>,<4*W,4*W,E>}
            }
            plane {-y,0 rotate -A*z translate <8*W-E,W,0>}
        }
    }
#if (l_highq)
    sphere {0,C translate < 8*W-C,  W-C,  C>}
    sphere {0,C translate < 8*W-C,  W-C,F-C>}
    sphere {0,C translate <W+SH-C,4*W-C,  C>}
    sphere {0,C translate <W+SH-C,4*W-C,F-C>}
    cylinder {C*z,(F-C)*z,C translate < 8*W-C,  W-C,0>}
    cylinder {C*z,(F-C)*z,C translate <W+SH-C,4*W-C,0>}
    cylinder {<8*W-C,W-C,  C>,<W+SH-C,4*W-C,  C>,C}
    cylinder {<8*W-C,W-C,F-C>,<W+SH-C,4*W-C,F-C>,C}
#end
    // Top
    object {l_stud translate <0.5*W,0.5*W,F>}
    object {l_stud translate <0.5*W,1.5*W,F>}
    object {l_stud translate <0.5*W,2.5*W,F>}
    object {l_stud translate <1.5*W,0.5*W,F>}
    object {l_stud translate <1.5*W,1.5*W,F>}
    object {l_stud translate <1.5*W,2.5*W,F>}
    object {l_stud translate <2.5*W,0.5*W,F>}
    object {l_stud translate <2.5*W,1.5*W,F>}
    object {l_stud translate <2.5*W,2.5*W,F>}
    object {l_stud translate <3.5*W,0.5*W,F>}
    object {l_stud translate <3.5*W,1.5*W,F>}
    object {l_stud translate <3.5*W,2.5*W,F>}
    object {l_stud translate <4.5*W,0.5*W,F>}
    object {l_stud translate <4.5*W,1.5*W,F>}
    object {l_stud translate <5.5*W,0.5*W,F>}
    object {l_stud translate <5.5*W,1.5*W,F>}
    object {l_stud translate <6.5*W,0.5*W,F>}
    object {l_stud translate <7.5*W,0.5*W,F>}
    // Bottom
    object {l_csf translate <7*W,0.5*W,0>}
    object {l_cbf translate <1*W,1*W,0>}
    object {l_cbf translate <2*W,1*W,0>}
    object {l_cbf translate <3*W,1*W,0>}
    object {l_cbf translate <4*W,1*W,0>}
    object {l_cbf translate <5*W,1*W,0>}
    object {l_cbf translate <6*W,1*W,0>}
    object {l_cbf translate <1*W,2*W,0>}
    object {l_cbf translate <2*W,2*W,0>}
    object {l_cbf translate <3*W,2*W,0>}
    object {l_cbf translate <4*W,2*W,0>}
    translate <-WR,-WR,0>
}

// Wing 8x4 left
#declare l_wing8x4l = union {
    difference {
        union {
            object {
                #declare SX = 8
                #declare SY = 3
                #declare SZ = F
                #include "S_Box.inc"
                translate W*y
            }
            object {
                #declare SX = 4
                #declare SY = 2
                #declare SZ = F
                #include "S_Box.inc"
                translate W*x
            }
        }
#if (l_highq)
        plane{y,0 rotate A*z translate <8*W-C+AY,3*W+C-AX,0>}
        difference {
            plane{y,0 rotate A*z translate <8*W-C,3*W+C,0>}
            box {<8*W-C+AY,3*W+C-AX,C>,<W+SH-C+AY,C-AX,F-C>}
            plane {-y,0 translate (3*W+C)*y}
            plane {x,0 translate (W+SH-C)*x}
        }
#else
        plane {y,0 rotate A*z translate <8*W,3*W,0>}
#end
        difference {
            union {
                box {<E,W+E,-G>,<8*W-E,4*W-E,E>}
                box {<W+E,W+C,-G>,<4*W,0,E>}
            }
            plane {y,0 rotate A*z translate <8*W-E,3*W,0>}
        }
    }
#if (l_highq)
    sphere {0,C translate < 8*W-C,3*W+C,  C>}
    sphere {0,C translate < 8*W-C,3*W+C,F-C>}
    sphere {0,C translate <W+SH-C,    C,  C>}
    sphere {0,C translate <W+SH-C,    C,F-C>}
    cylinder {C*z,(F-C)*z,C translate < 8*W-C,3*W+C,0>}
    cylinder {C*z,(F-C)*z,C translate <W+SH-C,    C,0>}
    cylinder {<8*W-C,3*W+C,  C>,<W+SH-C,C,  C>,C}
    cylinder {<8*W-C,3*W+C,F-C>,<W+SH-C,C,F-C>,C}
#end
    // Top
    object {l_stud translate <0.5*W,1.5*W,F>}
    object {l_stud translate <0.5*W,2.5*W,F>}
    object {l_stud translate <0.5*W,3.5*W,F>}
    object {l_stud translate <1.5*W,1.5*W,F>}
    object {l_stud translate <1.5*W,2.5*W,F>}
    object {l_stud translate <1.5*W,3.5*W,F>}
    object {l_stud translate <2.5*W,1.5*W,F>}
    object {l_stud translate <2.5*W,2.5*W,F>}
    object {l_stud translate <2.5*W,3.5*W,F>}
    object {l_stud translate <3.5*W,1.5*W,F>}
    object {l_stud translate <3.5*W,2.5*W,F>}
    object {l_stud translate <3.5*W,3.5*W,F>}
    object {l_stud translate <4.5*W,2.5*W,F>}
    object {l_stud translate <4.5*W,3.5*W,F>}
    object {l_stud translate <5.5*W,2.5*W,F>}
    object {l_stud translate <5.5*W,3.5*W,F>}
    object {l_stud translate <6.5*W,3.5*W,F>}
    object {l_stud translate <7.5*W,3.5*W,F>}
    // Bottom
    object {l_csf translate <7*W,3.5*W,0>}
    object {l_cbf translate <1*W,3*W,0>}
    object {l_cbf translate <2*W,3*W,0>}
    object {l_cbf translate <3*W,3*W,0>}
    object {l_cbf translate <4*W,3*W,0>}
    object {l_cbf translate <5*W,3*W,0>}
    object {l_cbf translate <6*W,3*W,0>}
    object {l_cbf translate <1*W,2*W,0>}
    object {l_cbf translate <2*W,2*W,0>}
    object {l_cbf translate <3*W,2*W,0>}
    object {l_cbf translate <4*W,2*W,0>}
    translate <-WR,-WR,0>
}
// Wing 8x4 Rotations (no right or left)
#declare l_wing8x4_nw = object {l_wing8x4r}
#declare l_wing4x8_sw = object {l_wing8x4r rotate -90*z}
#declare l_wing4x8_ne = object {l_wing8x4r rotate  90*z translate 3*W*x}
#declare l_wing8x4_se = object {l_wing8x4r rotate 180*z translate <8*W,3*W,0>}
#declare l_wing8x4_sw = object {l_wing8x4l}
#declare l_wing4x8_se = object {l_wing8x4l rotate -90*z}
#declare l_wing4x8_nw = object {l_wing8x4l rotate  90*z translate 3*W*x}
#declare l_wing8x4_ne = object {l_wing8x4l rotate 180*z translate <8*W,3*W,0>}

// Engine (need l_highq and replace box cuts with planes!)
#declare l_engine_s = union {
    object {l_br2x1f}
    difference {
        box {<0,0,  0>,<2*W,-.3,.2>}
        box {<0,0,-.2>,<-.4,-.6,.4> rotate -33.69*z}
        box {<0,0,-.2>,< .4,-.6,.4> rotate  33.69*z translate <2*W,0,0>}
        translate <-WR,-WR,.08>
    }
    cylinder {0,1.2*x, .45 translate <.2-WR,-.75-WR,.25>}
    difference {
        cone {0,.45,-.9*x,SR+.1}
        cylinder {0,-1*x,SR}
        translate <.2-WR,-.75-WR,.25>
    }
    difference {
        cone {0,.45,.9*x,SR+.1}
        cylinder {0,1*x,SR}
        translate <-.2+2*W-WR,-.75-WR,.25>
    }
}
// other engines
#declare l_engine_w = object {l_engine_s rotate z*90}
#declare l_engine_n = object {l_engine_s rotate z*180 translate <W,0,0>}
#declare l_engine_e = object {l_engine_s rotate z*-90 translate <0,W,0>}

// Propeller, small, old (need highq)
#declare l_prop_sm_old = difference {
    union {
        cylinder {0,F2*x,WR}
        union {
            box {<-.25,-.1,0>,<.25,.1,1.4>}
            cylinder {<0,-.1,1.4>,<0,.1,1.4>,.25}
            rotate -z*60
            translate WR*x
        }
        union {
            box {<-.25,-.1,0>,<.25,.1,-1.4>}
            cylinder {<0,-.1,-1.4>,<0,.1,-1.4>,.25}
            rotate z*60
            translate WR*x
        }
    }
    cylinder {-x,x,CBR}
    rotate -45*x
}

// Propeller angle
#declare l_prop2x2w = union {
    object {l_br2x2f}
    difference {
        box {<2*W,0,0>,<2*W+.6,2*W,H+F>}
        box {
            <-G,-G,0>,<.6,2*W+G,-.5>
            rotate -y*27.41 translate <2*W+E,0,0>
        }
        box {
            <-G,-G,0>,<.6,2*W+G, .5>
            rotate  y*27.41 translate <2*W+E,0,H+F>
        }
        box {
            <-G,0,-G>,<.6,-.5,2*H>
            rotate  z*41.63 translate <2*W+E,0,0>
        }
        box {
            <-G,0,-G>,<.6, .5,2*H>
            rotate -z*41.63 translate <2*W+E,2*W,0>
        }
        translate <-WR,-WR,0>
    }
    difference {
        union {
            cylinder {       0,ES*x,CBR  }
            cylinder {       0,F2*x,CBR-C}
            cylinder {(F2-E)*x,F2*x,CBR  }
        }
        cylinder {-x,x,CBR-ES}
        box {<E,-.05,-1>,<1,.05,1>}
        translate <1.5*W+.6,WR,.63>
    }
}
#declare l_prop2x2n = object {l_prop2x2w rotate  90*z translate <W,0,0>}
#declare l_prop2x2e = object {l_prop2x2w rotate 180*z translate <W,W,0>}
#declare l_prop2x2s = object {l_prop2x2w rotate 270*z translate <0,W,0>}
// with propeller
#declare l_prop2x2w_sm = union {
    object {l_prop2x2w}
    object {l_prop_sm_old translate <2*W+.2,WR,.63> texture{l_gray}}
}
#declare l_prop2x2n_sm = object {l_prop2x2w_sm rotate  90*z translate <W,0,0>}
#declare l_prop2x2e_sm = object {l_prop2x2w_sm rotate 180*z translate <W,W,0>}
#declare l_prop2x2s_sm = object {l_prop2x2w_sm rotate 270*z translate <0,W,0>}

// Propeller, large, old
#declare l_prop_lg_old = difference {
    union {
        object {l_br2x1f translate <   W,   0,F>}
        object {l_br2x1f translate <-2*W,   0,F>}
        object {l_br1x2f translate <   0,   W,F>}
        object {l_br1x2f translate <   0,-2*W,F>}
        object {
            #declare SX = 1.125
            #declare SY = 1
            #declare SZ = F
            #include "S_Box.inc"
            translate <-WR-.05,-WR,F>
        }
        object {
            #declare SX = 1
            #declare SY = 1.125
            #declare SZ = F
            #include "S_Box.inc"
            translate <-WR,-WR-.05,F>
        }
        object {
            #declare SX = 1
            #declare SY = 1
            #declare SZ = F2
            #include "S_Box.inc"
            translate <-WR,-WR,0>
        }
    }
    cylinder {-z,z,SR}
}

// Propeller base
#declare l_prop3x2f = union {
    object {l_br3x2f}
    difference {
        union {
            cylinder {<W,WR,F  >,<W,WR,F2-ES>,CBR  }
            cylinder {<W,WR,F  >,<W,WR,    H>,CBR-C}
            cylinder {<W,WR,H-E>,<W,WR,    H>,CBR  }
        }
        cylinder {<W,WR,0>,<W,WR,1>,CSR}
        box {<0,.05,F2+ES>,<-1,-.05,1> rotate   0*z translate <W,WR,0>}
        box {<0,.05,F2+ES>,<-1,-.05,1> rotate 120*z translate <W,WR,0>}
        box {<0,.05,F2+ES>,<-1,-.05,1> rotate 240*z translate <W,WR,0>}
    }
}
#declare l_prop2x3f = object {l_prop3x2f rotate 90*z translate W*x}

#end    // end library include
