/*
  L_Other.inc
  created by Steven L. Reid
  v1.0 29 Jun 98

  This file defines other bricks centered on the right front stud.
  L_Standard.inc and L_Flats.inc must be included first!

  v1.0 29 Jun 98 File created.
*/

// POV-Ray Version
#version 3.0

#ifndef (L_Other)
    #declare L_Other = true
    // include library!

// Ensure required libraries are included
#ifndef (L_Standard)
    #include "L_Standard.inc"
#end
//#ifndef (L_Flats)
//    #include "L_Flats.inc"
//#end

/*
 * Arches
 */

// Arch 4x1
#declare l_arch4x1 = union {
    difference {
        #declare SX = 4 #declare SY = 1 #declare SZ = H
        #include "S_Box.inc"
        // cut out
        box {<E,E,-G>,<W-E,W-E,H-E>}
        box {<3*W+E,E,-G>,<4*W-E,W-E,H-E>}
        cylinder {
            <0,-1,0>,<0,1,0>,1
            scale <W,1,F2>
            translate <2*W,0,0>
        }
        box {<W,E,-G>,<3*W,W-E,H-E>}
    }
    object {l_stud translate <0.5*W,WR,H>}
    object {l_stud translate <1.5*W,WR,H>}
    object {l_stud translate <2.5*W,WR,H>}
    object {l_stud translate <3.5*W,WR,H>}
    translate <-WR,-WR,0>
}
#declare l_arch1x4 = object {l_arch4x1 rotate z*90}


/*
 * Hooks and Hoops
 */

// Square Hook
#declare l_hook1x1f = union {
    #declare SX = 1 #declare SY = 1 #declare SZ = F
    object {#include "S_Bricks.inc" translate <WR,WR,0>}
#if (l_highq)
    #declare SX = (WR-CSR+2*C)/W #declare SY = (W-F)/W #declare SZ = F
    object {#include "S_Box.inc" translate <W-2*C,E,0>}
    difference {
        merge {
            torus {CBR-C,C rotate 90*x translate <W+WR,WR,C>}
            torus {CSR+C,C rotate 90*x translate <W+WR,WR,C>}
            difference {
                cylinder {<W+WR,WR,C>,<W+WR,WR,F-C>,CBR}
                cylinder {<W+WR,WR,-G>,<W+WR,WR,F+G>,CSR}
            }
            difference {
                cylinder {<W+WR,WR,0>,<W+WR,WR,F  >,CBR-C}
                cylinder {<W+WR,WR,-G>,<W+WR,WR,F+G>,CSR+C}
            }
            torus {CBR-C,C rotate 90*x translate <W+WR,WR,F-C>}
            torus {CSR+C,C rotate 90*x translate <W+WR,WR,F-C>}
        }
        box {<W+WR,0,-G>,<2*W,1,H>}
    }
    #declare SX = (CSR+C)/W
    #declare SY = (CBR-CSR)/W
    #declare SZ = F
    object {#include "S_Box.inc" translate <W+WR-C,WR-CBR,0>}
    object {#include "S_Box.inc" translate <W+WR-C,WR+CSR,0>}
#else
    box {<W,E,0>,<W+WR-CSR,W-E,F>}
    difference {
        cylinder {<W+WR,WR,0>,<W+WR,WR,F>,CBR}
        cylinder {<W+WR,WR,-G>,<W+WR,WR,F+G>,CSR}
        box {<W+WR,0,-G>,<2*W,1,H>}
    }
    box {<W+WR,WR+CBR,0>,<W+WR+CSR,WR+CSR,F>}
    box {<W+WR,WR-CBR,0>,<W+WR+CSR,WR-CSR,F>}
#end
    translate <-WR,-WR,0>
}
#declare l_hook1x1f_s = object {l_hook1x1f rotate z*-90}
#declare l_hook1x1f_n = object {l_hook1x1f rotate z*90}
#declare l_hook1x1f_w = object {l_hook1x1f}
#declare l_hook1x1f_e = object {l_hook1x1f rotate z*180}

// Brick with upwards hook
#declare l_hook1x1up = difference {
    union {         // could replace with l_br1x1f
        #declare SX = 1 #declare SY = 1 #declare SZ = F
        #include "S_Box.inc"
        #declare SX = (W-F)/2/W #declare SY = 1 #declare SZ = CSR+4*C
        object {#include "S_Box.inc" translate <WR-E,0,F-2*C>}
        #declare SX = (W-F)/2/W #declare SY = (W-CSD)/2/W #declare SZ = CSR+C
        object {#include "S_Box.inc" translate <WR-E,     0,F+CSR>}
        object {#include "S_Box.inc" translate <WR-E,WR+CSR,F+CSR>}
    }
    box {<E,E,-G>,<W-E,W-E,F-E>}    // l_br1x1f bottom cut-out
    cylinder {<0,WR,F+CSR>,<1,WR,F+CSR>,CSR}
    translate <-WR,-WR,0>
}
#declare l_hook1x1up_ns = object {l_hook1x1up rotate z*90}
#declare l_hook1x1up_ew = object {l_hook1x1up }

// Hoop
#declare l_hoop1x1f = union {
    #declare SX = 1 #declare SY = 1 #declare SZ = F
    #include "S_Bricks.inc"
    difference {
        merge {
            #declare SX = (WR-E)/2 #declare SY = (WR+4*C) #declare SZ = F
            object{#include "S_Box.inc" translate <WR-E,-WR+2*C,0>}
#if (l_highq)
            torus {SR-C,C rotate 90*z translate <WR-E-SH+C,-WR,E>}
            cylinder{<WR-E-SH+C,-WR,E>,<WR+E+SH-C,-WR,E>,SR  }
            cylinder{<WR-E-SH  ,-WR,E>,<WR+E+SH  ,-WR,E>,SR-C}
            torus {SR-C,C rotate 90*z translate <WR+E+SH-C,-WR,E>}
            torus {CBR-C,C rotate 90*z translate <WR-E+C,-WR,E>}
            cylinder{<WR-E+C,-WR,E>,<WR+E-C,-WR,E>,CBR  }
            cylinder{<WR-E  ,-WR,E>,<WR+E  ,-WR,E>,CBR-C}
            torus {CBR-C,C rotate 90*z translate <WR+E-C,-WR,E>}
#else
            cylinder{<WR-E-SH,-WR,E>,<WR+E+SH,-WR,E>,SR}
            cylinder{<WR-E,-WR,E>,<WR+E,-WR,E>,CBR}
#end
        }
        cylinder{<-G,-WR,E>,<W+G,-WR,E>,CSR}
        translate <-WR,-WR,0>
    }
}
#declare l_hoop1x1f_e = object {l_hoop1x1f rotate z*-90}
#declare l_hoop1x1f_w = object {l_hoop1x1f rotate z*90}
#declare l_hoop1x1f_s = object {l_hoop1x1f}
#declare l_hoop1x1f_n = object {l_hoop1x1f rotate z*180}


/*
 * Other Bricks
 */

// Brick with side stud
#declare l_bst1x1 = union {
    difference {
        merge {
            #declare SX = (W-E)/W #declare SY = 1 #declare SZ = H
            #include "S_Box.inc"
            #declare SX = (E+2*C)/W #declare SY = 1  #declare SZ = H-W
            object{#include "S_Box.inc" translate (W-E-2*C)*x}
        }
        box {<E,E,-G>,<W-E,W-E,H-W-G>}
        box {<E+.1,E,0>,<W-E-.1,W-E,H-E>}
        box {<-G,E,H-WR+SR>,<WR,W-E,H-WR-SR>}
        cylinder {<W,WR,H-WR>,<E+G,WR,H-WR>,SR}
    }
    object {l_stud translate <WR,WR,H>}
    object {l_studh rotate y*90 translate <W-E,WR,H-WR>}
    translate <-WR,-WR,0>
}
#declare l_bst1x1s = object {l_bst1x1 rotate -90*z}
#declare l_bst1x1n = object {l_bst1x1 rotate  90*z}
#declare l_bst1x1w = object {l_bst1x1}
#declare l_bst1x1e = object {l_bst1x1 rotate 180*z}

// Big Rock
#declare l_big_rock = union {
    difference {
        merge {
            box {<  0,  0,  0>,<8*W,  W,  H>}
            box {<  W,  W,  0>,<7*W,3*W,  H>}
            box {<  0,  W,  H>,<8*W,3*W,2*H>}
            box {<  W,  0,  H>,<4*W,  W,3*H>}
            box {<5*W,  0,  H>,<7*W,  W,3*H>}
            box {<  W,  W,2*H>,<7*W,3*W,4*H>}
            box {<2*W,  0,3*H>,<3*W,  W,4*H>}
            box {<5*W,  0,3*H>,<6*W,  W,4*H>}
            box {<2*W,  W,4*H>,<6*W,3*W,5*H>}
            box {<3*W,  W,5*H>,<5*W,2*W,6*H>}
            box {<2*W,2*W,5*H>,<6*W,3*W,6*H>}
            box {<3*W,2*W,6*H>,<5*W,3*W,7*H>}
        }
        box {<2*W    ,  W  ,   -G  >,<6*W    ,4*W,  H/2  >}
        box {<  W+E  ,    E,  F  >,<4*W-E  ,4*W,3*H-E>}
        box {<4*W-E-G,    E,  F  >,<5*W+E+G,4*W,  H-E>}
        box {<5*W+E  ,    E,  F  >,<7*W-E  ,4*W,3*H-E>}
        box {<  W+E+G,  W+E,  F+G>,<7*W-E+G,4*W,4*H-E>}
        box {<2*W+E  ,    E,3*H-E-G>,<3*W-E  ,4*W,4*H-E>}
        box {<5*W+E  ,    E,3*H-E-G>,<6*W-E  ,4*W,4*H-E>}
        box {<2*W+E  ,  W+E,4*H-E-G>,<6*W-E  ,4*W,5*H-E>}
        box {<2*W+E  ,2*W+E,5*H-E-G>,<6*W-E  ,4*W,6*H-E>}
        box {<3*W+E  ,  W+E,5*H-E-G>,<5*W-E  ,4*W,6*H-E>}
        box {<3*W+E  ,2*W+E,5*H-E-G>,<5*W-E  ,4*W,7*H-E>}
    }
    object {l_studh translate <0.5*W,0.5*W,  H>}
    object {l_studh translate <1.5*W,0.5*W,3*H>}
    object {l_studh translate <2.5*W,0.5*W,4*H>}
    object {l_studh translate <3.5*W,0.5*W,3*H>}
    object {l_studh translate <4.5*W,0.5*W,  H>}
    object {l_studh translate <5.5*W,0.5*W,4*H>}
    object {l_studh translate <6.5*W,0.5*W,3*H>}
    object {l_studh translate <7.5*W,0.5*W,  H>}
    object {l_studh translate <0.5*W,1.5*W,2*H>}
    object {l_studh translate <1.5*W,1.5*W,4*H>}
    object {l_studh translate <2.5*W,1.5*W,5*H>}
    object {l_studh translate <3.5*W,1.5*W,6*H>}
    object {l_studh translate <4.5*W,1.5*W,6*H>}
    object {l_studh translate <5.5*W,1.5*W,5*H>}
    object {l_studh translate <6.5*W,1.5*W,4*H>}
    object {l_studh translate <7.5*W,1.5*W,2*H>}
    object {l_studh translate <0.5*W,2.5*W,2*H>}
    object {l_studh translate <1.5*W,2.5*W,4*H>}
    object {l_studh translate <2.5*W,2.5*W,6*H>}
    object {l_studh translate <3.5*W,2.5*W,7*H>}
    object {l_studh translate <4.5*W,2.5*W,7*H>}
    object {l_studh translate <5.5*W,2.5*W,6*H>}
    object {l_studh translate <6.5*W,2.5*W,4*H>}
    object {l_studh translate <7.5*W,2.5*W,2*H>}
    translate <-WR,-WR,0>
}

// Trunk
#declare l_trunk = union {
    // Bottom
    difference {
        #declare SX = 4 #declare SY = 2 #declare SZ = 1.25
        #include "S_Box.inc"
        // Bottom Cut
        box {<E,E,-G>,<4*W-E,2*W-E,F-E>}
        // Bottom Edge
        box {<.05,-G,-G>,<-G,2*W+G,.05>}
        box {<4*W-.05,-G,-G>,<4*W+G,2*W+G,.05>}
        box {<-G,.05,-G>,<4*W+G,-G,.05>}
        box {<-G,2*W-.05,-G>,<4*W+G,2*W+G,.05>}
        // Inside Cut
        box {<E,E,F>,<4*W-E,2*W-E,1.5>}
        // Top Edge
        box {<.05,-G,1.2>,<-G,2*W+G,1.3>}
        box {<4*W-.05,-G,1.2>,<4*W+G,2*W+G,1.3>}
        box {<-G,.05,1.2>,<4*W+G,-G,1.3>}
        box {<-G,2*W-.05,1.2>,<4*W+G,2*W+G,1.3>}
        // Front Panels
        box {<.2,.05,.25>,<1,-G,1>}
        box {<1.2,.05,.25>,<4*W-1.2,-G,1>}
        box {<4*W-.2,.05,.25>,<4*W-1,-G,1>}
    }
    // Handles
        // right
    box {<0,WR-.05,1.05>,<-WR+.05,WR+.05,1.25>}
    sphere {<-WR,WR+.1,1.15>,.1}
    cylinder {<-WR,WR+.05,1.15>,<-WR,1.5*W-.05,1.15>,CSR}
    box {<0,1.5*W-.05,1.05><-WR+.05,1.5*W+.05,1.25>}
    sphere {<-WR,1.5*W-.1,1.15>,.1}
        // left
    box {<4*W,WR-.05,1.05>,<4.5*W-.05,WR+.05,1.25>}
    sphere {<4.5*W,WR+.1,1.15>,.1}
    cylinder {<4.5*W,WR+.05,1.15>,<4.5*W,1.5*W-.05,1.15>,CSR}
    box {<4*W,1.5*W-.05,1.05><4.5*W-.05,1.5*W+.05,1.25>}
    sphere {<4.5*W,1.5*W-.1,1.15>,.1}

    // Lid
    union {
        difference {
            merge {
                cylinder {<0,.6,0>,<4*W,.6,0>,.6}
                box {<0,.6,0>,<4*W,2*W-.6,.6>}
                cylinder {<0,2*W-.6,0>,<4*W,2*W-.6,0>,.6}
            }
            box {<-G,-G,0>,<4*W+G,2*W+G,-1>}
            cylinder {<E,.6+E,0>,<4*W-E,.6+E,0>,.6-E}
            box {<E,.6+E,-G>,<4*W-E,2*W-.6-E,.6-E>}
            cylinder {<E,2*W-.6-E,0>,<4*W-E,2*W-.6-E,0>,.6-E}
        }
        // Clasp
        box {<2*W-.05,E,.1>,<2*W+.05,E+.3,-.3>}
        object {l_stud translate < .5*W,W,.6>}
        object {l_stud translate <1.5*W,W,.6>}
        object {l_stud translate <2.5*W,W,.6>}
        object {l_stud translate <3.5*W,W,.6>}

        translate <0,-2*W+E/2,0>
        rotate -50*x
        translate <0,2*W-E/2,1.25>
    }

    translate <-WR,-WR,0>
    rotate z*180
    translate <3*W,W,0>
}

#end    // end library include
