/*
  L_MiniFig.inc
  created by Steven L. Reid
  v1.0 11 Sep 97

  This file defines the base mini-figure pieces.  Most are centered on
  the right front stud; however, some are centered on rotation points (hands,
  arms), and some are set up for in hand use (the mini-fig tools).  A library
  has been set up to create full figures (face and all).  The include file
  "S_MiniFig.inc" has the definition for creating full mini-figures.
  L_Standard.inc must be included first!

  v1.0 11 Sep 97 File created.
  v1.1 30 Jun 98 Added "nothing" object (an empty sphere) which is
                 needed to put "nothing" into a hand or hat when
                 defining multiple mini-figs.  Note:  Order does
                 matter for some defines!  Especially back gear!
*/

// POV Version
#version 3

#ifndef (L_MiniFig)
    #declare L_MiniFig = true
    // include library!

// Ensure required libraries are included
#ifndef (L_Standard)
    #include "L_Standard.inc"
#end

/*
 * Standard Mini-Figure Heads and templates
 */
    // the round head (no stud)
#declare l_rd_head = union {
    torus {.5-SH,SH rotate x*90 translate (H-SH)*z}
    difference {
        cylinder {   .1*z,    H*z,.5-SH}
        cylinder {   -G*z,(H-E)*z,SR}
        cylinder {(H-F)*z,(H+E)*z,CSR}
    }
    cylinder {(.1+SH)*z,(H-SH)*z,.5 open}
    torus {.5-SH,SH rotate x*90 translate (.1+SH)*z}
    object {l_cbf}
}
    // large round with solid stud (old style)
#declare l_rd1lrg = union {
    object {l_rd_head}
    object {l_stud translate H*z}
}
    // large round with hole stud (new style)
#declare l_rd1lrg_sh = union {
    object {l_rd_head}
    object {l_studh translate H*z}
}
    // Standard head textures
#declare mm_smile_face = texture {
    material_map {
        gif "p_smile_face.gif"
        map_type 2
        texture {l_black}   // 0
        texture {l_yellow}  // 1-14
    }
}
     // Head with smile face!
#declare mf_smile_face = object {
    l_rd1lrg_sh
    texture {
        mm_smile_face
        // set up face texture
        rotate <90,0,90>    translate -.5*z
        scale <1.75,1.0,1.75> translate .45*z
    }
}
/*
 * Minifig Pieces (body, hands, arms, groin, legs)
 */
    // Body
    // body shell, front missing for stickers
#declare mf_body_shell = union {
    sphere {<       TE,  TE,    TE>,TE}
    sphere {<       TE,W-TE,    TE>,TE}
    sphere {<    .25+TE,  TE,4*F-TE>,TE}
    sphere {<    .25+TE,W-TE,4*F-TE>,TE}
    sphere {<2*W   -TE,  TE,    TE>,TE}
    sphere {<2*W   -TE,W-TE,    TE>,TE}
    sphere {<2*W-.25-TE,  TE,4*F-TE>,TE}
    sphere {<2*W-.25-TE,W-TE,4*F-TE>,TE}
    cylinder {<       TE,  TE,    TE>,<       TE,W-TE,    TE>,TE}
    cylinder {<       TE,W-TE,    TE>,<2*W   -TE,W-TE,    TE>,TE}
    cylinder {<2*W   -TE,W-TE,    TE>,<2*W   -TE,  TE,    TE>,TE}
    cylinder {<2*W   -TE,  TE,    TE>,<       TE,  TE,    TE>,TE}

    cylinder {<       TE,  TE,    TE>,<    .25+TE,  TE,4*F-TE>,TE}
    cylinder {<       TE,W-TE,    TE>,<    .25+TE,W-TE,4*F-TE>,TE}
    cylinder {<2*W   -TE,  TE,    TE>,<2*W-.25-TE,  TE,4*F-TE>,TE}
    cylinder {<2*W   -TE,W-TE,    TE>,<2*W-.25-TE,W-TE,4*F-TE>,TE}

    cylinder {<    .25+TE,  TE,4*F-TE>,<    .25+TE,W-TE,4*F-TE>,TE}
    cylinder {<    .25+TE,W-TE,4*F-TE>,<2*W-.25-TE,W-TE,4*F-TE>,TE}
    cylinder {<2*W-.25-TE,W-TE,4*F-TE>,<2*W-.25-TE,  TE,4*F-TE>,TE}
    cylinder {<2*W-.25-TE,  TE,4*F-TE>,<    .25+TE,  TE,4*F-TE>,TE}
    polygon {5,
        <        0,  TE,    TE>,
        <        0,W-TE,    TE>,
        <       .25,W-TE,4*F-TE>,
        <       .25,  TE,4*F-TE>,
        <        0,  TE,    TE>
    }
    polygon {5,
        <       TE,W   ,    TE>,
        <2*W   -TE,W   ,    TE>,
        <2*W-.25-TE,W   ,4*F-TE>,
        <    .25+TE,W   ,4*F-TE>,
        <       TE,W   ,    TE>
    }
    polygon {5,
        <2*W      ,W-TE,    TE>,
        <2*W      ,  TE,    TE>,
        <2*W-.25   ,  TE,4*F-TE>,
        <2*W-.25   ,W-TE,4*F-TE>,
        <2*W      ,W-TE,    TE>
    }
    polygon {5,
        <    .25+TE,  TE,4*F   >,
        <    .25+TE,W-TE,4*F   >,
        <2*W-.25-TE,W-TE,4*F   >,
        <2*W-.25-TE,  TE,4*F   >,
        <    .25+TE,  TE,4*F   >
    }
    cylinder {0,.6*z,SR translate <W,WR,4*F>}
    translate <-WR,-WR,0>
}
    // body front, used for stickers
#declare mf_body_front = polygon {5,
    <       TE,0,    TE>,
    <2*W   -TE,0,    TE>,
    <2*W-.25-TE,0,4*F-TE>,
    <    .25+TE,0,4*F-TE>,
    <       TE,0,    TE>
    translate <-WR,-WR,0>
}
    // complete body (no stickers)
#declare mf_body = union {
    object {mf_body_shell}
    object {mf_body_front}
}
    // Hands (positioned for arms)
#declare mf_hand = merge {
    difference {
        cone {SR*y,.18, (-E-SR+CSR)*y,0.1}
        cylinder {-z,z,SR translate -SR*y rotate 15*x translate -E*y}
    }
    difference {
        merge {
            torus { SR-C,C rotate 90*x translate (F-C)*z}
            torus {CSR+C,C rotate 90*x translate (F-C)*z}
            difference {
                union {
                    cylinder {-.1*z,F*z, SR}
                    cylinder {-.1*z,(F-C)*z,SR-C open}
                }
                cylinder {-z,z,CSR}
            }
        }
        box {<-CSR+C,0,-1>,<CSR-C,-1,1>}
        difference {
            box {<-1,0,0>,<1,-1,-1>}
            cylinder {-x,x,.3}
            translate <0,-SR+.3,.3-.1>
        }
        translate -SR*y rotate 15*x translate -E*y
    }
}
    // Arms, positioned for hands (final position in S_MiniFig.inc)
#declare mf_arm = union {
    torus {.2-C,C translate (C-.1)*y}
    cylinder {(C-.1)*y,.35*y,.2}
    cylinder {(-.1)*y,(C-.1)*y,.2}
    sphere {.35*y,.2}
    union {
        sphere {0,.25 scale <1,.1/.25,1>}
        cylinder {0,.5*y,.25}
        sphere {.5*y,.25}
        scale <.2/.25,1,1>
        rotate 45*x
        translate .3*y
    }
}
    // Groin (seperate for color, positined for legs)
    // Note:  If you put in anything on this, you must offset it
    //        as follows:  translate <0,TE,5*F>
#declare mf_groin = union {
    difference {
        #declare SX = (2*W-2*TE)/W
        #declare SY = 1
        #declare SZ = 2/3*F
        object {#include "S_Box.inc" translate <TE,TE,5*F-SZ>}
        cylinder {-G*x,(2*W+G)*x,WR-TE translate <0,WR+TE,3.5*F>}
    }
    torus {WR-TE-C,C rotate 90*z translate <W+ES-C,WR+TE,3.5*F>}
    cylinder {C*x,(E-C)*x,WR-TE   translate <W-ES,WR+TE,3.5*F>}
    cylinder {  0, E   *x,WR-TE-C translate <W-ES,WR+TE,3.5*F>}
    torus {WR-TE-C,C rotate 90*z translate <W-ES+C,WR+TE,3.5*F>}
    // these need to be replaced!
    object {l_stud translate <  WR,WR,5*F>}
    object {l_stud translate <3*WR,WR,5*F>}
    translate <-WR,-WR,0>
}
    // Legs (right and left positined for groin)
#declare mf_left_leg = difference {
    union {
        #declare SX = (W-2*TE)/W
        #declare SY = 1
        #declare SZ = F
        object {#include "S_Box.inc" translate TE*x}
        #declare SY = (W-.2)/W
        #declare SZ = 2.5*F+3*C
        object {#include "S_Box.inc" translate <TE,.2,F-2*C>}
        torus {WR-TE-C,C rotate 90*z translate <  TE+C,WR+TE,3.5*F>}
        cylinder {(TE+C)*x,(W-ES-C)*x,WR-TE   translate <0,WR+TE,3.5*F>}
        cylinder { TE   *x,(W-ES  )*x,WR-TE-C translate <0,WR+TE,3.5*F>}
        torus {WR-TE-C,C rotate 90*z translate <W-ES-C,WR+TE,3.5*F>}
    }
    box {<E,   E ,   -G>,<W-E,W-E,SH+ES>}
    box {<E,.2+ES,SH+ES>,<W-E,W-E,W    >}
    cylinder {0,E*x,WR translate <W-ES,WR,3.5*F>}
    cylinder {WR*y,y,SR translate <WR,0,  WR>}
    cylinder {WR*y,y,SR translate <WR,0,3*WR>}
    translate <-WR,-WR,0>
}
#declare mf_right_leg = difference {
    union {
        #declare SX = (W-2*TE)/W
        #declare SY = 1
        #declare SZ = F
        object {#include "S_Box.inc" translate (W+TE)*x}
        #declare SY = (W-.2)/W
        #declare SZ = 2.5*F+3*C
        object {#include "S_Box.inc" translate <W+TE,.2,F-2*C>}
        torus {WR-TE-C,C rotate 90*z translate <W+ES+C,WR+TE,3.5*F>}
        cylinder {C*x,(W-ES-TE-C)*x,WR-TE   translate <W+ES,WR+TE,3.5*F>}
        cylinder {  0,(W-ES-TE  )*x,WR-TE-C translate <W+ES,WR+TE,3.5*F>}
        torus {WR-TE-C,C rotate 90*z translate < 2*W-C-TE,WR+TE,3.5*F>}
    }
    box {<E,   E ,   -G>,<W-E,W-E,SH+ES> translate W*x}
    box {<E,.2+ES,SH+ES>,<W-E,W-E,W    > translate W*x}
    cylinder {0,E*x,WR translate <W-ES,WR,3.5*F>}
    cylinder {WR*y,y,SR translate <3*WR,0,  WR>}
    cylinder {WR*y,y,SR translate <3*WR,0,3*WR>}
    translate <-WR,-WR,0>
}

/*
 * Head Gear
 */
    // Helmet
#declare mf_helmet = difference {
    merge {
        sphere { 0,.5+TE scale <1,1,.76> translate (H-ES)*z}
        cylinder {C*z,(H-ES)*z,.5+TE} // was .1*z instead of 0
    }
    // sholder cut
    cylinder {-x,x,1 scale <1,W,.3> translate <0,.1,-.2>} //-.1>}
    box {<-1,0,-G>,<1,1,.1>}
    // face cut
    superellipsoid {<1,.5> scale <1, SR, .28> translate <0,-.5-TE,.5>} // was .3
    // inside
    cylinder {-G*z,H*z,.5}
    // visor holes
    sphere {0,ES scale <.5,1,1> translate <-.5-TE-G,0,W>}
    sphere {0,ES scale <.5,1,1> translate < .5+TE+G,0,W>}
}
    // Construction Hard Hat
#declare mf_hardhat = union {
    difference {
        union {
            sphere {0,.5+TE}
            #declare s_count=0
            #while (s_count < 8)
                torus {
                    1,ES
                    scale <.5,W+TE,.5+TE>
                    rotate s_count*(360/5)*z
                }
                #declare s_count=s_count+1
            #end
        }
        box {<1,1,0>,-1}
    }
    cylinder {0,TE*z,1 scale <.5+TE,F2,1> translate -F2/2*y}
    translate W*z
}
    // Baseball Cap
#declare mf_baseball_cap = union {
    difference {
        sphere {0,.5+TE}
        box {<1,1,0>,-1}
    }
    cylinder {0,TE*z,1 scale <.5+TE,W,1> translate -WR*y}
    translate W*z
}
    // Fireman's Helmet
#declare mf_fire_helmet = union {
    intersection {
        box {<1,2,0>,<-1,-1,1>}
        union {
            sphere {0,.5+TE}    // round top
            cylinder {0,TE*z,1 scale <.5+TE,W,1> translate  WR*y}   // shield
            intersection {
                box {<1,2,-1>,<-1,-.4,1>}
                torus {.5+TE,.1 rotate 90*z}
                rotate 20*x
            }
        }
        rotate -20*x
        // ridge
    }
    intersection {
        box {<1,0,0>,<-1,-2,1>}
        union {
            sphere {0,.5+TE}    // round top
            cylinder {0,TE*z,1 scale <.5+TE,F2,1> translate -F2/2*y}    // bill
        }
    }
    rotate 5*x
    translate W*z
}
    // Hood
#declare mf_hood = union {
    difference {
        merge {
            sphere { 0,.5+TE scale <1,1,W> translate (H-ES)*z}
            cylinder {0,(H-ES)*z,.5+TE} // was .1*z instead of 0
            // portion of tail
            torus {.5+TE,.1 scale <1,1,.5+TE> translate <.2,0,H+TE>}
        }
        // sholder cut
        cylinder {-y,y,1 scale <W,1,.3> translate <.1,0,-.1>} //-.1>}
        superellipsoid {
            <1,.5>
            scale <1, SR, .28>
            translate <0,-.5-TE,.5>
            rotate -90*z
        }
        box {<1,1,0>,-1}
        cylinder {-G*z,H*z,.5}
    }
    // tail in back
    cylinder {0,(H+TE)*z,.15 translate (.5+TE+.15)*x}
    rotate 90*z
}

/*
 *  Back pieces (airtanks, arrow bags, etc.)
 */
    // Air tanks (need to update)
#declare s_tank = difference {
    union {
        // tank
        torus {.3-E,E rotate 90*x}
        cylinder {0,E*z,.3-E}
        cylinder {0,-(H+ES-C)*z,.3}
        cylinder {-(H+ES-C)*z,(-H+ES)*z,.3-C}
        torus {.3-C,C rotate 90*x translate -(H+ES-C)*z}
        // valve
        union {
            cylinder {0,E*z,ES scale <1,1.5,1>}
            sphere {0,ES scale <1,1.5,TE/ES> translate E*z}
            translate <TE,0,E-TE>
        }
    }
    cylinder {-ES*z,-(H+F)*z,CSR}
}
#declare mf_airtanks_w = union {
    difference {
        torus {SR+ES, ES rotate 90*x}
        box {<0,-1,-1>,<1,1,1>}
        translate ES*z
   }
   cylinder {0,W*x,ES translate <0, SR+ES,ES>}
   cylinder {0,W*x,ES translate <0,-SR-ES,ES>}
   object {s_tank translate <WR+.3,-.3,0>}
   object {s_tank translate <WR+.3, .3,0>}
   box {<ES,.6-E,-E>,<-ES,-.6+E,2*E> translate (WR+.3)*x}
   cylinder {(.6-E)*y,(-.6+E)*y,ES translate <WR+.3,0,2*E>}
   cylinder {2*E*z,(2.5*E+TE)*z,ES translate (WR+.3)*x}
   sphere  {0,ES scale <1,1,C> translate <WR+.3,0,2.5*E+TE>}
}
#declare mf_airtanks_n = object {mf_airtanks_w rotate  90*z}
#declare mf_airtanks_e = object {mf_airtanks_w rotate 180*z}
#declare mf_airtanks_s = object {mf_airtanks_w rotate -90*z}

/*
 * Mini-Figure Tools
 */
    // Wrench (I still don't like the head)
#declare mf_wrench = union {
    difference {
        cylinder {0,2.5*H*z,CSR}
        plane {-y,0 rotate -15*x}
        plane { y,0 rotate  15*x}
    }
    difference {
        union {
            cylinder {-CSR*y,CSR*y,WR-C}
            cylinder {-(CSR-C)*y,(CSR-C)*y,CBR}
            torus {CBR-C,C translate  (CSR-C)*y}
            torus {CBR-C,C translate -(CSR-C)*y}
        }
        union {
            cylinder {-y,y,CSR}
            box {<-CSR,-1,0>,<CSR,1,W> rotate -35*y}
            translate -ES*x
        }
        translate (2.5*H+WR-E)*z
    }
    translate <0,0,-1.5*H>
}
    // Radio walky talky
#declare mf_walky_talky = union {
    difference {
        box {          0,<1.50,0.7,  F>}
        box {<.45,.5,-G>,<1.05,1.0,H/2>}
    }
    cylinder {<.3,.7+CSR,E>,<1.2,.7+CSR,E>,CSR}
    sphere {<.3,.7+CSR,E>,CSR}
    cylinder {<.3,.7+CSR,E>,<.3,.7,E>,CSR}
    sphere {<1.2,.7+CSR,E>,CSR}
    cylinder {<1.2,.7+CSR,E>,<1.2,.7,E>,CSR}
    object {l_studh translate <WR-.05,WR-.1,F>}
    object {l_studh translate <1.5*W-.05,WR-.1,F>}
    cylinder {<1.5,.2,E>,<1.65,.2,E>,E}
    cylinder {<1.5,.2,E>,<2.85,.2,E>,.1}
    difference {
        sphere{<2.85,.2,E>,E}
        box{<2.85,0,-G>,<2,1,1>}
    }
    cylinder {<1.3,0,E>,<1.3,-.08,E>,.1}
    cylinder {<.95,0,E>,<.95,-.08,E>,.1}
    box {<.1,0,.1>,<.5,-.08,.2>}
    translate <-.75,-.7-CSR,-E> // center on handle
    rotate -90*y                // rotate to hand
}
// Sword
#declare mf_sword = union {
    cylinder {0,-.6*z,CSR}
    sphere {-.75*z,CSR}
    cylinder {-.35*x,.35*x,CSR}
    sphere {-.4*x,CSR}
    sphere { .4*x,CSR}
    intersection {
        merge {
            box {<-SR,-ES,0>,<SR,ES,2>}
            sphere {0,1 scale <SR,ES,SR> translate z*2}
        }
        cylinder {0,(2+SR)*z,1 scale <SR,ES,1>}
    }
    rotate z*90
    translate z*SD   // was SD
}

// Axe
#declare mf_axe = union {
    cylinder {<0,0,0>,<0,0,4*H+F2>,CSR}
    cone {<0,0,4*H+F2>,CSR,<0,0,5*H-.05>,.05}
    sphere {<0,0,5*H-.05>,.05}
    difference {
        union {
            box {<  0,-.1,-.2>,<-.6  ,.1,.2>}
            box {<  -.4,-.1,-.4>,<-.6  ,.1,.4>}
            intersection {
                box {<-.6,-.1,-.7>,<-1.1,.1,.7>}
                sphere {
                    <0,0,0>,1
                    scale <.5,.13,.7>
                    translate <-.6,0,0>
                }
            }
        }
        cylinder {<-.4,-1, .4>,<-.4,1, .4>,.2}
        cylinder {<-.4,-1,-.4>,<-.4,1,-.4>,.2}
        translate <0,0,4*H+.2>
    }
    rotate 180*z
}

// Spear
#declare mf_spear = union {
    // shaft
    cylinder {<0,0,CSR>,<0,0,4*H>,CSR}
    sphere {<0,0,CSR>,CSR}
    sphere {<0,0,4*H>,CSR}

    // Tip
    union {
        cone {<0,0,0>,1,<0,0,1.5>,0 scale <CBR,E,1>}
        cone {<0,0,0>,1,<0,0,-F>,0 scale <CBR,E,1>}
        translate <0,0,4*H+F>
    }
}

// Shield

// Cup
#declare mf_cup = merge {
#if (l_highq)
    torus {WR+E-C,C rotate 90*x translate C*z}
    difference {
        cylinder {C*z,(H-SH-C)*z,WR+E}
        cylinder {E*z,       H*z,WR}
    }
    difference {
        cylinder {0  ,(H-SH  )*z,WR+E-C}
        cylinder {E*z,       H*z,WR+C}
    }
    torus {WR+E-C,C rotate 90*x translate (H-SH-C)*z}
    torus {WR+  C,C rotate 90*x translate (H-SH-C)*z}
    object {l_studh rotate 180*y}
    torus {CSR-C,C rotate 90*z translate <W+WR+E-C,0,H-SH-CSR-.1>}
    cylinder {<WR,0,H-SH-CSR-.1>,<W+WR+E-C,0,H-SH-CSR-.1>,CSR}
    cylinder {<WR,0,H-SH-CSR-.1>,<W+WR+E  ,0,H-SH-CSR-.1>,CSR-C}
#else
    difference {
        cylinder {0  ,(H-SH)*z,WR+E}
        cylinder {E*z,     H*z,WR}
    }
    cylinder {0,-SH*z,SR}
    cylinder {<WR,0,H-SH-CSR-.1>,<W+WR+E,0,H-SH-CSR-.1>,CSR }
#end
}

// Nothing (used with S_MiniFig.inc to empty a hand)
#declare s_nothing = sphere{0,0}

#end    // end library include
