/*
  L_House.inc
  created by Steven L. Reid
  v1.0 15 Sep 97

  This file defines house bricks centered on the right front stud.
  L_Standard.inc, L_Flats.inc, L_Tiles.inc and L_Rounds.inc must be
  included first!

  v1.0 15 Sep 97 File created.
  v1.1  4 Jan 98 Modified l_faucet slightly to center knob.
*/

// POV-Ray Version
#version 3.0

#ifndef (L_House)
    #declare L_House = true
    // include library!

// Ensure required libraries are included
#ifndef (L_Standard)
    #include "L_Standard.inc"
#end
#ifndef (L_Flats)
    #include "L_Flats.inc"
#end
#ifndef (L_Tiles)
    #include "L_Tiles.inc"
#end
#ifndef (L_Rounds)
    #include "L_Rounds.inc"
#end

// Window
#declare l_window_pane = difference {
    box {< 0,-W/6+C,F                 >,<2*W-E-C/2   ,W/6-C, 3*H-E            >}
    box {<SR,-WR   ,            F+SR  >,<2*W-E-C/2-SR,WR   ,(3*H-E-F)/2+F-SR/2>}
    box {<SR,-WR   ,(3*H-E-F)/2+F+SR/2>,<2*W-E-C/2-SR,WR   , 3*H-E       -SR  >}
}
#declare l_window_shingle = difference {
    merge {
        cylinder {(F-ES)*z,(3*H-ES)*z,E/2}
        box {<0,-E/2,F-ES>,<-2*W,E/2,3*H-ES>}
        cylinder {(F-ES)*z,(3*H-ES)*z,E/2 translate -2*W*x}
    }
    box {<-CSR,-E,0>,<E,E,F>}
    box {<-CSR,-E,3*H-SH>,<E,E,3*H>}
    #declare SG = (3*H-ES-E + F-ES+E)/31
    #declare Z = F-ES+E
    #while (Z < 31*SG)
        box {<-E/2,-1,Z>,<-2*W+E/2,-ES/2,Z+SG>}
        box {<-E/2, 1,Z>,<-2*W+E/2, ES/2,Z+SG>}
        #declare Z = Z + SG*2
    #end
}
#declare l_window_frame = union {
    difference {
        #declare SX = 4
        #declare SY = 1
        #declare SZ = 3*H
        object {#include "S_Box.inc"}
        #if (l_highq)
            #declare SG=C
        #else
            #declare SG=0
        #end
        box {<E,E,-G>,<4*W-E,W-E,F-E>}
        box {<2*E,-G,F+E><4*W-2*E,W+G,3*H-2*E>}
        box {<E, -G,F><4*W-E,  W/3,3*H-E>}
        box {<E,W+G,F><4*W-E,W-W/3,3*H-E>}
    }
    cylinder {<    CSR,0,F     >,<    CSR,0,  F-SH>,CSR}
    cylinder {<4*W-CSR,0,F     >,<4*W-CSR,0,  F-SH>,CSR}
    cylinder {<    CSR,0,3*H-SG>,<    CSR,0,3*H-SH>,CSR}
    cylinder {<4*W-CSR,0,3*H-SG>,<4*W-CSR,0,3*H-SH>,CSR}
}
#declare l_window_s = union {
    object {l_window_frame}
    object {l_window_pane texture {l_black}
        translate <    E,W/6,0>}
    object {l_window_pane texture {l_black} rotate 180*z
        translate <4*W-E,W/6,0>}
    object {l_window_shingle texture {l_green}
        translate <    CSR,-E/2,0>}
    object {l_window_shingle texture {l_green} rotate 180*z
        translate <4*W-CSR,-E/2,0>}
    translate <-WR,-WR,0>
}
#declare l_window_w = object {l_window_s rotate  90*z}
#declare l_window_n = object {l_window_s rotate 180*z}
#declare l_window_e = object {l_window_s rotate -90*z}

/*
   Door, old 1x3x4 style    (needs to be updated!)

   The door is broken into 3 parts, the frame, the door, and the door's
   glass.  To render the door, position the frame as a 1x3 or 3x1 brick.
   It is symmetric so these two definitions should suffice.  Next create
   a union of the door and it's glass, adding pigment to the door.  I did
   this so that you could change the color of the door without changing the
   color of the glass!  The center of the door's hinge is located at 0x0
   to allow you to rotate it before positioning.  It is oriented along the
   z axis with the door pointing into the y axis with it's hinge centered
   on the x/z axis.  So rotate aound the z axis to swing the door.  There
   are too many different orientations to put them all in this definition.
   The basic transformation is <W-.15,W-.16,0>.  Have Fun!
*/

// Door Frame
#declare DoorOF1x3 =
    union {
        difference {
            box {<0,0,0>,<W,3*W,4*H>}
            box {<-G,0.14,F>,<W+G,3*W-0.14,4*H-0.14>}
            box {<E,E,-E>,<W-E,W-E,F-E>}
            cylinder {<   .25,     .26,0>,<   .25,     .26,5*H>,.1}
            cylinder {<W-.25,     .26,0>,<W-.25,     .26,5*H>,.1}
            cylinder {<   .25,3*W-.26,0>,<   .25,3*W-.26,5*H>,.1}
            cylinder {<W-.25,3*W-.26,0>,<W-.25,3*W-.26,5*H>,.1}
        }
        difference {
            box {<WR-0.05,0.14,F>,<WR+0.05,3*W-0.14,4*H-0.14>}
            box {<0,0.24,F+.1>,<W,3*W-0.24,4*H-0.24>}
        }
        difference {
            object {l_stud      rotate z*90 translate <WR,0.5*W,4*H>}
            cylinder {<   .25,     .26,4*H>,<   .25,     .26,5*H>,.1}
            cylinder {<W-.25,     .26,4*H>,<W-.25,     .26,5*H>,.1}
        }
        object {l_studh translate <WR,1.5*W,4*H>}
        difference {
            object {l_stud      rotate z*90 translate <WR,2.5*W,4*H>}
            cylinder {<   .25,3*W-.26,4*H>,<   .25,3*W-.26,5*H>,.1}
            cylinder {<W-.25,3*W-.26,4*H>,<W-.25,3*W-.26,5*H>,.1}
        }
        object {l_csf translate <WR,     CSD/2+E+SD,0>}
        object {l_csf translate <WR,3*W-CSD/2-E-SD,0>}

        translate <-WR,-WR,0>
    }

// And transformations
#declare DoorOF3x1 = object { DoorOF1x3 rotate -90*z }

// Now the door proper
#declare DoorOD = difference {
    union {
        difference {
            union {
                box { <W-.15,      .26, F+.01>,
                      <W-.35, 3*W-.16, 4*H-.15>}
                cylinder {<W-.25, .26, F    >,
                          <W-.25, .26, 4*H-.14>,.1}
            }
            box { <W    ,      .30, F+.15>,
                  <W-.19, 3*W-.30, 4*H-.29>}
        }
        box { <W-.15,      .4, F+.25>,
              <W-.35, 3*W-.4, 4*H-.39>}
        difference {
            cylinder {<W-.15, 3*W-.85, F+1.69>,
                      <W+.03, 3*W-.85, F+1.69>, .25}
            cylinder {<W    , 3*W-.85, F+1.69>,
                      <W+.10, 3*W-.85, F+1.69>, .17}
        }
    }
    box {<W-.10,      .60, F+0.45>,
         <     0, 3*W-.60, F+1.61>}
    box {<W-.10,      .60, 4*H-1.75>,
         <     0, 3*W-.60, 4*H-0.59>}
    box {<     0,      .41, F+0.19>,
         <W-.25, 3*W-.41, 4*H-0.33>}
    translate <.25-W,-.26,-F>
}

// And the glass for the door!
#declare DoorOG = box {
    <W-.35,      .41, F+.19>,
    <W-.25, 3*W-.41, 4*H-.33>
    texture {lt_clear}
    translate <.25-W,-.26,-F>
}

// Faucet (my version) (needs to be updated!)
# declare l_faucet = union {
    box {
        <0,0,0>,<.4,.2,1.1>
        rotate 52.22*x
        translate <.6,.4,0>
    }
    sphere {<.8,-.3,.6>,.1}
    difference {
        box { <E,E,0>,<2*W-E,W-E,F> }
        box { <-G,-G,0>,<W+G,W+G,H> rotate -y*19.85
              translate <  0,0,.1>}
        box { <G,-G,0>,<-W-G,W+G,H> rotate  y*19.85
              translate <2*W,0,.1>}
    }
    cylinder {<W,WR+E, 0>,<W,WR+E,.7 >, .1}
    cylinder {<W,WR+E,.6>,<W,WR+E,.85>,.17}

    translate <-WR,-WR,0>
}
    // gray faucet
#declare l_faucet_s = union {
    object {l_tile2x1}
    object {l_faucet translate F*z texture {l_gray}}
}
#declare l_faucet_n = object {l_faucet_s rotate 180*z translate <W,0,0>}
#declare l_faucet_e = object {l_faucet_s rotate -90*z translate <0,W,0>}
#declare l_faucet_w = object {l_faucet_s rotate  90*z}
    // silver faucet
#declare l_sfaucet_s = union {
    object {l_tile2x1}
    object {l_faucet translate F*z texture {l_silver}}
}
#declare l_sfaucet_n = object {l_sfaucet_s rotate 180*z translate <W,0,0>}
#declare l_sfaucet_e = object {l_sfaucet_s rotate -90*z translate <0,W,0>}
#declare l_sfaucet_w = object {l_sfaucet_s rotate  90*z}

// Ladder   (needs to be updated!)
#declare l_ladder = union {
    box {<    0,0,0>,<  E,.65,9.5>}
    box {<2*W-E,0,0>,<2*W,.65,9.5>}
    box {<0,.65,0.65>,<2*W,.45,0.85>}
    box {<0,.65,1.45>,<2*W,.45,1.65>}
    box {<0,.65,2.25>,<2*W,.45,2.45>}
    box {<0,.65,3.05>,<2*W,.45,3.25>}
    box {<0,.65,3.85>,<2*W,.45,4.05>}
    box {<0,.65,4.65>,<2*W,.45,4.85>}
    box {<0,.65,5.40>,<2*W,.45,5.65>}
    box {<0,.65,6.15>,<2*W,.45,6.45>}
    box {<0,.65,6.95>,<2*W,.45,7.25>}
    box {<0,.65,7.75>,<2*W,.45,8.05>}
    box {<0,.65,8.55>,<2*W,.45,8.85>}

    translate <0,-.65,0>                // flush
}

// HingeLadder
#declare DHook = union {
#if (l_highq)
    #declare SX = F/W
    #declare SY = CSD/W
    #declare SZ = H-CSR
    object {#include "S_Box.inc" translate <0,-CSR,CSR>}
    difference {
        merge {
            torus {CBR-C,C rotate 90*z translate C*x}
            torus {CSR+C,C rotate 90*z translate C*x}
            difference {
                cylinder {C*x,(F-C)*x,CBR}
                cylinder {  0,    F*x,CSR}
            }
            difference {
                cylinder {   0,F *x,CBR-C}
                cylinder {-G*x,F2*x,CSR+C}
            }
            torus {CBR-C,C rotate 90*z translate (F-C)*x}
            torus {CSR+C,C rotate 90*z translate (F-C)*x}
        }
        box {<-G,-WR,0>,<F2,WR,-W>}
    }
    #declare SX = F/W
    #declare SY = (CBR-CSR)/W
    #declare SZ = CSR+C
    object {#include "S_Box.inc" translate <0,-CBR,-CSR+C>}
    object {#include "S_Box.inc" translate <0, CSR,-CSR+C>}
#else
    box {<0,-CSR,CSR>,<F,CSR,H>}
    difference {
        cylinder {   0,F*x,CBR}
        cylinder {-G*x,H*x,CSR}
        box {<-G,-WR,0>,<F2,WR,-W>}
    }
    box {<0,-CBR,0>,<F,-CSR,-CSR>}
    box {<0, CBR,0>,<F, CSR,-CSR>}
#end
}

// Hooked Ladder
#declare s_hook = union {
#if (l_highq)
    #declare SX = F/W
    #declare SY = CSD/W
    #declare SZ = H-CSR
    object {#include "S_Box.inc" translate <0,-CSR,CSR>}
    difference {
        merge {
            torus {CBR-C,C rotate 90*z translate C*x}
            torus {CSR+C,C rotate 90*z translate C*x}
            difference {
                cylinder {C*x,(F-C)*x,CBR}
                cylinder {  0,    F*x,CSR}
            }
            difference {
                cylinder {   0,F *x,CBR-C}
                cylinder {-G*x,F2*x,CSR+C}
            }
            torus {CBR-C,C rotate 90*z translate (F-C)*x}
            torus {CSR+C,C rotate 90*z translate (F-C)*x}
        }
        box {<-G,-WR,0>,<F2,WR,-W>}
    }
    #declare SX = F/W
    #declare SY = (CBR-CSR)/W
    #declare SZ = CSR+C
    object {#include "S_Box.inc" translate <0,-CBR,-CSR+C>}
    object {#include "S_Box.inc" translate <0, CSR,-CSR+C>}
#else
    box {<0,-CSR,CSR>,<F,CSR,H>}
    difference {
        cylinder {   0,F*x,CBR}
        cylinder {-G*x,H*x,CSR}
        box {<-G,-WR,0>,<F2,WR,-W>}
    }
    box {<0,-CBR,0>,<F,-CSR,-CSR>}
    box {<0, CBR,0>,<F, CSR,-CSR>}
#end
}
#declare l_ladder_hooks = union {
    // Hooks
    object {s_hook translate <-.5*W    ,0,0>}
    object {s_hook translate <1.5*W-F,0,0>}
    // ladder
    merge {
        cylinder {<        0,0,0>,<  0,0,6*W>,CSR}
        cylinder {<3*W-CSR,0,0>,<3*W-CSR,0,6*W>,CSR}
        sphere {<  0,0,  0>,CSR}
        sphere {<3*W-CSR,0,  0>,CSR}
        sphere {<  0,0,6*W>,CSR}
        sphere {<3*W-CSR,0,6*W>,CSR}
        cylinder {<0,0,  0>,<3*W-CSR,0,  0>,CSR}
        cylinder {<0,0,  W>,<3*W-CSR,0,  W>,CSR}
        cylinder {<0,0,2*W>,<3*W-CSR,0,2*W>,CSR}
        cylinder {<0,0,3*W>,<3*W-CSR,0,3*W>,CSR}
        cylinder {<0,0,4*W>,<3*W-CSR,0,4*W>,CSR}
        cylinder {<0,0,5*W>,<3*W-CSR,0,5*W>,CSR}
        cylinder {<0,0,6*W>,<3*W-CSR,0,6*W>,CSR}
        translate <-2*WR+CSR-.1,0,H>
    }
}

// Aerial (old antenna)
#declare l_aerial = union {
    object {l_rd1}
    cylinder { <       0, 0,  H>,<       0,0,5*H   >, CSR }
    cylinder { <-3*WR-.1, 0,5*H>,< 3*WR+.1,0,5*H   >, .12 }
    sphere {<-3*WR-.1,0,5*H+.06>,.06}
    sphere {< 3*WR+.1,0,5*H+.06>,.06}
    cylinder { <-3*WR,-W,5*H>,<-3*WR,W,5*H   >,  .1 }
    cylinder { <-  WR,-W,5*H>,<-  WR,W,5*H   >,  .1 }
    cylinder { <   WR,-W,5*H>,<   WR,W,5*H   >,  .1 }
    cylinder { < 3*WR,-W,5*H>,< 3*WR,W,5*H   >,  .1 }
}

// Fence 1 high
#declare s_rlattice = box {<-.04,0,-.1>,<.04,SR,.8> rotate -45*y}
#declare s_llattice = object {s_rlattice rotate 90*y}
#declare l_fence1s = union {
        // bottom
    difference {
        #declare SX=4
        #declare SY=1
        #declare SZ=F
        object {#include "S_Box.inc"}
        box {<E,E,-G><4*W-E,W-E,F-E>}
    }
    object {l_csf translate <  W,WR,0>}
    object {l_csf translate <2*W,WR,0>}
    object {l_csf translate <3*W,WR,0>}
        // fence
    difference {
        #declare SX=4
        #declare SY=SR/W
        #declare SZ=F2+2*C
        object {#include "S_Box.inc" translate (F-2*C)*z}
        box {<E,-G,F>,<4*W-E,W,H-E>}
    }
    object {s_llattice translate <0.54,0,F>}
    object {s_rlattice translate <1.04,0,F>}
    object {s_llattice translate <1.34,0,F>}
    object {s_rlattice translate <1.84,0,F>}
    object {s_llattice translate <2.14,0,F>}
    object {s_rlattice translate <2.64,0,F>}

    translate <-WR,-WR,0>
}
#declare l_fence1e = object {l_fence1s rotate  90*z}
#declare l_fence1w = object {l_fence1s rotate -90*z translate <0,3*W,0>}
#declare l_fence1n = object {l_fence1s rotate 180*z translate <3*W,0,0>}

// Fence 2 high
#declare s_rlattice = box {<-.04,WR-SR/2,-2*H>,<.04,WR+SR/2,2*H> rotate 45*y}
#declare s_llattice = object {s_rlattice rotate 90*y}
#declare l_fence2ew = union {
        // bottom
    difference {
        #declare SX=4
        #declare SY=1
        #declare SZ=F
        object {#include "S_Box.inc"}
        box {<E,E,-G><4*W-E,W-E,F-E>}
    }
    object {l_csf translate <  W,WR,0>}
    object {l_csf translate <2*W,WR,0>}
    object {l_csf translate <3*W,WR,0>}
        // fence
    difference {
        #declare SX=4
        #declare SY=SR/W
        #declare SZ=2*H-F+2*C
        object {#include "S_Box.inc" translate <0,WR-SR/2,F-2*C>}
        box {<E,0,F+E>,<4*W-E,W,2*H-E>}
    }
    intersection {
        box {<E,0,F+E>,<4*W-E,W,2*H-E>}
        union {
            object {s_llattice translate <0.5*W,0,2*H-W>}
            object {s_rlattice translate <0.5*W,0,2*H-W>}
            object {s_llattice translate <1.5*W,0,2*H-W>}
            object {s_rlattice translate <1.5*W,0,2*H-W>}
            object {s_llattice translate <2.5*W,0,2*H-W>}
            object {s_rlattice translate <2.5*W,0,2*H-W>}
            object {s_llattice translate <3.5*W,0,2*H-W>}
            object {s_rlattice translate <3.5*W,0,2*H-W>}
        }
    }

    translate <-WR,-WR,0>
}
#declare l_fence2ns = object {l_fence2ew rotate  90*z}

// Garage Door
#declare SX = CSR
#declare SY = (4*W-WR-3*CSR)/17
#declare SZ = 6*H-SH
#declare s_grid = object {#include "S_Box.inc" translate <0,-CSR/2,SH>}
#declare l_garagedoor = merge {
    difference {
        merge {
            // grids
            #declare s_row = 0
            #while (s_row < 8)
                object {s_grid translate (s_row*2*SY+SY+CSR)*x}
                #declare s_row = s_row +1
            #end
            // door
            box {<0,-CSR+.1,SH>,<4*W-WR,CSR-.1,6*H>}
            // hinge
            #declare SX = CSR
            #declare SY = CSR
            object {#include "S_Box.inc" translate <0,-CSR/2,SH>}
            cylinder {SH*z,6*H*z,CSR/2}
        }
#if (l_highq)
    #declare SC = C
#else
    #declare SC = 0
#end
        box {<CSR,1,2*H+SC>,<-1,-1,2*H+SH>}
        box {<CSR,1,4*H-SC>,<-1,-1,4*H-SH>}
    }
    // left end
    #declare SX = CSD
    #declare SY = CSR
    object {#include "S_Box.inc" translate <4*W-WR-CSD,-CSR/2,SH>}
    // handle
    difference {
        merge {
            cylinder {<0,-WR,-SR+ES>,<0,WR,-SR+ES>,ES}
            box {<-E,-WR,-SR+ES,>,<E,WR,SR-ES>}
            cylinder {<0,-WR,SR-ES>,<0,WR,SR-ES>,ES}
        }
        box {<0,-WR+ES,-1,>,<1,WR-ES,1>}
        translate <3*W,0,SZ/2+SH>
    }
    box {<3*W-WR+E,-CSR/2,SZ/2+SH+H/2>,<4*W-WR-CSR,CSR/2,SZ/2+SH-H/2>}
    bounded_by {box {<-W,-H,0>,<4*W,H,7*H>}}
}
#declare l_garagedoor_se = object {
    l_garagedoor
    translate <0,-WR-SR/2,0>
}
#declare l_garagedoor_sw = object {
    l_garagedoor
    rotate 180*z
    translate <0,-WR-SR/2,0>
}


// Door
#declare l_door = merge {
    // door
    difference {
        box {<0,-WR,E>,<3.5*W,-WR+E,5*H>}
        #declare SZ = SD
        merge {
            #declare SX = 4*W-2*SZ
            #declare SY = (SX-3*E)/2
            box {TE*y,<SX,-W+G,SX>}
            box {<E,W,E>,<E+SY,-W,E+SY>}
            box {<E,W,SX-E>,<E+SY,-W,SX-E-SY>}
            box {<SX-E,W,E>,<SX-E-SY,-W,E+SY>}
            box {<SX-E,W,SX-E>,<SX-E-SY,-W,SX-E-SY>}
            translate <-WR+SZ,-WR,5*H-WR-SX>
        }
        difference {
            box {TE*y,<SX,-W+G,2*H-SZ-E>}
            box {<SR,W,SR>,<SX-SR,-W,2*H-SZ-E-SR>}
            translate <-WR+SZ,-WR,WR+E>
        }
    }
    // hinge
    difference {
        cylinder {0,5*H*z,WR}
        cylinder {-G,H*z,SR}
        cylinder {E*z,(5*H-E)*z,WR-E}
        box {<-W+E,E,E>,<W,W+G,5*H-E>}
    }
    object {l_stud translate 5*H*z}
    // handle
    merge {
        cylinder {<-SR+ES,-E,ES>,<-SR+ES,G,ES>,ES}
        box {<-SR+ES,-E,0>,<SR-ES,G,E>}
        cylinder {<SR-ES,-E,ES>,<SR-ES,G,ES>,ES}
        translate <2.5*W,-WR,2*H>
    }
}
#declare l_door_w = object {l_door}
#declare l_door_n = object {l_door rotate  90*z}
#declare l_door_e = object {l_door rotate 180*z translate 4*W*x}
#declare l_door_s = object {l_door rotate 270*z translate 4*W*y}

#end    // end library include
