/*
  L_Hinges.inc
  created by Steven L. Reid
  v1.1  2 Sep 97

  This file defines hinged bricks centered on the right front stud.
  L_Standard.inc and L_Flats.inc must be included first!

  v1.0 29 Aug 97 File created.
  v1.1  2 Sep 97 Added library include checks.
  v1.2 20 Sep 97 Added hinge2x4 for model 367.
  v1.3 29 Jun 98 Added hinge from 6024.
*/

// POV-Ray Version
#version 3.0

#ifndef (L_Hinges)
    #declare L_Hinges = true
    // include library!

// Ensure required libraries are included
#ifndef (L_Standard)
    #include "L_Standard.inc"
#end
#ifndef (L_Flats)
    #include "L_Flats.inc"
#end

/*
 * Static Hinges
 */

// Hinge 2 High
#declare SX = 1
#declare SY = 1
#declare SZ = 2*H
#declare l_hinge2s = union {
    #include "S_Bricks.inc"
    #if (l_highq)
    cylinder {<0,-W/2,C>,<0,-W/2,SH>,CSR}
    cylinder {<0,-W/2,2*H-C>,<0,-W/2,2*H-SH>,CSR}
    #else
    cylinder {<0,-W/2,0>,<0,-W/2,SH>,CSR}
    cylinder {<0,-W/2,2*H>,<0,-W/2,2*H-SH>,CSR}
    #end
}
#declare l_hinge2w = object {l_hinge2s rotate  90*z}
#declare l_hinge2n = object {l_hinge2s rotate 180*z}
#declare l_hinge2e = object {l_hinge2s rotate -90*z}

// Drop Hinge
#declare l_drophinge_e = union {
    difference {
        #if (l_highq)
            union {
                union {
                    sphere {C*z,C}
                    cylinder{C*z,(F-C)*z,C}
                    sphere {(F-C)*z,C}
                    translate <C,C,0>
                }
                union {
                    sphere {C*z,C}
                    cylinder{C*z,(F+2*W-C)*z,C}
                    sphere {(F+2*W-C)*z,C}
                    translate <2*W+F-C,C,0>
                }
                union {
                    sphere {C*z,C}
                    cylinder{C*z,(F-C)*z,C}
                    sphere {(F-C)*z,C}
                    translate <C,2*W-C,0>
                }
                union {
                    sphere {C*z,C}
                    cylinder{C*z,(F+2*W-C)*z,C}
                    sphere {(F+2*W-C)*z,C}
                    translate <2*W+F-C,2*W-C,0>
                }
                cylinder {<      C,    C,  C>,<2*W+F-C,    C,  C>,C}
                cylinder {<2*W+F-C,    C,  C>,<2*W+F-C,2*W-C,  C>,C}
                cylinder {<2*W+F-C,2*W-C,  C>,<      C,2*W-C,  C>,C}
                cylinder {<      C,2*W-C,  C>,<      C,    C,  C>,C}
                cylinder {<      C,    C,F-C>,<2*W    ,    C,F-C>,C}
                cylinder {<2*W    ,2*W-C,F-C>,<      C,2*W-C,F-C>,C}
                cylinder {<      C,2*W-C,F-C>,<      C,    C,F-C>,C}
                box {<C,0,C>,<2*W+F-C,2*W  ,F-C>}
                box {<0,C,C>,<2*W+F  ,2*W-C,F-C>}
                box {<C,C,0>,<2*W+F-C,2*W-C,F  >}
            }
        #else
            box {<0,    0, 0>,<2*W+F,2*W  ,F  >}
        #end
        box {<E,    E,-E>,<2*W-E,2*W-E,F-E>}
        box {<2*W,  E,-E>,<3*W  ,  W-E,SH >}
        box {<2*W,W+E,-E>,<3*W  ,2*W-E,SH >}
        cylinder {<W,W,0>,<W,W,H/2>,SR}
    }
    object { l_cbf translate <W, W, 0> }
    difference {
        #if (l_highq)
            union {
                union {
                    cylinder{(F-C)*z,(2*W+F-C)*z,C}
                    sphere {(2*W+F-C)*z,C}
                    translate <2*W+C,C,0>
                }
                union {
                    cylinder{(F-C)*z,(2*W+F-C)*z,C}
                    sphere {(2*W+F-C)*z,C}
                    translate <2*W+C,2*W-C,0>
                }
                cylinder {<2*W+  C,    C,2*W+F-C>,<2*W+F-C,    C,2*W+F-C>,C}
                cylinder {<2*W+F-C,    C,2*W+F-C>,<2*W+F-C,2*W-C,2*W+F-C>,C}
                cylinder {<2*W+F-C,2*W-C,2*W+F-C>,<2*W+  C,2*W-C,2*W+F-C>,C}
                cylinder {<2*W+  C,2*W-C,2*W+F-C>,<2*W+  C,    C,2*W+F-C>,C}
                box {<2*W+C,0,F-C>,<2*W+F-C,2*W  ,2*W+F-C>}
                box {<2*W  ,C,F-C>,<2*W+F  ,2*W-C,2*W+F-C>}
                box {<2*W+C,C,F-C>,<2*W+F-C,2*W-C,2*W+F  >}
            }
        #else
            box {<2*W  ,0,F>,<2*W+F  ,2*W  ,2*W+F  >}
        #end
        box {<2*W-E,E,F>,<2*W+F-E,2*W-E,2*W+F-E>}
        cylinder {<2*W,W,W+F>,<3*W,W,W+F>,SR}
    }
    difference {
        cylinder {<2*W  ,W,W+F>,<2*W+F,W,W+F>,CBR}
        cylinder {<2*W-G,W,W+F>,<3*W  ,W,W+F>,SR }
    }
    object { l_stud rotate y*90 translate <2*W+F, W*0.5, F+0.5*W> }
    object { l_stud rotate y*90 translate <2*W+F, W*1.5, F+0.5*W> }
    object { l_stud rotate y*90 translate <2*W+F, W*0.5, F+1.5*W> }
    object { l_stud rotate y*90 translate <2*W+F, W*1.5, F+1.5*W> }
    translate <-W/2, -W/2, 0>
}

// different orientations
#declare l_drophinge_n = object {l_drophinge_e rotate z*-90 translate <0,W,0>}
#declare l_drophinge_s = object {l_drophinge_e rotate z* 90 translate <W,0,0>}
#declare l_drophinge_w = object {l_drophinge_e rotate z*180 translate <W,W,0>}

// Square Hinge
#declare l_hinge2x1f = union {
    #declare SX = 2 #declare SY = 1 #declare SZ = F
    object {#include "S_Bricks.inc" translate <WR,WR,0>}
    // Hinge
    box {<F,0,0>,<F+SH,-WR,F>}
    box {<2*W-F,0,0>,<2*W-F-SH,-WR,F>}
    cylinder {<F,-WR,SR>,<F+SH,-WR,SR>,SR}
    cylinder {<2*W-F,-WR,SR>,<2*W-F-SH,-WR,SR>,SR}
    cylinder {<0,-WR,SR>,<2*W,-WR,SR>,CSR}
    translate <-WR,-WR,0>
}
#declare l_hinge2x1f_s = object {l_hinge2x1f}
#declare l_hinge2x1f_n = object {l_hinge2x1f rotate z*180 translate <W,0,0>}
#declare l_hinge1x2f_e = object {l_hinge2x1f rotate z*-90 translate <0,W,0>}
#declare l_hinge1x2f_w = object {l_hinge2x1f rotate z* 90}


/*
 * Movable Hinges
 */

// Hinge 2x4 (bottom only, used in 367 Moon Lander)
#declare l_hinge2x4 = union {
    object {l_br2x4f}
    difference {
        cylinder {<     0,0,0>,<2*W   ,0,0>,SR+.1}
        cylinder {<-   .2,0,0>,<    .2,0,0>,SR}
        cylinder {<2*W+.2,0,0>,<2*W-.2,0,0>,SR}
        translate <-WR,-WR-SR-.1,.1>
    }
}
#declare l_hinge4x2e = union {  // used in model 483 Alpha Moon Base
        object {l_br4x2f}
        union {
            difference {
                cylinder {<0, 0,0>,<0,2*W  ,0>,CBR}
                cylinder {<0,-G,0>,<0,2*W+G,0>,SR}
            }
            cylinder {
                <0,E,0>,<0,2*W-E,0>,SR
                texture {l_red}
            }
            translate <CBR-WR,-WR,F>
            translate 4*W*x
        }
}
#declare l_hinge4x2w = object {l_hinge4x2e rotate 180*z translate <3*W,  W,0>}
#declare l_hinge2x4n = object {l_hinge4x2e rotate -90*z translate <  0,3*W,0>}
#declare l_hinge2x4s = object {l_hinge4x2e rotate  90*z translate <  E,  0,0>}

// Hinge 1x2
#declare l_hinge1x2base = union {
    difference {
        #if (l_highq)
            union {
                union {
                    sphere {C*z,C}
                    cylinder{C*z,(H-C)*z,C}
                    translate <C,C,0>
                }
                union {
                    sphere {C*z,C}
                    cylinder{C*z,(H-ES-C)*z,C}
                    sphere {(H-ES-C)*z,C}
                    translate <W-C,C,0>
                }
                union {
                    sphere {C*z,C}
                    cylinder{C*z,(H-C)*z,C}
                    translate <C,2*W-C,0>
                }
                union {
                    sphere {C*z,C}
                    cylinder{C*z,(H-ES-C)*z,C}
                    sphere {(H-ES-C)*z,C}
                    translate <W-C,2*W-C,0>
                }
                cylinder {<  C,    C,     C>,<W-C,    C,     C>,C}
                cylinder {<W-C,    C,     C>,<W-C,2*W-C,     C>,C}
                cylinder {<W-C,2*W-C,     C>,<  C,2*W-C,     C>,C}
                cylinder {<  C,2*W-C,     C>,<  C,    C,     C>,C}
                cylinder {<  C,    C,H-ES-C>,<W-C,    C,H-ES-C>,C}
                cylinder {<W-C,    C,H-ES-C>,<W-C,2*W-C,H-ES-C>,C}
                cylinder {<W-C,2*W-C,H-ES-C>,<  C,2*W-C,H-ES-C>,C}
                box {<C,0,C>,<W-C,2*W  ,H-ES-C>}
                box {<0,C,C>,<W  ,2*W-C,H-ES-C>}
                box {<C,C,0>,<W-C,2*W-C,H-ES  >}
            }
        #else
            box {<0,0,0>,<W,2*W,H-ES>}
        #end
        // subtract...
        box {<-G,-G,H-ES-TE>,<W/2,2*W+G,H>}             // top cuts
        plane {-z,0 rotate  -65*y translate <ES,0,H-F>}
        box {<-G,-G,H-W   >,<  ES,2*W+G,H>}             // front cut
        box {<-G, E,F     >,<W-ES,2*W-E,H>}             // middle cut
        cylinder {<W/2,-G,H-W/2>,<W/2,2*W+G,H-W/2>,CSR} // hole cuts
        box {<W/2-CSR-G,-G,H-W/2>,<W/2+CSR+G,2*W+G,H>}
        box {<E,   E,-G>,<W-E,  W-ES,F-E>}              // bottom cuts
        box {<E,W+ES,-G>,<W-E,2*W-E ,F-E>}
    }
    box {<W/2-ES,W-ES,F>,<W/2+ES,W+ES,H-W/2>}           // center support
    cylinder {<W/2,W-ES,H-W/2>,<W/2,W+ES,H-W/2>,ES}

    translate <-W/2,-W/2,0>
}
#declare l_hinge1x2top = union {
        #if (l_highq)
            union {
                union {
                    sphere {C*z,C}
                    cylinder{C*z,(ES-C)*z,C}
                    sphere {(ES-C)*z,C}
                    translate <C,C,H-ES>
                }
                union {
                    sphere {C*z,C}
                    cylinder{C*z,(ES-C)*z,C}
                    sphere {(ES-C)*z,C}
                    translate <W-C,C,H-ES>
                }
                union {
                    sphere {C*z,C}
                    cylinder{C*z,(ES-C)*z,C}
                    sphere {(ES-C)*z,C}
                    translate <C,2*W-C,H-ES>
                }
                union {
                    sphere {C*z,C}
                    cylinder{C*z,(ES-C)*z,C}
                    sphere {(ES-C)*z,C}
                    translate <W-C,2*W-C,H-ES>
                }
                cylinder {<  C,    C,H-ES+C>,<W-C,    C,H-ES+C>,C}
                cylinder {<W-C,    C,H-ES+C>,<W-C,2*W-C,H-ES+C>,C}
                cylinder {<W-C,2*W-C,H-ES+C>,<  C,2*W-C,H-ES+C>,C}
                cylinder {<  C,2*W-C,H-ES+C>,<  C,    C,H-ES+C>,C}
                cylinder {<  C,    C,H-C   >,<W-C,    C,H-C   >,C}
                cylinder {<W-C,    C,H-C   >,<W-C,2*W-C,H-C   >,C}
                cylinder {<W-C,2*W-C,H-C   >,<  C,2*W-C,H-C   >,C}
                cylinder {<  C,2*W-C,H-C   >,<  C,    C,H-C   >,C}
                box {<C,0,H-ES+C>,<W-C,2*W  ,H-C>}
                box {<0,C,H-ES+C>,<W  ,2*W-C,H-C>}
                box {<C,C,H-ES  >,<W-C,2*W-C,H  >}
            }
        #else
            box {<0,0,H-ES>,<W,2*W,H>}                  // top
        #end
    box {<W/2-SR,E,H-W/2>,<W/2+SR,E+ES,H-ES>}           // sides
    cylinder {<W/2,E,H-W/2>,<W/2,E+ES,H-W/2>,SR}
    #if (l_highq)
       difference {
            merge {
                torus {CSR-C,C translate <W/2,C,H-W/2>}
                cylinder {<W/2,0,H-W/2>,<W/2,E,H-W/2>,CSR-C}
                cylinder {<W/2,C,H-W/2>,<W/2,E,H-W/2>,CSR}
            }
            cylinder {<W/2,-G,H-W/2>,<W/2,E,H-W/2>,CSR-ES}
        }
    #else
        difference {
            cylinder {<W/2, 0,H-W/2>,<W/2,E,H-W/2>,CSR}
            cylinder {<W/2,-G,H-W/2>,<W/2,E,H-W/2>,CSR-ES}
        }
    #end
    box {<W/2-SR,2*W-E,H-W/2>,<W/2+SR,2*W-E-ES,H-ES>}
    cylinder {<W/2,2*W-E,H-W/2>,<W/2,2*W-E-ES,H-W/2>,SR}
    #if (l_highq)
       difference {
            merge {
                torus {CSR-C,C translate <W/2,2*W-C,H-W/2>}
                cylinder {<W/2,2*W  ,H-W/2>,<W/2,2*W-E,H-W/2>,CSR-C}
                cylinder {<W/2,2*W-C,H-W/2>,<W/2,2*W-E,H-W/2>,CSR}
            }
            cylinder {<W/2,2*W+G,H-W/2>,<W/2,2*W-E,H-W/2>,CSR-ES}
        }
    #else
        difference {
            cylinder {<W/2,2*W  ,H-W/2>,<W/2,2*W-E,H-W/2>,CSR}
            cylinder {<W/2,2*W+G,H-W/2>,<W/2,2*W-E,H-W/2>,CSR-ES}
        }
    #end
    difference {                                        // middle
        box {<W/2-ES/2,E+ES,H-W/2-CSR>,<W/2+ES/2,2*W-E-ES,H-ES    >}
        box {<       0,W-ES,        0>,<W       ,    W+ES,H+ES-W/2>}
    }
    object {l_studh translate <0.5*W,0.5*W,H>}
    object {l_studh translate <0.5*W,1.5*W,H>}

    translate <-W/2, -W/2, 0>
}

#end    // end library include
