/*
  L_Glass.inc
  created by Steven L. Reid
  v1.1  2 Sep 97

  This file defines glass and clear type bricks centered on the
  right front stud.
  L_Standard.inc must be included first!

  v1.0 30 Aug 97 File created.
  v1.1  2 Sep 97 Added library include checks.
*/

// POV Version
#version 3

#ifndef (L_Glass)
    #declare L_Glass = true
    // include library!

// Ensure required libraries are included
#ifndef (L_Standard)
    #include "L_Standard.inc"
#end

// These are all high bricks (glass, of course!)
#declare SZ = -H

// Glass 1x2 Brick
#declare SX = 1
#declare SY = 2
#declare l_glass1x2 = #include "S_Bricks.inc"
#declare l_glass2x1 = object {l_glass1x2 rotate -90*z}

// Glass 1x4 Brick
#declare SX = 1
#declare SY = 4
#declare l_glass1x4 = #include "S_Bricks.inc"
#declare l_glass4x1 = object {l_glass1x4 rotate -90*z}

// Wind Shield 2x4 (new)
#declare l_window_cut_outer = difference {
    box {<-2,-1,-10>,<0,4,10>}
    box {<-WR,0,-11>,<1,6*WR,10>}
    cylinder {-11*z,11*z,WR}
    cylinder {-11*z,11*z,WR translate 6*WR*y}
}
#declare l_window_cut_inner = difference {
    box {<-2,-1,-10>,<0,4,10>}
    box {<-WR+E,0,-11>,<1,6*WR,10>}
    cylinder {-11*z,11*z,WR-E}
    cylinder {-11*z,11*z,WR-E translate 6*WR*y}
}
#declare l_windshield2x4e = merge {
    difference {
        box {<-WR-G, -WR, 0>,<3*WR, 7*WR, 2*H> }
        difference {
            box { <-1, -SR, F> <2, 3*W+SR, 2*H-E> }
            object { l_window_cut_inner rotate 27*y translate SH*z}
        }
        object { l_window_cut_outer}
        object { l_window_cut_outer  rotate 27*y translate SH*z}
        box { <WR, WR, -1> <2, 5*WR, 1> }
        cylinder { -z, z, WR   translate <3*WR,  WR, 0> }   // back cuts
        cylinder { -z, z, WR   translate <3*WR,5*WR, 0> }   // back cuts
        cylinder { -.1*z, (F-E)*z, E translate <-WR+2*E,- WR+2*E,0> }    // inner cuts
        cylinder { -.1*z, (F-E)*z, E translate <-WR+2*E,7*WR-2*E,0> }    // of edge
        box {<-WR+2*E, -WR+  E, -G>,<3*WR-E,  WR-  E,F-E>} // inner
        box {<-WR+2*E,5*WR+  E, -G>,<3*WR-E,7*WR-  E,F-E>} // cuts
        box {<-WR+  E, -WR+2*E, -G>,<  WR-E,7*WR-2*E,F-E>}
        difference {
            box { <.49, -2.5, 1.1>,<1.5, 6*WR+.25, 2> }
            cylinder { z, 3*z, .5 translate <.725, -    .2, 0> }
            cylinder { z, 3*z, .5 translate <.725, 6*WR+.2, 0> }
            box { <.5 , -    .5 , 1>,< 2, -    .2, 3> }
            box { <.5 , 6*WR+.5 , 1>,< 2, 6*WR+.2, 3> }
        }
    }
    object {l_studh translate <W, 0  ,2*H>}
    object {l_studh translate <W, 3*W,2*H>}
    object {l_csf translate <WR,0    ,0>}
    object {l_csf translate < 0, .5*W,0>}
    object {l_csf translate < 0,1.5*W,0>}
    object {l_csf translate < 0,2.5*W,0>}
    object {l_csf translate <WR,3  *W,0>}
}
#declare l_windshield2x4w = object{l_windshield2x4e rotate 180*z translate <W,3*W,0>}
#declare l_windshield4x2n = object{l_windshield2x4e rotate -90*z translate <0,  W,0>}
#declare l_windshield4x2s = object{l_windshield2x4e rotate  90*z translate <3*W,W,0>}

#end    // end library include
