/*
  L_Flats.inc
  created by Steven L. Reid
  v1.2 31 Aug 97

  This file defines flat bricks centered on the right front stud.
  L_Standard.inc must be included first!

  v1.0 23 Jul 97 File created.
  v1.1 18 Aug 97 Fixed rotation errors.
  v1.2 31 Aug 97 Added library include checks.
*/

// POV-Ray Version
#version 3.0

#ifndef (L_Flats)
    #declare L_Flats = true
    // include library!

// Ensure required libraries are included
#ifndef (L_Standard)
    #include "L_Standard.inc"
#end

// These are all flat bricks
#declare SZ = F

// Brick 1x1 Flat
#declare SX = 1
#declare SY = 1
#declare l_br1x1f = #include "S_Bricks.inc"

// Brick 1x2 Flat
#declare SX = 1
#declare SY = 2
#declare l_br1x2f = #include "S_Bricks.inc"
#declare l_br2x1f = object {l_br1x2f rotate -90*z}

// Brick 1x3 Flat
#declare SX = 1
#declare SY = 3
#declare l_br1x3f = #include "S_Bricks.inc"
#declare l_br3x1f = object {l_br1x3f rotate -90*z}

// Brick 1x4 Flat
#declare SX = 1
#declare SY = 4
#declare l_br1x4f = #include "S_Bricks.inc"
#declare l_br4x1f = object {l_br1x4f rotate -90*z}

// Brick 1x6 Flat
#declare SX = 1
#declare SY = 6
#declare l_br1x6f = #include "S_Bricks.inc"
#declare l_br6x1f = object {l_br1x6f rotate -90*z}

// Brick 1x8 Flat
#declare SX = 1
#declare SY = 8
#declare l_br1x8f = #include "S_Bricks.inc"
#declare l_br8x1f = object {l_br1x8f rotate -90*z}

// Brick 1x10 Flat
#declare SX = 1
#declare SY = 10
#declare l_br1x10f = #include "S_Bricks.inc"
#declare l_br10x1f = object {l_br1x10f rotate -90*z}

// Brick 2x2 Flat
#declare SX = 2
#declare SY = 2
#declare l_br2x2f = #include "S_Bricks.inc"

// Brick 2x3 Flat
#declare SX = 2
#declare SY = 3
#declare l_br2x3f = #include "S_Bricks.inc"
#declare l_br3x2f = object {l_br2x3f rotate -90*z translate W*y}

// Brick 2x4 Flat
#declare SX = 2
#declare SY = 4
#declare l_br2x4f = #include "S_Bricks.inc"
#declare l_br4x2f = object {l_br2x4f rotate -90*z translate W*y}

// Brick 2x6 Flat
#declare SX = 2
#declare SY = 6
#declare l_br2x6f = #include "S_Bricks.inc"
#declare l_br6x2f = object {l_br2x6f rotate -90*z translate W*y}

// Brick 2x8 Flat
#declare SX = 2
#declare SY = 8
#declare l_br2x8f = #include "S_Bricks.inc"
#declare l_br8x2f = object {l_br2x8f rotate -90*z translate W*y}

// Brick 2x10 Flat
#declare SX = 2
#declare SY = 10
#declare l_br2x10f = #include "S_Bricks.inc"
#declare l_br10x2f = object {l_br2x10f rotate -90*z translate W*y}

// Brick 2x12 Flat
#declare SX = 2
#declare SY = 12
#declare l_br2x12f = #include "S_Bricks.inc"
#declare l_br12x2f = object {l_br2x12f rotate -90*z translate W*y}

// Brick 4x4 Flat
#declare SX = 4
#declare SY = 4
#declare l_br4x4f = #include "S_Bricks.inc"

// Brick 4x6 Flat
#declare SX = 4
#declare SY = 6
#declare l_br4x6f = #include "S_Bricks.inc"
#declare l_br6x4f = object {l_br4x6f rotate -90*z translate 3*W*y}

// Brick 4x8 Flat
#declare SX = 4
#declare SY = 8
#declare l_br4x8f = #include "S_Bricks.inc"
#declare l_br8x4f = object {l_br4x8f rotate -90*z translate 3*W*y}

// Brick 4x10 Flat
#declare SX = 4
#declare SY = 10
#declare l_br4x10f = #include "S_Bricks.inc"
#declare l_br10x4f = object {l_br4x10f rotate -90*z translate 3*W*y}

// Brick 4x12 Flat
#declare SX = 4
#declare SY = 12
#declare l_br4x12f = #include "S_Bricks.inc"
#declare l_br12x4f = object {l_br4x12f rotate -90*z translate 3*W*y}

// Brick 6x6 Flat
#declare SX = 6
#declare SY = 6
#declare l_br6x6f = #include "S_Bricks.inc"

// Brick 6x8 Flat
#declare SX = 6
#declare SY = 8
#declare l_br6x8f = #include "S_Bricks.inc"
#declare l_br8x6f = object {l_br6x8f rotate -90*z translate 5*W*y}

// Brick 6x10 Flat
#declare SX = 6
#declare SY = 10
#declare l_br6x10f = #include "S_Bricks.inc"
#declare l_br10x6f = object {l_br6x10f rotate -90*z translate 5*W*y}

// Brick 6x12 Flat
#declare SX = 6
#declare SY = 12
#declare l_br6x12f = #include "S_Bricks.inc"
#declare l_br12x6f = object {l_br6x12f rotate -90*z translate 5*W*y}

// Brick 6x16 Flat
#declare SX = 6
#declare SY = 16
#declare l_br6x16f = #include "S_Bricks.inc"
#declare l_br16x6f = object {l_br6x16f rotate -90*z translate 5*W*y}

#end    // end library include
