/*
  L_Car.inc
  created by Steven L. Reid
  v1.1  2 Sep 97

  This file defines car style bricks centered on the right front stud.
  L_Standard.inc and L_Flats.inc must be included first!

  v1.0 30 Aug 97 File created.
  v1.1  2 Sep 97 Added library include checks.
  v1.2 17 Sep 97 Updated some high quality bricks.
*/

// POV-Ray Version
#version 3.0

#ifndef (L_Car)
    #declare L_Car = true
    // include library!

// Ensure required libraries are included
#ifndef (L_Standard)
    #include "L_Standard.inc"
#end
#ifndef (L_Flats)
    #include "L_Flats.inc"
#end

// Hitch
#declare l_hitch_ball = union {
    object {l_br2x2f translate <WR,WR,0>}
    cylinder{<C,W,E>,<-WR,W,E>,E}
    sphere {<-WR,W,E>,SR}
    translate <-WR,-WR,0>
}
#declare l_hitch = union {
    cylinder{<2*W,W,E>,<2*W+SH/2,W,E>,E}
    difference {
        union {
            torus {SR,.1 rotate z*90 translate <.1,0,0>}
            cylinder {<0,0,0>,<.1,0,0>,SR}
            cylinder{<.1,0,0>,<SD+.1,0,0>,SR+E}
            torus {SR,.1 rotate z*90 translate <SD+.1,0,0>}
        }
        cylinder{<.1,0,0>,<SD+.05,0,0>,SR}
        box {<SR+.1,-1,-.1>,<2,1,.1>}
        box {<SR+.1,-.1,-1>,<2,.1,1>}
        cylinder{<SD+.2,-1,0>,<SD+.2,1,0>,.2}
        translate <2*W+SH/2,W,E>
    }
    object {l_br2x2f translate <WR,WR,0>}
    translate <-WR,-WR,0>
}

// Fenders
#declare l_fender_bent = merge {
    object {l_br2x2f translate <WR,WR,0>}
    intersection {
        union {
            box {<WR,0,F2>,<1.5*W,-W,F2-SH>}
            box {<WR,0,F2>,<1.5*W,-G,F>}
            box {<-SH,0,0>,< H,-W,SH> rotate -y*50 translate        SH/2*x}
            box {< SH,0,0>,<-H,-W,SH> rotate  y*50 translate (2*W-SH/2)*x}
        }
        box {<0,0,0>,<2*W,-W+G,F2+G>}
    }
    intersection {
        union {
            box {<WR,2*W,F2>,<1.5*W,3*W,F2-SH>}
            box {<WR,2*W,F2>,<1.5*W,2*W+G,F>}
            box {<-SH,2*W,0>,< H,3*W,SH> rotate -y*50 translate        SH/2*x}
            box {< SH,2*W,0>,<-H,3*W,SH> rotate  y*50 translate (2*W-SH/2)*x}
        }
        box {<0,2*W-G,0>,<2*W,3*W-G,F2+G>}
    }
    translate <-WR,-WR,0>
}
#declare l_fender_block = merge {
    object {l_br2x2f translate <WR,WR,0>}
    object {l_stud translate <0.5*W,-0.5*W,F2>}
    object {l_stud translate <1.5*W,-0.5*W,F2>}
    object {l_stud translate <0.5*W, 2.5*W,F2>}
    object {l_stud translate <1.5*W, 2.5*W,F2>}
    intersection {
        union {
            box {<WR,0,F2>,<1.5*W,-W,F2-SH>}
            box {<WR,0,F2>,<1.5*W,-G,F>}
            box {<-SH,0,0>,< H,-W,1> rotate -y*50 translate        SH/2*x}
            box {< SH,0,0>,<-H,-W,1> rotate  y*50 translate (2*W-SH/2)*x}
        }
        box {<0,0,0>,<2*W,-W+G,F2+G>}
    }
    intersection {
        union {
            box {<WR,2*W,F2>,<1.5*W,3*W,F2-SH>}
            box {<WR,2*W,F2>,<1.5*W,2*W+G,F>}
            box {<-SH,2*W,0>,< H,3*W,1> rotate -y*50 translate        SH/2*x}
            box {< SH,2*W,0>,<-H,3*W,1> rotate  y*50 translate (2*W-SH/2)*x}
        }
        box {<0,2*W,0>,<2*W,3*W-G,F2+G>}
    }
    translate <-WR,-WR,0>
}


// Wheels (must add base plate) (needs l_highq)
#declare l_wheels_smooth = union {
    cylinder {<0,-.3-SH,0>,<0,-.3,0>,SR texture {l_red}}
    cylinder {<0,-.3,0>,<0,-.1,0>,.4 texture {l_red}}
    torus {.5,.2 translate <0,-.2,0> pigment {c_black}}
    cylinder {<0,-.1,0>,<0,2*W+.1,0>,.1 texture {l_silver}}
    cylinder {<0,2*W+.3,0>,<0,2*W+.3+SH,0>,SR texture {l_red}}
    cylinder {<0,2*W+.1,0>,<0,2*W+.3,0>,.4 texture {l_red}}
    torus {.5,.2 translate <0,2*W+.2,0> pigment {c_black}}
    translate <WR,-WR,0>
}

#declare l_wheels_knoby = union {
    cylinder {<0,-.7+SH,0>,<0,-.7,0>,SR texture {l_red}}
    cylinder {<0,-.7+SH,0>,<0,-.1,0>,.45 texture {l_red}}
    difference {
        cylinder {<0,-.1,0>,<0,-.7,0>,.7}
        cylinder {<0,  0,0>,<0,- 1,0>,.45}
         #declare Count=0
         #while (Count < 360)
            box{<.075,0,0>,<-.075,-.4,.4> translate <0,0,.6> rotate Count*y}
            box{<.075,-.4,0>,<-.075,-1,.4> translate <0,0,.6> rotate (Count+180/16)*y}
            #declare Count=Count+360/16
         #end
    }
    cylinder {<0,-.1,0>,<0,2*W+.1,0>,.1 texture {l_silver}}
    cylinder {<0,2*W+.7,0>,<0,2*W+.7-SH,0>,SR texture {l_red}}
    cylinder {<0,2*W+.1,0>,<0,2*W+.7-SH,0>,.45 texture {l_red}}
    difference {
        cylinder {<0,2*W+.1,0>,<0,2*W+.7,0>,W-.1}
        cylinder {<0,2*W   ,0>,<0,3*W   ,0>,.45}
         #declare Count=0
         #while (Count < 360)
            box{<.075,2*W   ,0>,<-.075,2*W+.4,.4> translate <0,0,.6> rotate Count*y}
            box{<.075,2*W+.4,0>,<-.075,3*W   ,.4> translate <0,0,.6> rotate (Count+180/16)*y}
            #declare Count=Count+360/16
         #end
    }
    translate <WR,-WR,0>
}

// one_wheel_knoby
#declare l_one_wheel_ew = union {
    // top
    object {l_br2x2f translate F2*z}
    union {
        // side rails
        difference {
            box {<SR,-.40,-.05>,<-SR,.40,F2+E>}
            box {<-1,-.31,-1  >,<1,.31,2>}
            cylinder {y,-y,CSR}
        }
        // wheel
        cylinder {.3*y,-.3*y,.46 texture {l_red}}
        cylinder {.4*y,-.4*y,CSR texture {l_red}}
        difference {
            cylinder {.3*y,-.3*y,.70}
            cylinder {   y,-   y,.45}
             #declare Count=0
             #while (Count < 360)
                box{<.075,  0,0>,<-.075,-.4,.4> translate <0,0,.6> rotate Count*y}
                box{<.075,  0,0>,<-.075, .4,.4> translate <0,0,.6> rotate (Count+180/16)*y}
                #declare Count=Count+360/16
             #end
             texture {l_black}
        }
        translate <WR,WR,0>
    }
}
#declare l_one_wheel_ns = object {l_one_wheel_ew rotate 90*z translate W*x}

// Steering Wheel
#declare l_steering_wheel = union {
    #declare SX = 1
    #declare SY = 2
    #declare SZ = F
    difference {
        #include "S_Box.inc"
//        box {<0,0,0>,<W,2*W,F>}
        box {<E,E,-E>,<W-E,2*W-E,F-E>}
    }
    object {l_csf translate <WR,W,0>}
    #declare SX = 0.2
    #declare SY = 1
    #declare SZ = H+E
    object {#include "S_Box.inc" translate <W-E,WR,F-E>}
//    box {<W-E,WR,F>,<W,1.5*W,H+F>}
    difference {
        cylinder {
            <0,0,E>,<0,0,H+F>,1
            scale <.1,.2,1>
            translate <W-E,W,0>
        }
        box {<W,0,H>,<2*W,2*W,2*H>}
    }
    cylinder {
        <0,0,0>,<0,0,.4>,.15
        rotate y*-45
        translate <W-.15,W,F+H-.15>
    }
    union {
        difference {
            cylinder {.1*z,.4*z,.2 }
            cylinder {   0,.5*z,.15}
        }
        difference {
#if (l_highq)
            merge {
                torus {.45,.05 rotate 90*x translate .45*z}
                cylinder {(.3+C)*z,.45*z,.5}
                torus {.5-C,C rotate 90*x translate (.3+C)*z}
                cylinder {.3*z,.4*z,(.5-C)}
            }
#else
            cylinder {.3*z,.5*z,.5}
#end
            cylinder {0,.6*z,.4}
        }
        intersection {
            union {
                box {<.155,-.075,.1>,<.45,.075,.4>}
                box {<.155,-.075,.1>,<.45,.075,.4> rotate  120*z}
                box {<.155,-.075,.1>,<.45,.075,.4> rotate -120*z}
            }
            cone {.1*z,.2,.3*z,.4}
        }
        rotate y*-45
        translate <W-.15,W,F+H-.15>
        texture {l_black}
    }
    translate <-WR,-WR,0>
}

// car doors
#declare l_door3x1se = difference {
    union {
#if (l_highq)
        // hinge
        torus {WR-C,C rotate 90*x translate C*z}
        cylinder {  0,    H*z,WR-C}
        cylinder {C*z,(H-C)*z,WR}
        torus {WR-C,C rotate 90*x translate (H-C)*z}
        // door
        object {
            #declare SX = (2.5*W+C)/W
            #declare SY = E/W
            #declare SZ = H
            #include "S_Box.inc"
            translate <-2.5*W+C,-WR,0>
        }
#else
        // hinge
        cylinder {0,H*z,WR}
        // door
        box {-WR*y,<-2.5*W,-WR+E,H>}
#end
        // handle
        union {
            cylinder {<ES,0,0>,<ES,-E,0>,TE}
            box {<ES,0,TE>,<-ES,-E,-TE>}
            cylinder {<-ES,0,0>,<-ES,-E,0>,TE}
            translate <-2*W,-WR,H/2>
        }
        object {l_stud translate H*z}
    }
    // cut out hole in hinge
    cylinder {-G*z,(H-E)*z,SR}
}
#declare l_door3x1ne = object {l_door3x1se scale <1,-1,1>}

#end    // end library include
