/*
  L_Bricks.inc
  created by Steven L. Reid
  v1.2 31 Aug 97

  This file defines high bricks centered on the right front stud.
  L_Standard.inc must be included first!

  v1.0 20 Jul 97 File created.
  v1.1 18 Aug 97 Fixed rotation errors.
  v1.2 31 Aug 97 Added library include checks.
*/

// POV-Ray Version
#version 3.0

#ifndef (L_Bricks)
    #declare L_Bricks = true
    // include library!

// Ensure required libraries are included
#ifndef (L_Standard)
    #include "L_Standard.inc"
#end


// These are all high bricks
#declare SZ = H

// Brick 1x1
#declare SX = 1
#declare SY = 1
#declare l_br1x1 = #include "S_Bricks.inc"

// Brick 1x2
#declare SX = 1
#declare SY = 2
#declare l_br1x2 = #include "S_Bricks.inc"
#declare l_br2x1 = object {l_br1x2 rotate -90*z}

// Brick 1x3
#declare SX = 1
#declare SY = 3
#declare l_br1x3 = #include "S_Bricks.inc"
#declare l_br3x1 = object {l_br1x3 rotate -90*z}

// Brick 1x4
#declare SX = 1
#declare SY = 4
#declare l_br1x4 = #include "S_Bricks.inc"
#declare l_br4x1 = object {l_br1x4 rotate -90*z}

// Brick 1x6
#declare SX = 1
#declare SY = 6
#declare l_br1x6 = #include "S_Bricks.inc"
#declare l_br6x1 = object {l_br1x6 rotate -90*z}

// Brick 1x8
#declare SX = 1
#declare SY = 8
#declare l_br1x8 = #include "S_Bricks.inc"
#declare l_br8x1 = object {l_br1x8 rotate -90*z}

// Brick 2x2
#declare SX = 2
#declare SY = 2
#declare l_br2x2 = #include "S_Bricks.inc"

// Brick 2x3
#declare SX = 2
#declare SY = 3
#declare l_br2x3 = #include "S_Bricks.inc"
#declare l_br3x2 = object {l_br2x3 rotate -90*z translate W*y}

// Brick 2x4
#declare SX = 2
#declare SY = 4
#declare l_br2x4 = #include "S_Bricks.inc"
#declare l_br4x2 = object {l_br2x4 rotate -90*z translate W*y}

// Brick 2x6
#declare SX = 2
#declare SY = 6
#declare l_br2x6 = #include "S_Bricks.inc"
#declare l_br6x2 = object {l_br2x6 rotate -90*z translate W*y}

// Brick 2x8
#declare SX = 2
#declare SY = 8
#declare l_br2x8 = #include "S_Bricks.inc"
#declare l_br8x2 = object {l_br2x8 rotate -90*z translate W*y}

// Brick 2x10
#declare SX = 2
#declare SY = 10
#declare l_br2x10 = #include "S_Bricks.inc"
#declare l_br10x2 = object {l_br2x10 rotate -90*z translate W*y}

// Brick 2x12
#declare SX = 2
#declare SY = 12
#declare l_br2x12 = #include "S_Bricks.inc"
#declare l_br12x2 = object {l_br2x12 rotate -90*z translate W*y}

#end    // end library include
