package x360voice;

######################################################################
#
# package: x360voice.pm
# system : 360voice Mod for WebAPP NE (Network Edition)
# author : Copyright (C) 2007 Steven L. Reid
# purpose: Perl package for 360voice API.
# history:
# 3/25/2007, Steven Reid
#	- package created
#
######################################################################

# load exporter
use Exporter;
@ISA    = qw(Exporter);
@EXPORT = qw(x3v_get_entries x3v_get_badges
             x3v_get_games x3v_get_leaderboard
	     x3v_check_gamertag x3v_get_profile);
@EXPORT_OK = qw();
%EXPORT_TAGS = ();

# load libraries
use strict;
use LWP::UserAgent;
use HTML::Entities;

# package variables
use vars qw();

# PUBLIC

######################################################################
# Get blog (blog-getentries.asp)
######################################################################
sub x3v_get_entries {
  my $gamertag = shift || return ('error'=>'No GamerTag!');
  my $entries = shift || 5;
  my $api = 'http://www.360voice.com/api/blog-getentries.asp';
  
  # set up agent 
  my $ua = LWP::UserAgent->new;
  $ua->timeout(10);
  $ua->env_proxy;

  # get blogs
  my $response = $ua->get("$api?tag=$gamertag&num=$entries");
  if ($response->is_success) {
    # success, get results
    my $voice = decode_entities($response->content);
    if ($voice =~ /\<error\>(.+?)\<\\error\>/m) {
      # oops, api isn't happy
      return ('error'=>$1);
    }
    # parse entries and return them
    my %entries; my $entry = 0;
    for (split(/\n/, $voice)) {
      if (/\<entry/) {
	$entry++;
      } elsif (/\<gamertag\>(.+)\<\/gamertag\>/) {
	$entries{'data'}->[$entry]{'gamertag'} = $1;
      } elsif (/\<date\>(.+)\<\/date\>/) {
	$entries{'data'}->[$entry]{'date'} = $1;
      } elsif (/\<link\>(.+)\<\/link\>/) {
	$entries{'data'}->[$entry]{'link'} = $1;
      } elsif (/\<title\>(.+)\<\/title\>/) {
	$entries{'data'}->[$entry]{'title'} = $1;
      } elsif (/\<body\>(.+)\<\/body\>/) {
	$entries{'data'}->[$entry]{'body'} = $1;
      }
    }
    # return entries
    return %entries;
  } else {
    # ugg, api call failed completly
    return ('error'=>$response->status_line);
  }
}
######################################################################

######################################################################
# Get badges (gamertag-badges.asp)
######################################################################
sub x3v_get_badges {
  my $gamertag = shift || return ('error'=>'No GamerTag!');
  my $api = 'http://www.360voice.com/api/gamertag-badges.asp';
  
  # set up agent 
  my $ua = LWP::UserAgent->new;
  $ua->timeout(10);
  $ua->env_proxy;

  # get blogs
  my $response = $ua->get("$api?tag=$gamertag");
  if ($response->is_success) {
    # success, get results
    my $voice = decode_entities($response->content);
    if ($voice =~ /\<error\>(.+?)\<\\error\>/m) {
      # oops, api isn't happy
      return ('error'=>$1);
    }
    # parse entries and return them
    my %badges; my %badge = undef;
    for (split(/\n/, $voice)) {
      if (/\<\/badge\>/) {
        push @{$badges{'data'}}, {%badge};
        %badge = undef;
      } elsif (/\<(title)\>(.+)\<\/title\>/) {
	$badge{$1} = $2;
      } elsif (/\<(description)\>(.+)\<\/description\>/) {
	$badge{$1} = $2;
      } elsif (/\<(image)\>(.+)\<\/image\>/) {
	$badge{$1} = $2;
      } elsif (/\<(url)\>(.+)\<\/url\>/) {
	$badge{$1} = $2;
      }
    }
    # return badges
    return %badges;
  } else {
    # ugg, api call failed completly
    return ('error'=>$response->status_line);
  }
}
######################################################################

######################################################################
# Get badges (games-listfav.asp)
######################################################################
sub x3v_get_games {
  my $gamertag = shift || return ('error'=>'No GamerTag!');
  my $entries = shift || 0;
  my $api = 'http://www.360voice.com/api/games-listfav.asp';
  my $link = 'http://www.360voice.com/game.asp?game=';
  
  # set up agent 
  my $ua = LWP::UserAgent->new;
  $ua->timeout(10);
  $ua->env_proxy;

  # get fav games
  my $num = $entries ? "&num=$entries" : '';
  my $response = $ua->get("$api?tag=$gamertag$num");
  if ($response->is_success) {
    # success, get results
    my $voice = decode_entities($response->content);
    if ($voice =~ /\<error\>(.+?)\<\\error\>/m) {
      # oops, api isn't happy
      return ('error'=>$1);
    }
    # parse entries and return them
    my %games; my $name;
    for (split(/\n/, $voice)) {
      if (/\<game\>/) {
        $name = undef;
      } elsif (/\<(name)\>(.+)\<\/name\>/) {
        $name = $2;
	$games{'data'}->{$name}{'link'} = qq~$link$name~;
	push @{$games{'order'}}, $2;
      } elsif (/\<(currentgs)\>(.+)\<\/currentgs\>/) {
	$games{'data'}->{$name}{$1} = $2;
      } elsif (/\<(totalgs)\>(.+)\<\/totalgs\>/) {
	$games{'data'}->{$name}{$1} = $2;
      } elsif (/\<(currentach)\>(.+)\<\/currentach\>/) {
	$games{'data'}->{$name}{$1} = $2;
      } elsif (/\<(totalach)\>(.+)\<\/totalach\>/) {
	$games{'data'}->{$name}{$1} = $2;
      } elsif (/\<(percentcomplete)\>(.+)\<\/percentcomplete\>/) {
	$games{'data'}->{$name}{$1} = $2;
      } elsif (/\<(tile)\>(.+)\<\/tile\>/) {
	$games{'data'}->{$name}{$1} = $2;
      } elsif (/\<(tile64)\>(.+)\<\/tile64\>/) {
	$games{'data'}->{$name}{$1} = $2;
      } elsif (/\<(days)\>(.+)\<\/days\>/) {
	$games{'data'}->{$name}{$1} = $2;
      } elsif (/\<(lastplayed)\>(.+)\<\/lastplayed\>/) {
	$games{'data'}->{$name}{$1} = $2;
      }
    }
    # return games
    return %games;
  } else {
    # ugg, api call failed completly
    return ('error'=>$response->status_line);
  }
}
######################################################################

######################################################################
# Get badges (gamertag-leaderboard.asp)
######################################################################
sub x3v_get_leaderboard {
  my $gamertag = shift || return ('error'=>'No GamerTag!');
  my $api = 'http://www.360voice.com/api/gamertag-leaderboard.asp';
  
  # set up agent 
  my $ua = LWP::UserAgent->new;
  $ua->timeout(10);
  $ua->env_proxy;

  # get leaderboard
  my $response = $ua->get("$api?tag=$gamertag");
  if ($response->is_success) {
    # success, get results
    my $voice = decode_entities($response->content);
    if ($voice =~ /\<error\>(.+?)\<\\error\>/m) {
      # oops, api isn't happy
      return ('error'=>$1);
    }
    # parse entries and return them
    my %lbs; my $lb = 0;
    for (split(/\n/, $voice)) {
      if (/\<leaderboard name=/) {
        $lb++;
      } elsif (/\<(gamertag)\>(.+)\<\/gamertag\>/) {
	$lbs{'data'}->[$lb]{$1} = $2;
      } elsif (/\<(score)\>(.+)\<\/score\>/) {
	$lbs{'data'}->[$lb]{$1} = $2;
      } elsif (/\<(change)\>(.+)\<\/change\>/) {
	$lbs{'data'}->[$lb]{$1} = $2;
      } elsif (/\<(total)\>(.+)\<\/total\>/) {
	$lbs{'data'}->[$lb]{$1} = $2;
      } elsif (/\<(name)\>(.+)\<\/name\>/) {
	$lbs{'data'}->[$lb]{$1} = $2;
      } elsif (/\<(id)\>(.+)\<\/id\>/) {
	$lbs{'data'}->[$lb]{$1} = $2;
      } elsif (/\<(rank)\>(.+)\<\/rank\>/) {
	$lbs{'data'}->[$lb]{$1} = $2;
      } elsif (/\<(prank)\>(.+)\<\/prank\>/) {
	$lbs{'data'}->[$lb]{$1} = $2;
      } elsif (/\<(rankchange)\>(.+)\<\/rankchange\>/) {
	$lbs{'data'}->[$lb]{$1} = $2;
      } elsif (/\<(url)\>(.+)\<\/url\>/) {
	$lbs{'data'}->[$lb]{$1} = $2;
      }
    }
    # return leaderboard
    return %lbs;
  } else {
    # ugg, api call failed completly
    return ('error'=>$response->status_line);
  }
}
######################################################################

######################################################################
# Check gamertag (gamertag-exists.asp)
######################################################################
sub x3v_check_gamertag {
  my $gamertag = shift || return ('error'=>'No GamerTag!');
  my $entries = shift || 5;
  my $api = 'http://www.360voice.com/api/gamertag-exists.asp';

  # set up agent 
  my $ua = LWP::UserAgent->new;
  $ua->timeout(10);
  $ua->env_proxy;

  # get profile
  my $response = $ua->get("$api?tag=$gamertag&num=$entries");
  if ($response->is_success) {
    # success, get results
    my $voice = decode_entities($response->content);
    if ($voice =~ /\<error\>(.+?)\<\\error\>/m) {
      # oops, api isn't happy
      return ('error'=>$1);
    }
    # is this a valid gamertag?
    return ( 'valid'=> ($voice =~ /\<gamertag\>True\<\/gamertag\>/
      ? 1 : 0) );
  } else {
    # ugg, api call failed completly
    return ('error'=>$response->status_line);
  }
}
######################################################################

######################################################################
# Get profile (gamertag-profile.asp)
######################################################################
sub x3v_get_profile {
  my $gamertag = shift || return ('error'=>'No GamerTag!');
  my $entries = shift || 5;
  my $api = 'http://www.360voice.com/api/gamertag-profile.asp';
  
  # set up agent 
  my $ua = LWP::UserAgent->new;
  $ua->timeout(10);
  $ua->env_proxy;

  # get profile
  my $response = $ua->get("$api?tag=$gamertag&num=$entries");
  if ($response->is_success) {
    # success, get results
    my $voice = decode_entities($response->content);
    if ($voice =~ /\<error\>(.+?)\<\\error\>/m) {
      # oops, api isn't happy
      return ('error'=>$1);
    }
    # parse entries and return them
    my %profile;
    for (split(/\n/, $voice)) {
      if (/\<(gamertag)\>(.+)\<\/gamertag\>/) {
	$profile{$1} = $2;
      } elsif (/\<(gender)\>(.+)\<\/gender\>/) {
	$profile{$1} = $2;
      } elsif (/\<(entdate)\>(.+)\<\/entdate\>/) {
	$profile{$1} = $2;
      } elsif (/\<(link)\>(.+)\<\/link\>/) {
	$profile{$1} = $2;
      } elsif (/\<(dayplayed)\>(.+)\<\/dayplayed\>/) {
	$profile{$1} = $2;
      } elsif (/\<(dayignored)\>(.+)\<\/dayignored\>/) {
	$profile{$1} = $2;
      } elsif (/\<(recordaysplayed)\>(.+)\<\/recordaysplayed\>/) {
	$profile{$1} = $2;
      } elsif (/\<(recorddaysignored)\>(.+)\<\/recorddaysignored\>/) {
	$profile{$1} = $2;
      } elsif (/\<(tile)\>(.+)\<\/tile\>/) {
	$profile{$1} = $2;
      } elsif (/\<(zone)\>(.+)\<\/zone\>/) {
	$profile{$1} = $2;
      } elsif (/\<(country)\>(.+)\<\/country\>/) {
	$profile{$1} = $2;
      } elsif (/\<(played)\>(.+)\<\/played\>/) {
	$profile{$1} = $2;
      }
    }
    # return entries
    return %profile;
  } else {
    # ugg, api call failed completly
    return ('error'=>$response->status_line);
  }
}
######################################################################

# PRIVATE

1; # end of package
