#!/usr/bin/perl -w

########################################################################
#
# program: admin.cgi
# system : 360voice Mod for WebAPP NE (Network Edition)
# author : Copyright (C) 2007 Steven L. Reid
# purpose: Administer mod configuration information.
# history:
# 3/25/2007, Steven Reid
#	- script created
#
########################################################################

# setup environment
$|++;
#use strict; # turned off due to WebAPP not supporting it

# Read configuration file
BEGIN {
  use CGI::Carp qw(fatalsToBrowser);
  # include WebAPP configuration
  require "../../../config.pl";
  require "$lang";
  require "$sourcedir/subs.pl";
  # include configurations
  require "../data/paths.cfg";
  require "../data/mod.cfg";
}

# load libraries
use File::Basename;

# define globals
my $v3_save = 0; # save config?

########################################################################
# begin main

v3a_display_header();
v3a_load_admin_parms();
v3a_save_settings() if $v3_save;
v3a_display_prompt();
v3a_display_footer();

# end main
########################################################################

########################################################################
# BlogCal Display Header - load WebAPP stuff and print header
########################################################################
sub v3a_display_header() {

  # WebAPP specific stuff
  eval {
    if ($IIS != 2) {
      if ($IIS == 0) {
        if ($ENV{'SERVER_SOFTWARE'} =~ m!IIS!) { $IIS = 1; }
      }
      if (($IIS) && ($0 =~ m!(.*)(\\|\/)!)) { chdir($1); }
	if ($IIS == 1) { print "HTTP/1.0 200 OK\n"; }
      }
  };

  if ($@) {
    print <<END_HTML;
Content-type: text/html\n\n
<html><head><title>Software Error</title></head>
<body><h1>Software Error:</h1>
Execution of <b>$scriptname</b> has been aborted due a compilation error:<br />
<pre>$@</pre>
<p>If this problem persists, please contact the webmaster and inform him about date and time you've received this error.</p>
</body></html>
END_HTML
    exit;
  }

  # include default sub stuff
  getcgi();
  getdate();
  loadcookie();
  loaduser();
  logips();
  ban();
  logvisitors();
  getver();

  # assume that if access to modadmin, grant access to blogcal's admin
  check_access('modadmin');
  error($err{'011'}) unless $access_granted == 1;

  # include language file (if exists)
  if ( -e "$v3_langDir/$userlang") {
    require "$v3_langDir/$userlang";
  } else {
    require "$v3_langDir/$v3_defaultLang";
  }

  # print top
  $navbar = "&nbsp;$btn{'014'}&nbsp;$v3_title $msg{'430'}";
  print_top();
}
########################################################################

########################################################################
# BlogCal Display Footer - print footer after doing work
########################################################################
sub v3a_display_footer {
  print_bottom();
}
########################################################################

########################################################################
# Load params - get the form variables if need be
########################################################################
sub v3a_load_admin_parms {
  # load parameters
  $v3_title		= isdef($input{'v3a_title'},
  				$v3_title, '360voice');
  $v3_defaultLang	= isdef($input{'v3a_defaultLang'},
  				$v3_defaultLang, 'english.lng');
  $v3_view_type		= isnum($input{'v3a_view_type'},
				$v3_view_type, 0);

  $v3_save = $input{'v3a_save'} ? 1 : 0;
}
########################################################################

########################################################################
# Show Settings -- show current configuration
########################################################################
sub v3a_display_prompt() {

  # get language list
  my @v3_langs;
  for my $v3_lang (sort <$v3_langDir/*.lng>) {
    push @v3_langs, basename($v3_lang);
  }

  print <<END_HTML;
<form action="$v3_scriptURL/admin/admin.cgi" method="post">
<h2>$v3_msg{'100'}</h2>
  <table summary="$v3_msg{'100'}" width="100%"
    cellpadding="0" cellspacing="0">
    <tr><td>$v3_msg{'101'}</td><td><input type="text"
      name="v3a_title" value="$v3_title" size="32" /></td></tr>
    <tr><td>$v3_msg{'102'}</td><td><select size="1"
      name="v3a_defaultLang">
END_HTML
  for my $v3_lang (@v3_langs) {
    my $selected = q~ selected="selected"~
      if $v3_lang eq $v3_defaultLang;
  print <<END_HTML;
      <option value='$v3_lang'$selected>$v3_lang</option>
END_HTML
    }
  print <<END_HTML;
      </select></td></tr>
    <tr><td>$v3_msg{'103'}</td><td><select size="1"
      name="v3a_view_type">
END_HTML
    if ($v3_view_type == 1) {
  print <<END_HTML;
      <option value='0'>$v3_msg{'104'}</option>
      <option value='1' selected="selected">$v3_msg{'105'}</option>
END_HTML
    } else {
  print <<END_HTML;
      <option value='0' selected="selected">$v3_msg{'104'}</option>
      <option value='1'>$v3_msg{'105'}</option>
END_HTML
    }
  print <<END_HTML;
      </select></td></tr>
    <tr><td colspan="2" align="center">
      <input type="hidden" name="v3a_save" value="v3_save" />
      <input type="submit" value="$v3_msg{'005'}" />
      <input type="reset" value="$v3_msg{'006'}" /></td></tr>
</table></form>
END_HTML
}
########################################################################

########################################################################
# Slideshow Save Settings - save any changes in settings
########################################################################
sub v3a_save_settings {
  
  # open configuration file
  open CONFIG, ">$v3_dataDir/mod.cfg"
    or error("$err{'016'} $v3_dataDir/mod.cfg");
  hold(CONFIG);

  print CONFIG <<END_CONFIG;
########################################################################
#
# file   : mod.cfg
# system : 360voice Mod for WebAPP NE (Network Edition)
# author : Copyright (C) 2007 Steven L. Reid
# purpose: Define global configuration options.
#
########################################################################

########################################################################
# General Settings
########################################################################
\$v3_title		= q~$v3_title~;
\$v3_defaultLang		= q~$v3_defaultLang~;
\$v3_view_type		= $v3_view_type;
########################################################################

1; #return true
END_CONFIG

	release(CONFIG); close(CONFIG);
	
	print "<h3>$v3_msg{'007'}</h3>";
}
########################################################################

########################################################################
# common functions
########################################################################
sub trim { # trim leading and trailing whitespace
  local $_ = shift || ''; /^\s*(.*?)\s*$/; return $1 }
########################################################################
sub isnum { # check if a number, otherwise load defaults
  my $retval; my $lastval;
  for my $val (@_) {
    $lastval = $val;
    next unless defined $val;
    next unless $val =~ /^\s*(\d+)\s*$/;
    return $1;
  }
  return $lastval;
}
########################################################################
sub isdef { # check if defined, otherwise load defaults
  my $retval; my $lastval;
  for my $val (@_) {
    $lastval = $val;
    next unless defined $val;
    next unless trim($val);
    return trim($val);
  }
  return $lastval;
}
########################################################################

1;