#!/usr/bin/perl -w

########################################################################
#
# program: index.cgi
# system : 360voice Mod for WebAPP NE (Network Edition)
# author : Copyright (C) 2007 Steven L. Reid
# purpose: Display Xbox 360 information using the 360voice API.
# history:
# 3/25/2007, Steven Reid
#	- script created
#
########################################################################

# setup environment
$|++;
#use strict; # turned off due to WebAPP not supporting it

# Read configuration file
BEGIN {
  use CGI::Carp qw(fatalsToBrowser);
  # include WebAPP configuration
  require "../../config.pl";
  require "$lang";
  require "$sourcedir/subs.pl";
  # include configurations
  require "data/paths.cfg";
  require "data/mod.cfg";
}

# load libraries

# define variables
my $gamertag = 'SafePit';
my $gamertag2 = 'ChangeAgent';

########################################################################
# begin main

v3i_display_header();
v3i_run_ops();
v3i_display_footer();

# end main
########################################################################

########################################################################
# Slideshow Display Header - load WebAPP stuff and print header
########################################################################
sub v3i_display_header() {

  # WebAPP specific stuff
  eval {
    if ($IIS != 2) {
      if ($IIS == 0) {
        if ($ENV{'SERVER_SOFTWARE'} =~ m!IIS!) { $IIS = 1; }
      }
      if (($IIS) && ($0 =~ m!(.*)(\\|\/)!)) { chdir($1); }
	if ($IIS == 1) { print "HTTP/1.0 200 OK\n"; }
      }
  };

  if ($@) {
    print <<END_HTML;
Content-type: text/html\n\n
<html><head><title>Software Error</title></head>
<body><h1>Software Error:</h1>
Execution of <b>$scriptname</b> has been aborted due a compilation error:<br />
<pre>$@</pre>
<p>If this problem persists, please contact the webmaster and inform him about the date and time you've received this error.</p>
</body></html>
END_HTML
    exit;
  }

  # include default sub stuff
  getcgi();
  getdate();
  loadcookie();
  loaduser();
  logips();
  ban();
  logvisitors();
  getver();

  # include language file (if exists)
  if ( -e "$v3_langDir/$userlang") {
    require "$v3_langDir/$userlang";
  } else {
    require "$v3_langDir/$bc_defaultLang";
  }
}
########################################################################

########################################################################
# Slideshow Display Footer - print footer after doing work
########################################################################
sub v3i_display_footer {
  print_bottom();
}
########################################################################

########################################################################
# operations routine
########################################################################
sub v3i_run_ops {

  $gamertag = $input{'gamertag1'} || $input{'gamertag'}
            || $info{'gamertag1'} || $info{'gamertag'}
	    || $gamertag;
  $gamertag1 = $gamertag;
  $gamertag2 = $input{'gamertag2'} || $info{'gamertag2'}
            || $gamertag2;

  if ($op eq 'admin')		{ v3i_admin() }
  elsif ($op eq 'games')	{ v3i_display_games() }
  elsif ($op eq 'leaderboard')	{ v3i_display_leaderboard() }
  elsif ($op eq 'compare')	{ v3i_display_compare() }
  elsif ($op eq 'watched')	{ v3i_display_watched() }
  else				{ v3i_display_360voice() }

  # display options
  print qq~
<div style="border-top: 1px solid black;">
  [&nbsp;<a href="$v3_scriptURL/index.cgi?gamertag=$gamertag">$v3_msg{'050'}</a>&nbsp;]
  [&nbsp;<a href="$v3_scriptURL/index.cgi?op=games&amp;gamertag=$gamertag">$v3_msg{'051'}</a>&nbsp;]
  [&nbsp;<a href="$v3_scriptURL/index.cgi?op=leaderboard&amp;gamertag=$gamertag">$v3_msg{'052'}</a>&nbsp;]
  [&nbsp;<a href="$v3_scriptURL/index.cgi?op=compare&amp;gamertag=$gamertag&amp;gamertag2=$gamertag2">$v3_msg{'053'}</a>&nbsp;]
~;
  if ($username ne $anonuser) {
    print qq~
  [&nbsp;<a href="$v3_scriptURL/index.cgi?op=watched">$v3_msg{'083'}</a>&nbsp;]
  [&nbsp;<a href="$v3_scriptURL/index.cgi?op=admin">$v3_msg{'010'}</a>&nbsp;]
~;
  }
  print qq~
</div>
~;
}
########################################################################

########################################################################
# Display 360voice
########################################################################
sub v3i_display_360voice {
  # print top
  $navbar = qq~$btn{'014'}
    <a href="$v3_scriptURL/index.cgi">$v3_title</a>
    $btn{'014'} $v3_msg{'054'}~;
  print_top();

  # get blog
  use x360voice;
  my $xbox360voice;
  
  # get profile
  my %profile = x3v_get_profile($gamertag);
  if (exists $profile{'error'}) {
    $xbox360voice = $profile{'error'} || $v3_msg{'001'};
    print "<div>$xbox360voice</div>";
    return;
  }
  # get badges
  my %badges = x3v_get_badges($gamertag);
  if (exists $badges{'error'}) {
    $xbox360voice = $badges{'error'} || $v3_msg{'001'};
    print "<div>$xbox360voice</div>";
    return;
  }
  # get entries
  my %entries = x3v_get_entries($gamertag);
  if (exists $entries{'error'}) {
    $xbox360voice = $entries{'error'} || $v3_msg{'001'};
    print "<div>$xbox360voice</div>";
    return;
  }
  
  # build page
  my $entry = shift @{$entries{'data'}};
  my $title = $v3_msg{'055'} . $entry->{'gamertag'};
  my $link = $entry->{'link'};
  my $img = $profile{'tile'};
  $xbox360voice .= qq~
<table><tr valign="top">
  <td><a href="$link" target="_new"><img src="$img"
    alt="$title" title="$title"
    style="float: left; margin-right: 5px; border: 1px solid black"
    /></a></td><td width="100%">
  <b><a href="$link" target="_new">$title</a></b><br />
<span class="textsmall">
<a href="$v3_scriptURL/index.cgi?op=blog&gamertag=$gamertag"
>$v3_msg{'054'}</a>
&nbsp;|&nbsp;
<a href="$v3_scriptURL/index.cgi?op=games&gamertag=$gamertag"
>$v3_msg{'057'}</a>
&nbsp;|&nbsp;
<a href="$v3_scriptURL/index.cgi?op=leaderboard&gamertag=$gamertag"
>$v3_msg{'063'}</a>
&nbsp;|&nbsp;
<a href="$v3_scriptURL/index.cgi?op=compare&amp;gamertag=$gamertag1&amp;gamertag2=$gamertag">$v3_msg{'068'}</a>
&nbsp;|&nbsp;
<a href="$v3_xboxlive/$gamertag" target="_new">$v3_msg{'086'}</a>
</span><br />
~;
  for (@{$badges{'data'}}) {
    my $title = $_->{'title'};
    my $image = $_->{'image'};
    my $url = $_->{'url'};
    $xbox360voice .= qq~
<a href="$url" target="_new"><img
src="$image" alt="$title" title="$title" /></a>
~;
  }
  $xbox360voice .= qq~
<div style="float: right">
  <form action="$v3_scriptURL/index.cgi" method="post">
    $v3_msg{'003'} <input type="text" size="20" name="gamertag"
    value="$gamertag" />
    <input type="submit" value="$v3_msg{'002'}" />
  </form>
</div>
  </td></tr>
</table>
<div style="clear: both; border-top: 1px solid black;">
~;
  for (@{$entries{'data'}}) {
    my $title = $_->{'title'};
    my $link = $_->{'link'};
    my $body = $_->{'body'};
    $xbox360voice .= qq~
<p><b><a href="$link" target="_new">$title</a></b><br />$body</p>
 ~;
  }
  $xbox360voice .= qq~</div>~;

  # display badge
  print "<div>$xbox360voice</div>";
}
########################################################################

########################################################################
# Display Games
########################################################################
sub v3i_display_games {
  # print top
  $navbar = qq~$btn{'014'}
    <a href="$v3_scriptURL/index.cgi">$v3_title</a>
    $btn{'014'} $v3_msg{'057'}~;
  print_top();

  # get blog
  use x360voice;
  my $xbox360voice;

  # get profile
  my %profile = x3v_get_profile($gamertag);
  if (exists $profile{'error'}) {
    $xbox360voice = $profile{'error'} || $v3_msg{'001'};
    print "<div>$xbox360voice</div>";
    return;
  }
  # get games
  my %games = x3v_get_games($gamertag, 10);
  if (exists $games{'error'}) {
    $xbox360voice = $games{'error'} || $v3_msg{'001'};
    print "<div>$xbox360voice</div>";
    return;
  }
  
  # first, get user data
  my $title = $v3_msg{'058'} . $profile{'gamertag'};
  my $link = $profile{'link'};
  my $img = $profile{'tile'}; 
  $xbox360voice .= qq~
<table><tr valign="top">
  <td><a href="$link" target="_new"><img src="$img"
    alt="$title" title="$title"
    style="float: left; margin-right: 5px; border: 1px solid black"
    /></a></td><td width="100%">
  <b><a href="$link" target="_new">$title</a></b><br />
<span class="textsmall">
<a href="$v3_scriptURL/index.cgi?op=blog&gamertag=$gamertag"
>$v3_msg{'054'}</a>
&nbsp;|&nbsp;
<a href="$v3_scriptURL/index.cgi?op=games&gamertag=$gamertag"
>$v3_msg{'057'}</a>
&nbsp;|&nbsp;
<a href="$v3_scriptURL/index.cgi?op=leaderboard&gamertag=$gamertag"
>$v3_msg{'063'}</a>
&nbsp;|&nbsp;
<a href="$v3_scriptURL/index.cgi?op=compare&amp;gamertag=$gamertag1&amp;gamertag2=$gamertag">$v3_msg{'068'}</a>
&nbsp;|&nbsp;
<a href="$v3_xboxlive/$gamertag" target="_new">$v3_msg{'086'}</a>
</span><br />
<div style="float: right">
  <form action="$v3_scriptURL/index.cgi" method="post">
    $v3_msg{'003'} <input type="text" size="20" name="gamertag"
    value="$gamertag" />
    <input type="submit" value="$v3_msg{'002'}" />
  </form>
</div>
  </td></tr>
</table>
<div style="clear: both; border-top: 1px solid black;">
<table>
~;
  # now get game list
  $x=0;
  for my $name (@{$games{'order'}}) {
    $x++;
    $_ = $games{'data'}->{$name};
    my $currentgs = $_->{'currentgs'};
    my $totalgs = $_->{'totalgs'};
    my $currentach = $_->{'currentach'};
    my $totalach = $_->{'totalach'};
    my $percentcomplete = $_->{'percentcomplete'};
    my $tile = $_->{'tile'};
    my $tile64 = $_->{'tile64'};
    my $days = $_->{'days'};
    my $lastplayed = $_->{'lastplayed'};
    my $link = $_->{'link'};
    my $class = (qw(forumwindow2, forumwindow3))[$x%2];
    $xbox360voice .= qq~
<tr valign="top" class="$class">
  <td><a href="$link" target="_new"><img src="$tile64" alt="$name"
    title="$name" /></a></td>
  <td style=" width: 100%;">
    <table width="100%">
      <tr><td style="border-bottom: 1px solid black;">
        <b>$name</b>
      </td></tr>
      <tr><td>
        $currentgs/$totalgs $v3_msg{'059'},
        $currentach/$totalach $v3_msg{'060'}<br />
        $v3_msg{'061'} $days, $v3_msg{'062'} $lastplayed
      </td></tr>
    </table>
  </td>
</tr>
~;
  }
  $xbox360voice .= qq~</table></div>~;

  # display fav games
  print "<div>$xbox360voice</div>";
}
########################################################################

########################################################################
# Display Leaderboard
########################################################################
sub v3i_display_leaderboard {
  # print top
  $navbar = qq~$btn{'014'}
    <a href="$v3_scriptURL/index.cgi">$v3_title</a>
    $btn{'014'} $v3_msg{'063'}~;
  print_top();

  # get blog
  use x360voice;
  my $xbox360voice;

  # get profile
  my %profile = x3v_get_profile($gamertag);
  if (exists $profile{'error'}) {
    $xbox360voice = $profile{'error'} || $v3_msg{'001'};
    print "<div>$xbox360voice</div>";
    return;
  }
  # get leaderboard
  my %lbs = x3v_get_leaderboard($gamertag);
  if (exists $lbs{'error'}) {
    $xbox360voice = $lbs{'error'} || $v3_msg{'001'};
    print "<div>$xbox360voice</div>";
    return;
  }
  
  # first, get user data
  my $title = $v3_msg{'064'} . $profile{'gamertag'};
  my $link = $profile{'link'};
  my $img = $profile{'tile'}; 
  my $gamer = shift @{$lbs{'data'}};
  my $score = $gamer->{'score'};
  my $change = $gamer->{'change'};
  my $total = $gamer->{'total'};
  $xbox360voice .= qq~
<table><tr valign="top">
  <td><a href="$link" target="_new"><img src="$img"
    alt="$title" title="$title"
    style="float: left; margin-right: 5px; border: 1px solid black"
    /></a></td><td width="100%">
  <b><a href="$link" target="_new">$title</a></b><br />
<span class="textsmall">
<a href="$v3_scriptURL/index.cgi?op=blog&gamertag=$gamertag"
>$v3_msg{'054'}</a>
&nbsp;|&nbsp;
<a href="$v3_scriptURL/index.cgi?op=games&gamertag=$gamertag"
>$v3_msg{'057'}</a>
&nbsp;|&nbsp;
<a href="$v3_scriptURL/index.cgi?op=leaderboard&gamertag=$gamertag"
>$v3_msg{'063'}</a>
&nbsp;|&nbsp;
<a href="$v3_scriptURL/index.cgi?op=compare&amp;gamertag=$gamertag1&amp;gamertag2=$gamertag">$v3_msg{'068'}</a>
&nbsp;|&nbsp;
<a href="$v3_xboxlive/$gamertag" target="_new">$v3_msg{'086'}</a>
</span><br />
    $v3_msg{'065'} $score ($v3_msg{'066'} $change)<br />
    $v3_msg{'067'} $total<br />
<div style="float: right">
  <form action="$v3_scriptURL/index.cgi" method="post">
    $v3_msg{'003'} <input type="text" size="20" name="gamertag"
    value="$gamertag" />
    <input type="submit" value="$v3_msg{'002'}" />
  </form>
</div>
  </td></tr>
</table>
<div style="clear: both; border-top: 1px solid black;">
~;
  for (@{$lbs{'data'}}) {
    my $name = $_->{'name'};
    my $id = $_->{'id'};
    my $rank = $_->{'rank'};
    my $prank = $_->{'prank'};
    my $rankchange = $_->{'rankchange'};
    my $url = $_->{'url'};
    $xbox360voice .= qq~<div>
<p><a href="$url" target="_new"><b>$name</b></a></p>
<p>$v3_msg{'069'} $rank, $v3_msg{'070'} $prank $v3_msg{'071'} $rankchange $v3_msg{'072'}</p>
</div>
~;
  }
  $xbox360voice .= qq~</div>~;

  # display leaderboards
  print "<div>$xbox360voice</div>";
}
########################################################################

########################################################################
# Display Compare Games
########################################################################
sub v3i_display_compare {
  # print top
  $navbar = qq~$btn{'014'}
    <a href="$v3_scriptURL/index.cgi">$v3_title</a>
    $btn{'014'} $v3_msg{'068'}~;
  print_top();

  # get comparison
  use x360voice;

  # first, get gamertag1 info
  my %p1 = x3v_get_profile($gamertag1);
  if (exists $p1{'error'}) {
    $xbox360voice = $p1{'error'} || $v3_msg{'001'};
    print "<div>$xbox360voice</div>";
    return;
  }
  my %lb1 = x3v_get_leaderboard($gamertag1);
  if (exists $lb1{'error'}) {
    $xbox360voice = $lb1{'error'} || $v3_msg{'001'};
    print "<div>$xbox360voice</div>";
    return;
  }
  my %g1 = x3v_get_games($gamertag1);
  if (exists $g1{'error'}) {
    $xbox360voice = $g1{'error'} || $v3_msg{'001'};
    print "<div>$xbox360voice</div>";
    return;
  }
  # then, get gamertag2 info
  my %p2 = x3v_get_profile($gamertag2);
  if (exists $p2{'error'}) {
    $xbox360voice = $p2{'error'} || $v3_msg{'001'};
    print "<div>$xbox360voice</div>";
    return;
  }
  my %lb2 = x3v_get_leaderboard($gamertag2);
  if (exists $lb2{'error'}) {
    $xbox360voice = $lb2{'error'} || $v3_msg{'001'};
    print "<div>$xbox360voice</div>";
    return;
  }
  my %g2 = x3v_get_games($gamertag2);
  if (exists $g2{'error'}) {
    $xbox360voice = $g2{'error'} || $v3_msg{'001'};
    print "<div>$xbox360voice</div>";
    return;
  }
  
  # okay, compare games
  $xbox360voice = qq~
<form action="$v3_scriptURL/index.cgi?op=compare" method="post">
<table style="width: 100%;">
<tr valign="top">
  <td> </td>
  <td>
    <table><tr valign="top"><td>
    <a href="$p1{'link'}" target="_new"><img src="$p1{'tile'}"
    alt="$gamertag1" title="$gamertag1" style="border: 1px solid black"
    /></a></td><td>
    <b><a href="$p1{'link'}" target="_new">$p1{'gamertag'}</b></a><br />
    $v3_msg{'065'} ${$lb1{'data'}}[0]{'score'}<br />
    <span class="textsmall">
    <a href="$v3_scriptURL/index.cgi?op=blog&gamertag=$gamertag"
    >$v3_msg{'054'}</a>
    <a href="$v3_scriptURL/index.cgi?op=leaderboard&gamertag=$gamertag"
    >$v3_msg{'063'}</a>
    <a href="$v3_xboxlive/$gamertag" target="_new">$v3_msg{'012'}</a>
    </span></td></tr>
    <tr><td colspan="2">
    <input type="text" size="20" name="gamertag1"
    value="$p1{'gamertag'}" />
    <input type="submit" value="$v3_msg{'002'}" /></td></tr></table>
  </td><td>
    <table><tr valign="top"><td>
    <a href="$p2{'link'}" target="_new"><img src="$p2{'tile'}"
    alt="$gamertag2" title="$gamertag2" style="border: 1px solid black"
    /></a></td><td>
    <b><a href="$p2{'link'}" target="_new">$p2{'gamertag'}</b></a><br />
    $v3_msg{'065'} ${$lb2{'data'}}[0]{'score'}<br />
    <span class="textsmall">
    <a href="$v3_scriptURL/index.cgi?op=blog&gamertag=$gamertag2"
    >$v3_msg{'054'}</a>
    <a href="$v3_scriptURL/index.cgi?op=leaderboard&gamertag=$gamertag2"
    >$v3_msg{'063'}</a>
    <a href="$v3_xboxlive/$gamertag2" target="_new">$v3_msg{'012'}</a>
    </span></td></tr>
    <tr><td colspan="2">
    <input type="text" size="20" name="gamertag2"
    value="$p2{'gamertag'}" />
    <input type="submit" value="$v3_msg{'002'}" /></td></tr></table>
  </td>
</tr>
<tr valign="top">
  <td> </td>
</tr>
~;

  $x=0;
  for my $name (@{$g1{'order'}}) {
    $x++;
    $_ = $g1{'data'}->{$name};
    my $currentgs = $_->{'currentgs'};
    my $totalgs = $_->{'totalgs'};
    my $currentach = $_->{'currentach'};
    my $totalach = $_->{'totalach'};
    my $percentcomplete = $_->{'percentcomplete'};
    my $tile = $_->{'tile'};
    my $tile64 = $_->{'tile64'};
    my $link = $_->{'link'};
    my $days = $_->{'days'};
    my $lastplayed = $_->{'lastplayed'};
    my $class = (qw(forumwindow2, forumwindow3))[$x%2];
    my $g2currentgs = 0;
    my $g2currentach = 0;
    my $g2percentcomplete = 0;
    my $g2days = 0;
    my $g2lastplayed = $v3_msg{'073'};
    if (exists $g2{'data'}->{$name}) {
      $_ = $g2{'data'}->{$name};
      $g2currentgs = $_->{'currentgs'};
      $g2currentach = $_->{'currentach'};
      $g2percentcomplete = $_->{'percentcomplete'};
      $g2days = $_->{'days'};
      $g2lastplayed = $_->{'lastplayed'};
      delete $g2{'data'}->{$name};
    }
    $xbox360voice .= qq~
<tr valign="top" class="$class">
  <td><a href="$link" target="_new"><img src="$tile64" alt="$name"
    title="$name" style="border: 1px solid black;" /></a></td>
  <td style=" width: 50%;">
    <table width="100%">
      <tr><td style="border-bottom: 1px solid black;">
        <b>$name</b>
      <td></tr>
      <tr><td>
        $currentgs/$totalgs $v3_msg{'059'},
        $currentach/$totalach $v3_msg{'060'}<br />
        $v3_msg{'061'}: $days, $v3_msg{'062'} $lastplayed
      </td></tr>
    </table>
  </td>
  <td style=" width: 50%;">
    <table width="100%">
      <tr><td style="border-bottom: 1px solid black;">
        <b>$name</b>
      <td></tr>
      <tr><td>
        $g2currentgs/$totalgs $v3_msg{'059'},
        $g2currentach/$totalach $v3_msg{'060'}<br />
        $v3_msg{'061'}: $g2days, $v3_msg{'062'} $g2lastplayed
      </td></tr>
    </table>
  </td>
</tr>
~;
  }
  for my $name (@{$g2{'order'}}) {
    next unless exists $g2{'data'}->{$name};
      $x++;
      $_ = $g2{'data'}->{$name};
      my $g2currentgs = $_->{'currentgs'};
      my $totalgs = $_->{'totalgs'};
      my $g2currentach = $_->{'currentach'};
      my $totalach = $_->{'totalach'};
      my $g2percentcomplete = $_->{'percentcomplete'};
      my $tile = $_->{'tile'};
      my $tile64 = $_->{'tile64'};
      my $link = $_->{'link'};
      my $g2days = $_->{'days'};
      my $g2lastplayed = $_->{'lastplayed'};
      my $class = (qw(forumwindow2, forumwindow3))[$x%2];
      my $currentgs = 0;
      my $currentach = 0;
      my $percentcomplete = 0;
      my $days = 0;
      my $lastplayed = $v3_msg{'004'};
      $xbox360voice .= qq~
<tr valign="top" class="$class">
  <td><a href="$link" target="_new"><img src="$tile64" alt="$name"
    title="$name" style="border: 1px solid black;" /></a></td>
  <td style=" width: 50%;">
    <table width="100%">
      <tr><td style="border-bottom: 1px solid black;">
        <b>$name</b>
      </td></tr>
      <tr><td>
        $currentgs/$totalgs $v3_msg{'059'},
        $currentach/$totalach $v3_msg{'060'}<br />
        $v3_msg{'061'}: $days, $v3_msg{'062'} $lastplayed
      </td></tr>
    </table>
  </td>
  <td style=" width: 50%;">
    <table width="100%">
      <tr><td style="border-bottom: 1px solid black;">
        <b>$name</b>
      </td></tr>
      <tr><td>
        $g2currentgs/$totalgs $v3_msg{'059'},
        $g2currentach/$totalach $v3_msg{'060'}<br />
        $v3_msg{'061'}: $g2days, $v3_msg{'062'} $g2lastplayed
      </td></tr>
    </table>
  </td>
</tr>
~;
  }
  $xbox360voice .= "</table></form>";

  # display fav games
  print "<div>$xbox360voice</div>";
}
########################################################################

########################################################################
# Display Watched Blogs
########################################################################
sub v3i_display_watched {
  # print top
  $navbar = qq~$btn{'014'}
    <a href="$v3_scriptURL/index.cgi">$v3_title</a>
    $btn{'014'} $v3_msg{'084'}~;
  print_top();

  # get blog
  use x360voice;
  
  # grab member's watch tags
  my @wgtags = v3i_get_watched();
  
  unless (@wgtags) {
    print qq~$v3_msg{'085'}~;
    return;
  }

  my $x = 0;
  for my $gamertag (@wgtags) {
    my $xbox360voice; $x++;
    my $class = (qw(forumwindow2, forumwindow3))[$x%2];
 
    # get profile
    my %profile = x3v_get_profile($gamertag);
    if (exists $profile{'error'}) {
      $xbox360voice = $profile{'error'} || $v3_msg{'001'};
      print "<div>$xbox360voice</div>";
      return;
    }
    # get badges
    my %badges = x3v_get_badges($gamertag);
    if (exists $badges{'error'}) {
      $xbox360voice = $badges{'error'} || $v3_msg{'001'};
      print "<div>$xbox360voice</div>";
      return;
    }
    # get entries
    my %entries = x3v_get_entries($gamertag, 1);
    if (exists $entries{'error'}) {
      $xbox360voice = $entries{'error'} || $v3_msg{'001'};
      print "<div>$xbox360voice</div>";
      return;
    }
  
    # build page
    my $entry = shift @{$entries{'data'}};
    my $title = $v3_msg{'056'} . $entry->{'gamertag'};
    my $img = $profile{'tile'}; 
    $xbox360voice .= qq~
<table><tr valign="top"><td rowspan="2">
<a href="$v3_scriptURL/index.cgi?gamertag=$gamertag"><img src="$img"
  alt="$title" title="$title"
  style="border: 1px solid black" /></a>
</td><td>
~;
    for (@{$entries{'data'}}) {
      my $title = $_->{'title'};
      my $link = $_->{'link'};
      my $body = $_->{'body'};
      $xbox360voice .= qq~
<b><a href="$link" target="_new">$title</a></b><br />
<span class="textsmall">
<a href="$v3_scriptURL/index.cgi?op=blog&gamertag=$gamertag"
>$v3_msg{'054'}</a>
&nbsp;|&nbsp;
<a href="$v3_scriptURL/index.cgi?op=compare&amp;gamertag=$gamertag1&amp;gamertag2=$gamertag">$v3_msg{'068'}</a>
&nbsp;|&nbsp;
<a href="$v3_scriptURL/index.cgi?op=games&gamertag=$gamertag"
>$v3_msg{'057'}</a>
&nbsp;|&nbsp;
<a href="$v3_xboxlive/$gamertag" target="_new">$v3_msg{'086'}</a>
</span>
<br />
$body~;
    }
    $xbox360voice .= qq~
</td></tr><tr><td style="border-top: 1px solid black;">
~;
    for (@{$badges{'data'}}) {
      my $title = $_->{'title'};
      my $image = $_->{'image'};
      my $url = $_->{'url'};
      $xbox360voice .= qq~
<a href="$url" target="_new"><img
src="$image" alt="$title" title="$title" /></a>
~;
    }
    $xbox360voice .= qq~
</td></table>
~;

    # display badge
    print qq~<div class="$class">$xbox360voice</div>~;
  }
}
########################################################################

########################################################################
# Admin - Allow users to change preferences or add watch gamertag
########################################################################
sub v3i_admin {
  # print top
  $navbar = qq~$btn{'014'}
    <a href="$v3_scriptURL/index.cgi">$v3_title</a>
    $btn{'014'} $v3_msg{'075'}~;
  print_top();
  
  if ($username eq $anonuser) { error("$err{'011'}"); }
  
  # save any changes?
  v3i_save() if $input{'v3i_save'};

  # grab members gamertags
  my @mgtags = (); my $mgtag; my $mpref;
  open(FILE, "$v3_dataDir/users.dat")
    || error("$err{'001'} $v3_dataDir/users.dat");
  hold(FILE);
  while ($_ = <FILE>) {
    chomp;
    my ($member, $gamertag, $pref) = split /\|/, $_, 3;
    next unless $member && $gamertag;
    $mgtag = $gamertag if $member eq $username;
    $mpref = ($pref || 0) if $member eq $username;
    push @mgtags, $gamertag;
  }
  release(FILE);
  close(FILE);
  
  # grab member's watch tags
  my @wgtags = v3i_get_watched();

  print <<END_HTML;
<form action="$v3_scriptURL/index.cgi?op=admin" method="post">
<h2>$v3_msg{'076'}</h2>
  <table summary="$v3_msg{'077'}" width="100%"
    cellpadding="0" cellspacing="0">
    <tr><td>$v3_msg{'077'}</td><td><input type="text"
      name="v3i_gamertag" value="$mgtag" size="30" /></td></tr>
    <tr><td>&nbsp;</td><td><select size="1"
      name="v3i_preference">
END_HTML
  my $pcnt = 0;
  for my $pref (@{$v3_msg{'082'}}) {
    my $selected = ($mpref == $pcnt) ? qq~ selected="selected"~ : '';
    print <<END_HTML;
      <option value='$pcnt'$selected>$pref</option>
END_HTML
    $pcnt++;
  }
  print <<END_HTML;
      </select></td></tr>
    <tr><td>$v3_msg{'078'}</td><td><select size="1"
      name="v3i_wgtags">
END_HTML
  for my $wgtag (@wgtags) {
    print <<END_HTML;
      <option value='$wgtag'>$wgtag</option>
END_HTML
  }
  print <<END_HTML;
      </select>
      <input type="submit" name="3vi_del" value="$v3_msg{'080'}" />
      </td></tr>
    <tr><td>&nbsp;</td><td><input type="text"
      name="v3i_add_wgtag" value="" size="30" />
      <input type="submit" name="3vi_add" value="$v3_msg{'079'}" />
      </td></tr>
    <tr><td colspan="2" align="center">
      <input type="hidden" name="v3i_save" value="v3_save" />
      <input type="submit" value="$v3_msg{'005'}" />
      <input type="reset" value="$v3_msg{'006'}" /></td></tr>
</table></form>
END_HTML
  
}
########################################################################

########################################################################
# Save - Save any changed preferences
########################################################################
sub v3i_save {
  # what are we doing?
  if ($input{'3vi_add'}) {	# adding a new watched gamertag
    my $newtag = trim($input{'v3i_add_wgtag'} || '');
    # validate tag
    my %checktag = x3v_check_gamertag($newtag);
    if (exists $checktag{'error'}) {
      print ($checktag{'error'} || $v3_msg{'001'});
      return;
    }
    if ($checktag{'valid'}) {
      # save new watched tag
      open(FILE, ">>$v3_dataDir/$username.dat")
        || error("$err{'001'} $v3_dataDir/$username.dat");
      hold(FILE);
      print FILE qq~$newtag\n~;
      release(FILE);
      close(FILE);      
    } else {
      print qq~<p>$newtag $v3_msg{'081'}</p>~;
      return;
    }
  } elsif ($input{'3vi_del'}) {	# deleting a watched gamertag
    my $oldtag = trim($input{'v3i_wgtags'} || '');
    # get old tags
    my @wgtags = ();
    open(FILE, "$v3_dataDir/$username.dat");
    hold(FILE);
    chomp(@wgtags = <FILE>);
    release(FILE);
    close(FILE);
    # save back out, but skip the one we don't want anymore
    open(FILE, ">$v3_dataDir/$username.dat")
      || error("$err{'001'} $v3_dataDir/$username.dat");
    hold(FILE);
    for (@wgtags) {
      print FILE qq~$_\n~ unless $_ eq $oldtag;
    }
    release(FILE);
    close(FILE);
  } else {			# updating preferences
    my $v3i_gamertag = trim($input{'v3i_gamertag'} || '');
    my $v3i_ogamertag = trim($input{'v3i_ogamertag'} || '');
    my $v3i_preference = int($input{'v3i_preference'} || 0);
    $v3i_preference = 0 if $v3i_perference < 0 || $v3i_perference > 3;

    # did gamertag change?
    if ($v3i_gamertag eq '') {			# delete gamertag  
      # grab members gamertags
      my @mgtags = ();
      open(FILE, "$v3_dataDir/users.dat");
      hold(FILE);
      while ($_ = <FILE>) {
        next if /^$username\|/;
	push @mgtags, $_;
      }
      release(FILE);
      close(FILE);
      # save new members gamertags
      open(FILE, ">$v3_dataDir/users.dat")
        || error("$err{'001'} $v3_dataDir/users.dat");
      hold(FILE);
      print FILE @mgtags;
      release(FILE);
      close(FILE);
      unlink "$v3_dataDir/$username.dat";
      print qq~<div>$v3_msg{'007'}</div>~;

      return;
    } elsif ($v3i_gamertag ne $v3i_ogamertag) {	# change gamertag
      # validate tag
      my %checktag = x3v_check_gamertag($v3i_gamertag);
      if (exists $checktag{'error'}) {
        print ($checktag{'error'} || $v3_msg{'001'});
        return;
      }
      unless ($checktag{'valid'}) {
        print qq~<p>$v3i_gamertag $v3_msg{'081'}</p>~;
        return;
      }
    }
    # get old tags
    my @mgtags = ();
    open(FILE, "$v3_dataDir/users.dat");
    hold(FILE);
    while ($_ = <FILE>) {
      next if /^$username\|/;
      push @mgtags, $_;
    }
    release(FILE);
    close(FILE);
    # save members plus new preferences
    open(FILE, ">$v3_dataDir/users.dat")
      || error("$err{'001'} $v3_dataDir/users.dat");
    hold(FILE);
    print FILE @mgtags;
    print FILE qq~$username|$v3i_gamertag|$v3i_preference~;
    release(FILE);
    close(FILE);
  }

  print qq~<div>$v3_msg{'007'}</div>~;
}
########################################################################

########################################################################
# Get Watched List
########################################################################
sub v3i_get_watched {
  # grab member's watch tags
  my @wgtags = ();
  if (-e "$v3_dataDir/$username.dat") {
    open(FILE, "$v3_dataDir/$username.dat")
      || error("$err{'001'} $v3_dataDir/$username.dat");
    hold(FILE);
    chomp(@wgtags = <FILE>);
    release(FILE);
    close(FILE);
  }
  
  return @wgtags;
}
########################################################################

########################################################################
# common functions
########################################################################
sub trim { # trim leading and trailing whitespace
  local $_ = shift || ''; /^\s*(.*?)\s*$/; return $1 }
########################################################################

1;