#!/usr/bin/perl -w

########################################################################
#
# program: 360voice.cgi
# system : 360voice Mod for WebAPP NE (Network Edition)
# author : Copyright (C) 2007 Steven L. Reid
# purpose: Display Xbox 360 information using the 360voice API.
# history:
# 3/25/2007, Steven Reid
#	- script created
#
########################################################################

# setup environment
$|++;
#use strict; # turned off due to WebAPP not supporting it

# Read configuration file
BEGIN {
  use CGI::Carp qw(fatalsToBrowser);
  # include initial configuration
  require "$scriptdir/mods/360voice/data/paths.cfg";
  require "$scriptdir/mods/360voice/data/mod.cfg";
  # include language file (if exists)
  if ( -e "$v3_langDir/$userlang") {
    require "$v3_langDir/$userlang";
  } else {
    require "$v3_langDir/$v3_defaultLang";
  }
}

# load libraries
use lib $v3_scriptDir;

# define globals
my $v3_URL = "$v3_scriptURL/index.cgi?";

# define variables
my $selfurl = get_self_url();

########################################################################
# Display 360voice
########################################################################
sub display_360voice {
  my $gamertag = v3_get_user() || 'SafePit';

  # print top
  $navbar = qq~$btn{'014'}
    <a href="$v3_scriptURL/index.cgi">$v3_title</a>
    $btn{'014'} $v3_msg{'054'}~;
  print_top();

  # get blog
  use x360voice;
  my $xbox360voice;
  
  # get profile
  my %profile = x3v_get_profile($gamertag);
  if (exists $profile{'error'}) {
    $xbox360voice = $profile{'error'} || $v3_msg{'001'};
    print "<div>$xbox360voice</div>";
    return;
  }
  # get badges
  my %badges = x3v_get_badges($gamertag);
  if (exists $badges{'error'}) {
    $xbox360voice = $badges{'error'} || $v3_msg{'001'};
    print "<div>$xbox360voice</div>";
    return;
  }
  # get entries
  my %entries = x3v_get_entries($gamertag, 1);
  if (exists $entries{'error'}) {
    $xbox360voice = $entries{'error'} || $v3_msg{'001'};
    print "<div>$xbox360voice</div>";
    return;
  }
  
  # build page
  my $entry = shift @{$entries{'data'}};
  my $title = $v3_msg{'056'} . $entry->{'gamertag'};
  my $img = $profile{'tile'}; 
  $xbox360voice .= qq~
<a href="$v3_scriptURL/index.cgi?gamertag=$gamertag"><img src="$img"
  alt="$title" title="$title"
  style="float: left; margin-right: 5px; margin-bottom: 5px; border: 1px solid black;"
  /></a>
~;
  for (@{$entries{'data'}}) {
    my $title = $_->{'title'};
    my $link = $_->{'link'};
    my $body = $_->{'body'};
    $xbox360voice .= qq~
<p><b><a href="$link" target="_new">$title</a></b><br />$body</p>
 ~;
  }
  $xbox360voice .= qq~
<p>
~;
  for (@{$badges{'data'}}) {
    my $title = $_->{'title'};
    my $image = $_->{'image'};
    my $url = $_->{'url'};
    $xbox360voice .= qq~
<a href="$url" target="_new"><img
src="$image" alt="$title" title="$title" /></a>
~;
  }
  $xbox360voice .= qq~
</p>
~;

  # display badge
  print "<div>$xbox360voice</div>";

  # display bottom
  print qq~
<div class="textsmall" style="border-top: 1px solid black;">
<a href="$v3_scriptURL/index.cgi?op=blog&gamertag=$gamertag"
>$v3_msg{'054'}</a>
<a href="$v3_scriptURL/index.cgi?op=compare&amp;gamertag2=$gamertag">$v3_msg{'068'}</a>
<a href="$v3_scriptURL/index.cgi?op=games&gamertag=$gamertag"
>$v3_msg{'057'}</a>
<a href="$v3_xboxlive/$gamertag" target="_new">$v3_msg{'012'}</a>
~;
  if ($username ne $anonuser) {
    print qq~
<a href="$v3_scriptURL/index.cgi?op=watched">$v3_msg{'011'}</a>
<a href="$v3_scriptURL/index.cgi?op=admin">$v3_msg{'010'}</a>
~;
  }
  print qq~
</div>~;
}
########################################################################

########################################################################
# Get User - figure out the users's gamertag
########################################################################
sub v3_get_user {
  # grab members gamertags
  my @mgtags = (); my $mgtag; my $mpref;
  open(FILE, "$v3_dataDir/users.dat")
    || error("$err{'001'} $v3_dataDir/users.dat");
  hold(FILE);
  while ($_ = <FILE>) {
    chomp;
    my ($member, $gamertag, $pref) = split /\|/, $_, 3;
    next unless $member && $gamertag;
    $mgtag = $gamertag if $member eq $username;
    $mpref = ($pref || 0) if $member eq $username;
    push @mgtags, $gamertag;
  }
  release(FILE);
  close(FILE);
  
  # grab member's watch tags
  my @wgtags = ();
  if ($username ne $anonuser && -e "$v3_dataDir/$username.dat") {
    open(FILE, "$v3_dataDir/$username.dat")
      || error("$err{'001'} $v3_dataDir/$username.dat");
    hold(FILE);
    chomp(@wgtags = <FILE>);
    release(FILE);
    close(FILE);
  }

  # how to we manage this file?
  if ($v3_view_type == 1 && $mpref < 2 &&
    $username ne $anonuser && $mgtag) {
    # by logged in user, not a guest and gamertag exists
    return $mgtag;
  } else {
    # randomly pick one
    my @keys;
    push @keys, @mgtags if $mpref != 3;
    push @keys, @wgtags if $mpref > 1;
    return $keys[int(rand($#keys))];
  }
}
########################################################################

########################################################################
sub trim { # trim leading and trailing whitespace
  local $_ = shift || ''; /^\s*(.*?)\s*$/; return $1 }
########################################################################
sub isnum { # check if a number, otherwise load defaults
  my $retval; my $lastval;
  for my $val (@_) {
    $lastval = $val;
    next unless defined $val;
    next unless $val =~ /^\s*(\d+)\s*$/;
    return $1;
  }
  return $lastval;
}
########################################################################
sub get_self_url { # determine self url
  my $uri = $ENV{'REQUEST_URI'} || $v3_URL;
  $uri =~ s/\&*bc_year=\d+//g;
  $uri =~ s/\&*bc_month=\d+//g;
  $uri =~ s/\&/\&amp;/g;
  $uri =~ s/\&amp;amp;/\&amp;/g;
  $uri .= ($uri !~ /\?/ ? '?' : $uri !~ /\?$/ ? '&amp;' : '');
  return $uri;
}
########################################################################

1;
