###############################################################################
###############################################################################
# WebAPP NE (Network Edition) - Web Automated Perl Portal                     #
#-----------------------------------------------------------------------------#
# theme.pl                                                                    #
# Sub-Routines                                                                #
# v0.9.9.3.4                                                                  #
# Based on Old WebAPP v0.9.9.6 Standard Theme                                 #
# HTML Upgraded for W3C Validation by: Jos Brown (www.bantychick.com)         #
# Cross-Browser Broadcast Message Upgrade by: Jos                             #
# Updated for new v0.9.9.3 subroutines by: Jos                                #
# Top and Bottom Center Blocks routines by: Aron Shiewitz (2xlnt.com)         #
# Home Page, Top, Favorites Icon Links by: John-Gr (www.coinsmania.gr)        #
# CSS Style Sheet Compatibility Upgrade by: my2cents (classicchat.net)        #
#                                                                             #
# (WebAPP NE Copyright (c) WebAPP Network group - www.web-app.net)            # 
#                                                                             # 
# WebAPP NE is the continued development of WebAPP, beginning with            #
# upgrade from WebAPP v0.9.9.3.2 to WebAPP v0.9.9.3.3 NE in June 2006         #
# (WebAPP Copyright (c) WebAPP - www.web-app.org and                          #
# M. Carter Brown - www.mcarterbrown.com)                                     #
#                                                                             # 
# WebAPP was based on YaWPS in 2002 - yawps.sourceforge.net                   # 
# (YaWPS  Copyright (c) 2001 by d3m1g0d)                                      #
#                                                                             # 
# YaWPS was based on YaBB in 2001 by Zef Hemel - www.zefhemel.com             # 
# (YaBB Copyright (c) 2000 The YaBB Programming team)                         # 
#                                                                             #
# This file is part of WebAPP NE.                                             #
#                                                                             #
# WebAPP NE is free software; you can redistribute it and/or modify           #
# it under the terms of the GNU General Public License as published by        #
# the Free Software Foundation; either version 2 of the License, or           #
# (at your option) any later version.                                         #
#                                                                             #
# WebAPP NE is distributed in the hope that it will be useful,                #
# but WITHOUT ANY WARRANTY; without even the implied warranty of              #
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               #
# GNU General Public License for more details.                                #
#                                                                             #
# You should have received a copy of the GNU General Public License           #
# along with WebAPP NE; if not, write to the Free Software Foundation, Inc.,  #
# 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.               #
#                                                                             #
# Modified:                                                                   #
###############################################################################
###############################################################################

require "$sourcedir/block.pl";
require "$sourcedir/menuman.pl";
if (-e "$langdir/theme/$userlang") {require "$langdir/theme/$userlang";}
elsif (-e "$langdir/theme/$language") {require "$langdir/theme/$language";}
else {require "$langdir/theme/english.lng";}

#############
sub getvars {
#############

	$titlebg = "#000000";
	$windowbg = "#eeeeee";
	$windowbg2 = "#ffffff";
	$windowbg3 = "#eeeeee";
}

##############
sub menuitem {
##############

my ($url, $title, $target, $icon) = @_;

	if ($url) {
		if ($url =~ /^https?:\/\//i) {
			print qq~<li><a href="$url" class="menu" target="$target">$title</a></li>
~;
		} else {
			print qq~<li><a href="$pageurl/$cgi\?action=$url" class="menu"$target>$title</a></li>
~;
		}
	} else {
			print qq~<li><a href="$pageurl/$cgi" class="menu">$title</a></li>
~;
	}

}

###############
sub boxheader {
###############

	my ($title) = @_;
	print qq~
<h2>$title</h2>
<ul>
~;

}

###############
sub boxfooter {
###############

	print qq~
</ul>
~;

}

############
sub boxtop {
############

	my ($title) = @_;
	print qq~
<h2>$title</h2>
<div class="boxtop">
~;

}

###############
sub boxbottom {
###############

	print qq~</div>
~;

}

#######################
sub cboxheader {
#######################
# for center blocks

	my ($title) = @_;

	print qq~<div class="menutable">&nbsp;$title</div>
<div class="menubordercolor" style="padding: 1px;">
<div class="menubackcolor">
<div class="newstextnormal">~;

}

#######################
sub cboxfooter {
#######################
# for center blocks

	print qq~</div></div>
~;

}

#############
sub nav_bar {
#############

	print qq~
	<div id="breadcrumb">&nbsp;~;

	require "$sourcedir/breadcrumb.pl";
	breadcrumb();

	print qq~</div>
~;

}

################
sub logo_block {
################

	print <<EOL;
    <div id="header">
      <h1 id="logo"><a href="$baseurl">$pagetitle</a></h1>
      <ul id="navigation">
        <li><a href="$pageurl/$cgi?action=about">$nav{'091'}</a></li>
        <li><a href="$pageurl/$cgi?action=contact">$nav{'092'}</a></li>
        <li><a href="$pageurl/$cgi?action=help">$nav{'090'}</a></li>
      </ul>
EOL
	if ($searchmod eq 1) { search_module(); }
	print <<EOL;
    </div>
EOL

}

####################
sub checkforbanner {
####################

	if ($dispfrad ne "0") { banner_disp(); }

}

#################
sub show_banner {
#################

	print <<EOL;
<div id="banner">
EOL

	require "$sourcedir/ads.pl";
	OutputJava();

	print <<EOL;
</div>
EOL

}

##############
sub menu_bar {
##############
# for Menu Manager, this is designed to be the bottom menu but can be used for both as before

	print qq~<table border="0" cellpadding="0" cellspacing="0" width="100%" class="navbar">
<tr>
~;
	show_menubar("menubar");

	print qq~</tr>
</table>
~;

}

###############
sub main_menu {
###############

	boxheader("$nav{'038'}");

	show_menu("mainmenu");

	boxfooter();

}


##############
sub top_menu {
##############

	print qq~<table border="0" cellpadding="0" cellspacing="0" width="100%" class="topnavbar">
<tr>
~;


	show_topmenu("topmenu");

	print qq~</tr>
</table>
~;

}

##################
sub search_block {
##################

	if ($searchmod eq "2") {

		boxtop("$nav{'039'}");

		print qq~
<form method="POST" action="$pageurl/$cgi?action=search">
<input type="hidden" name="action" value="search">
<input type="text" name="pattern" size="16" class="textinput">
<input type="submit" class="searchbutton" value="$btn{'001'}"><br>
<a href="$pageurl/$cgi?action=search&amp;type=advanced&amp;page=0&amp;articleson=on&amp;forumson=off&amp;linkson=off&amp;downloadson=off" class="menu">$nav{'154'}</a>
<input type="hidden" name="articleson" value="on">
<input type="hidden" name="forumson" value="on">
<input type="hidden" name="linkson" value="off">
<input type="hidden" name="downloadson" value="off">
</form>
~;

		boxbottom();

	}

}

###################
sub search_module {
###################

	print qq~
<div id="navsearch">
<form
 method="POST" action="$pageurl/$cgi?action=search"><input
 type="hidden" name="action" value="search"><input
 type="text" name="pattern" size="16" class="textinput"
 style="color: gray"  value="$btn{'001'}..."  onclick="this.value=' '"
 maxlength="30">&nbsp;&nbsp;<input type="image"
 src="$themesurl/$usertheme/images/showme.gif"  alt="$btn{'001'}"
 title="$btn{'001'}" value="$btn{'001'}...">&nbsp;<a href="$pageurl/$cgi?action=search&amp;type=advanced&amp;page=0&amp;articleson=on&amp;forumson=off&amp;linkson=off&amp;downloadson=off"><img
 src="$themesurl/$usertheme/images/advsearch.gif"
 alt="$nav{'154'}" title="$nav{'154'}"></a>
 <input type="hidden" name="articleson" value="on">
 <input type="hidden" name="forumson" value="on">
 <input type="hidden" name="linkson" value="off">
 <input type="hidden" name="downloadson" value="off"></form>
</div>
~;

}

##################
sub mysite_block {
##################

	if ($username eq "$anonuser") {
		login_panel();
	} else {
		member_panel();
	}

}

##################
sub status_block {
##################

	boxtop("$nav{'040'}");
	userstatus();
	boxbottom();

}

#####################
sub leftblock_block {
#####################

#	require "$sourcedir/block.pl";
	block_left();

}

################
sub poll_block {
################

	if ($pollmod eq "" || $pollmod eq "1") {
		boxtop("$nav{'041'}");

		require "$sourcedir/poll.pl"; poll();

		boxbottom();
	}

}

######################
sub rightblock_block {
######################

	block_right();

}


####################
sub topblock_block {
####################

	block_top();

}


#######################
sub bottomblock_block {
#######################

	block_bottom();

}


####################
sub calendar_block {
####################

	if ($modulecal == 1) {
		boxheader("$msg{'284'}");

		require "$sourcedir/showcal.pl";
		displayCal();

		boxfooter();
	}

}

######################
sub newsletter_block {
######################

	if ($modulenl eq "1") {
		if ($modulenlmem eq "1" && $username ne "$anonuser") {
			newsletter_display();
		}
		if ($modulenlmem eq "0") {
			newsletter_display();
		}
	}

}

########################
sub newsletter_display {
########################

	boxtop("$mnu{'038'}");

	print qq~<form action="$pageurl/$cgi?action=subscribe" method="POST">
$msg{'487'}
<br>$msg{'007'}
<input type="text" class="textinput" name="joinnl" value="" size="12">
<br>
<input type="radio" name="action" value="subscribe" checked>
$msg{'176'}
<br>
<input type="radio" name="action" value="remove">
$msg{'177'}
<br><span style="text-align: center"><input type="submit" value="$btn{'016'}" class="newsletterbutton"></span>
</form>
~;

	boxbottom();

}

################
sub info_block {
################

	if ($infoblockmod eq "1") {

		if ($username ne "$anonuser") {
			open(FILE, "$memberdir/$username.pref") || error("$err{'010'}");
			hold(FILE);
			chomp(@preferences = <FILE>);
			release(FILE);
			close(FILE);

			if ($preferences[1] == 1 || $preferences[1] eq "" ) {
				boxheader("$msg{'486'}");

				print qq~
<li><a href="$link1" target="_blank"><img
  alt="" border="0" src="$level$image1" /></a></li>
<li><a href="$link2" target="_blank"><img
  alt="" border="0" src="$level$image2" /></a></li>
<li><a href="$link3" target="_blank"><img
  alt="" border="0" src="$level$image3" /></a></li>
~;

				boxfooter();
			}
		} else {
			boxheader("$msg{'486'}");

			print qq~
<li><a href="$link1" target="_blank"><img
  alt="" border="0" src="$level$image1" /></a></li>
<li><a href="$link2" target="_blank"><img
  alt="" border="0" src="$level$image2" /></a></li>
<li><a href="$link3" target="_blank"><img
  alt="" border="0" src="$level$image3" /></a></li>
~;
			boxfooter();
		}
	}

	if ($infoblockmod eq "2") {
		boxheader("$msg{'486'}");
		print qq~
<li><a href="$link1" target="_blank"><img
  alt="" border="0" src="$level$image1" /></a></li>
<li><a href="$link2" target="_blank"><img
  alt="" border="0" src="$level$image2" /></a></li>
<li><a href="$link3" target="_blank"><img
  alt="" border="0" src="$level$image3" /></a></li>
~;
		boxfooter();
	}
}

#####################
sub mycontent_block {
#####################

	if ($showcon eq "1") {

		boxhead($nav{'093'});
		latestforumposts();
		if (@myforumnum) {
			for ($myflcounter = 0; $myflcounter < @myforumnum && $myflcounter < 5; $myflcounter++) {
				print qq~<li>$myforumdata{$myforumnum[$myflcounter]}</li>
~;
			}
		} else {
			print qq~
<li>$msg{'179'}</li>
~;
		}

		boxbottom();

	}

}

######################
sub mycontent_block2 {
######################

	if ($showcon2 eq "1") {

		boxheader("$nav{'093'}" );

		latestforumposts();

		if (@myforumnum) {
			for ($myflcounter = 0; $myflcounter < @myforumnum && $myflcounter < 5; $myflcounter++) {
				print qq~<li>$myforumdata{$myforumnum[$myflcounter]}</li>
~;
			}
		} else {
			print qq~<li>$msg{'179'}</li>
~;
		}

		boxfooter();

	}

}

###############
sub about_bar {
###############

	print qq~<table class="helpsnavtable">
<tr>
<td><a href="$pageurl/$cgi?action=about" class="helpsnavlink">$nav{'091'}</a> &#124; <a
 href="$pageurl/$cgi?action=contact" class="helpsnavlink">$nav{'092'}</a> &#124; <a
 href="$pageurl/$cgi?action=help" class="helpsnavlink">$nav{'090'}</a> &#124; <a
 href="$pageurl/$cgi?action=recommend" class="helpsnavlink">$nav{'008'}</a>~;

	show_stats();

	print qq~</td>
<td align="right"><a
 href="#" onClick="this.style.behavior='url(#default#homepage)'; this.setHomePage('$scripturl/$cgi');" onmouseout="self.status=''; return true" onmouseover="self.status='$thm{'003'}'; return true"><img
 src="$themesurl/$usertheme/images/home2.gif"
 border="0" alt="$thm{'001'}" title="$thm{'002'}"></a>&nbsp;&nbsp;<a
 href="javascript:window.external.AddFavorite%20('$scripturl/$cgi','$pagename')" onmouseout="self.status=''; return true" onmouseover="self.status='$thm{'006'}'; return true"><img
 src="$themesurl/$usertheme/images/topicsb.gif"
 border="0" alt="$thm{'004'}" title="$thm{'005'}"></a>&nbsp;&nbsp;<a
 href="#top" onmouseout="self.status=''; return true" onmouseover="self.status='$thm{'009'}'; return true"><img
 src="$themesurl/$usertheme/images/icon_go_up.gif" border="0" alt="$thm{'007'}" title="$thm{'008'}"></a></td>
</tr>
</table>
~;

}

################
sub wepapp_bar {
################

	print qq~<table border="0" cellpadding="0" cellspacing="0" align="center">
<tr>
<td><br /></td>
</tr>
<tr>
<td align="center" class="webapptext">$msg{'399'}<a
 href="$scripturl/$cgi?action=ver"
 class="webapplink">$scriptname v$scriptver</a> $msg{'400'}<br />
$msg{'401'}~;

	if ($navbar && ($navbar !~ /\S/)) { # print xml button front page only ($navbar is space)
		print qq~<br /><a
 href="$baseurl/webapp.xml" target="_blank"><img src="$imagesurl/xmlfeed.gif"
 width="80" height="15" vspace="3" border="0"
 title="$msg{'726'}" alt="$msg{'726'}"></a>~;
	}

	print qq~<br />
<br />
<br />
</td>
</tr>
</table>
~;

}

#################
sub login_panel {
#################

	$returnpage1 = $info{'action'} || '';
	$returnpage2 = $info{'board'} || '';
	$returnpage3 = $info{'cat'} || '';
	$returnpage4 = $info{'viewcat'} || '';
	$returnpage5 = $info{'num'} || '';
	$returnpage6 = $info{'id'} || '';

	print qq~<h2>$nav{'012'}</h2>
	<div align="center">
	<form method="post" action="$pageurl/$cgi?action=login2">
	<input type="hidden" name="returnpage1" value="$returnpage1" />
	<input type="hidden" name="returnpage2" value="$returnpage2" />
	<input type="hidden" name="returnpage3" value="$returnpage3" />
	<input type="hidden" name="returnpage4" value="$returnpage4" />
	<input type="hidden" name="returnpage5" value="$returnpage5" />
	<input type="hidden" name="returnpage6" value="$returnpage6" />
	Username: <input type="text" class="textinput" name="username" size="8" /><br />
	Password: <input type="password" class="textinput" name="passwrd" size="8" /><br />
	<input type="checkbox" name="rememberme" checked="checked" />&nbsp;$msg{'410'}<br />
	<input type="submit" class="button" value="$btn{'017'}" /><br />
	<a href="$pageurl/$cgi?action=reminder">$nav{'014'}</a><br />
	$msg{'340'}<a href="$pageurl/$cgi\?action=register" class="menu"><u>$msg{'341'}</u></a>.
	</form></div>
~;
}

##################
sub member_panel {
##################

	boxheader("$msg{'587'}");
	show_menu("memberpanel");
	boxfooter();

	if (($username ne $anonuser) && (-e "$datadir/menuman/$username.dat")) {
		if ($username eq "admin") {
			boxheader("$thm{'011'}");
		} else {
			boxheader("$thm{'010'}");
		}
		show_menu("$username");
		boxfooter();
	}

}

################
sub newsheader {
################
# closes the nav_bar around the welcome message

	print qq~
~;

	block_top();

}

#############
sub newstop {
#############

	$post = qq~
<h2>$subject</h2>
<h3>$curcatname: $postdate $msg{'042'} <a
 href="$cgi?action=anonemail&amp;sendto=$poster"
 class="smallnewslink">$nick</a></h3>
~;

}

###############
sub newsshort {
###############

	$post = qq~<div>$post<img src="$imagesurl/topics/$curcat.gif" border="0" align="right" vspace="5" alt="$curcatname" style="padding-left: 10px;" />
$message</div>
<h3><a
 href="$pageurl/$cgi?action=printtopic&amp;id=$id&amp;curcatname=$curcatname&amp;img=$curcat"><img
 src="$imagesurl/print.gif" border="0" title="$msg{'106'} - $subject" alt="$msg{'106'} - $subject" /></a>&nbsp;&nbsp;<a
 href="$pageurl/$cgi?action=emailtopic&amp;id=$id&amp;curcatname=$curcatname"><img
 src="$imagesurl/friend.gif" border="0" title="$msg{'724'}" alt="$msg{'724'}" /></a>
&nbsp;&nbsp;$readcount
[ <a
 href="$pageurl/$cgi?action=viewnews&amp;id=$id#topcomment"
 class="newslink">$commentscnt</a> ]
</h3>
~;

}

##############
# sub newslong {
##############
# not in use as of 0.9.9.3

################
sub show_stats {
################

	if ($dispstat eq "0" && $username eq "admin") {
		print qq~ &#124; <a href="$pageurl/$cgi?action=stats" class="helpsnavlink">$nav{'006'}</a>~;
	}
	if ($dispstat eq "1" && $username ne "$anonuser") {
		print qq~ &#124; <a href="$pageurl/$cgi?action=stats" class="helpsnavlink">$nav{'006'}</a>~;
	}
	if ($dispstat eq "2") {
		print qq~ &#124; <a href="$pageurl/$cgi?action=stats" class="helpsnavlink">$nav{'006'}</a>~;
	}

}

#################
sub banner_disp {
#################

	if ($dispfrad eq "1" && $username ne "$anonuser") {
		open(FILE, "$memberdir/$username.pref") || error("$err{'010'}");
		hold(FILE);
		chomp(@preferences = <FILE>);
		release(FILE);
		close(FILE);

		if ($preferences[2] eq "1") {
			show_banner();
		}

			}

	if ($dispfrad eq "2" || $username eq "$anonuser") { show_banner(); }

}

##################
sub footercredit {
##################

	print qq~
<div style="padding: 2px; text-align: right; font-size: 9px; color: #000000"> &quot;WebAPP Blog Two Column&quot; theme by <a href="http://www.web-app.net/" target="_blank" style="color: #0000ff">SafePit</a><div>
</div>
~;


}
######################
sub broadcastmessage {
######################

	if ($username ne "$anonuser") {
		open(FILE, "$memberdir/admin.pref") || error("$err{'010'}");
		hold(FILE);
		chomp(@preferences = <FILE>);
		release(FILE);
		close(FILE);

 		if ($preferences[4] == 1) {
         print qq~<table id="showimage"
style="position:absolute; width:250px; left:250px; top:250px"
bgcolor="$bmheadercolor" cellpadding="0" cellspacing="2" border="0">
<tr>
<td width="100%"><table border="0" width="100%" cellspacing="0" cellpadding="0"
height="36">
<tr>
<td id="dragbar" style="cursor:hand; font-family: Verdana; color: $bmbgcolor"
width="100%" onMouseover="dragswitch=1;if (ns4) drag_dropns(showimage);"
onMouseout="dragswitch=0;" onMousedown="initializedrag(event);"
onselectstart="return false;"><strong><small>Admin Broadcast Message</small></strong></td>
<td><a href="#" onClick="hidebox();return false;"><img
src="$themesurl/standard/images/close.gif" width="16" height="14"
border="0" alt="close this window"></a></td>
</tr>
<tr>
<td width="100%" bgcolor="$bmbgcolor" style="padding:4px" colspan="2">

<!-- PUT YOUR CONTENT BETWEEN HERE -->

$preferences[5]

<!-- END YOUR CONTENT HERE -->

</td>
</tr>
</table></td>
</tr>
</table>
~;

		}

	}


}

1; # return true