###############################################################################
###############################################################################
# WebAPP NE (Network Edition) - Web Automated Perl Portal                     #
#-----------------------------------------------------------------------------#
# gallery.pl                                                                  #
# For the Gallery-APP program                                                 #
# Original Written by M. Carter Brown and offered as a Gift to                #
# the Beta Development crew for WebAPP v0.9.9.3 in Winter of 1995             #
# Contact: www.mcarterbrown.com      License: WebAPP License                  #
# Core Code Integration by: SimonJ and Jos Brown                              #
# User Avatars by: SimonJ                                                     #
# Image::Size'ing by: Jos Brown (www.bantychick.com)                          #
# Delete Empty Gallery files and other fixes by: sburg                        #
#                                                                             #
# (WebAPP NE Copyright (c) WebAPP Network group - www.web-app.net)            # 
#                                                                             # 
# WebAPP NE is the continued development of WebAPP, beginning with            #
# upgrade from WebAPP v0.9.9.3.2 to WebAPP v0.9.9.3.3 NE in June 2006         #
# (WebAPP Copyright (c) WebAPP - www.web-app.org and                          #
# M. Carter Brown - www.mcarterbrown.com)                                     #
#                                                                             # 
# WebAPP was based on YaWPS in 2002 - yawps.sourceforge.net                   # 
# (YaWPS  Copyright (c) 2001 by d3m1g0d)                                      #
#                                                                             # 
# YaWPS was based on YaBB in 2001 by Zef Hemel - www.zefhemel.com             # 
# (YaBB Copyright (c) 2000 The YaBB Programming team)                         # 
#                                                                             #
# This file is part of WebAPP NE.                                             #
#                                                                             #
# WebAPP NE is free software; you can redistribute it and/or modify           #
# it under the terms of the GNU General Public License as published by        #
# the Free Software Foundation; either version 2 of the License, or           #
# (at your option) any later version.                                         #
#                                                                             #
# WebAPP NE is distributed in the hope that it will be useful,                #
# but WITHOUT ANY WARRANTY; without even the implied warranty of              #
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               #
# GNU General Public License for more details.                                #
#                                                                             #
# You should have received a copy of the GNU General Public License           #
# along with WebAPP NE; if not, write to the Free Software Foundation, Inc.,  #
# 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.               #
#                                                                             #
# Created Date: 03-09-04 by Carter                                            #
# Updated: 06-29-04 /* Added Feedback Module */                               #
# Updated: 09-17-04 /* Delete Members */                                      #
# Updated: 05-12-05 /* Gallery on/off */                                      #
# Updated: 11-02-05 /* Setup for distribution */                              #
# Modified: 13 Apr 2006 by my2cents                                           #
# Modified: 17 May, 29 July, 30 July, 1 Aug 2006, 27 Aug by Jos               #
# Modified: 25 Jul 2006 by sburg                                              #
###############################################################################
###############################################################################

$galleryon = 1;	# Change this to 0 if you do not want users to create new galleries
                # You can then use the createprivategallery in the admin section

if (-e "$langdir/gallery/$userlang") {require "$langdir/gallery/$userlang";}
elsif (-e "$langdir/gallery/$language") {require "$langdir/gallery/$language";}
else {require "$langdir/gallery/english.lng";}

###########
sub start {
###########

	$navbar = " $btn{'014'} $gal{'001'}";
	print_top();

	$howmany = 0;

	print qq~<br><b><u>$gal{'002'}</u></b><p>$gal{'003'}:<br><br>
<table border="0" cellpadding="1" cellspacing="0" width="100%" class="menubordercolor">
<tr align="center"><td width="100%">
<table border="0" width="100%" cellpadding="3" cellspacing="5" class="menubackcolor">
<tr align="center">~;

	opendir (DIR, "$imagesdir/memberpics");
	@files = readdir(DIR);
	closedir (DIR);

	open(GALTXT, ">$datadir/gallery/gallerylist.dat");
	hold(GALTXT);

	foreach $files (@files) {
		# use placeholder to prevent loss of empty folders, keep dot filter for old setups
		if (($files =~ /^\./ ) || ($files eq "placeholder")) { next; }
		else {
			open(GETDATE, "$datadir/memberpics/$files/lastupdated.dat");
			hold(GETDATE);
			chomp(@thedate = <GETDATE>);
			release(GETDATE);
			close(GETDATE);

			if (!$thedate[0]) { $thedate[0] = ''; }
			$thedate[0] =~ s/[\n\r]//g;

			$lowername = lc($files);
			print GALTXT "$lowername|$files|$thedate[0]\n";
		}
	}
	release(GALTXT);
	close(GALTXT);

	open(FILE, "<$datadir/gallery/gallerylist.dat");
	hold(FILE);
	chomp(@data = <FILE>);
	release(FILE);
	close(FILE);

	@sortedfiles = sort(@data);
	my $islisted = 0;
	foreach $sortedfiles (@sortedfiles) {
		($lcname, $regname, $updateddate) = split(/\|/, $sortedfiles);
		$howmany++; 

		my $new = "";
		if ($username ne $anonuser) { # check for new only for members - Jos
			$date1 = readlog("$regname");
			$date2 = $updateddate;

			if ($date2) {
				$new = checkfornew($date1, $date2);
				if ($new) {
					$new = qq~<img src="$imagesurl/forum/new.gif" alt="">~;
				}
			}
			if ($regname eq $username) {
				$islisted = 1; # set for showing "create new" link - Jos
			}
		}

		# SimonJ Added avatars
		$regnamelink = "";
		if (-e "$memberdir/$regname.dat") {
			@memsettings = chomp_database("$memberdir/$regname.dat");
			$link = $memsettings[9] || "";
			if ($link) {
				if (-e "$imagesdir/avatars/$link"){
					$regnamelink = "$imagesurl/avatars/$link";
				}
				elsif (-e "$imagesdir/uploads/$link"){
					$regnamelink = "$imagesurl/uploads/$link";
				}
				elsif ($link =~ /^https?:\/\//) {
					$regnamelink = "$link";
				} else {
					$regnamelink = "";
				}
			}
		}
		my $width = "";
		my $height = "";
		if ($memberpic_width) { $width = qq~ width="$memberpic_width"~; }
		if ($memberpic_height) { $height = qq~ height="$memberpic_height"~; }

		print qq~<td><a href="$scripturl/$cgi?action=gallery&amp;op=galview&amp;username=$regname"><img
 src="$regnamelink"$width$height alt="$regname$gal{'010'} Avatar"><br>$regname</a>~;
		# End of avatar add-on

		if ($username ne "$anonuser") { print qq~$new~; }

		print qq~</td>~;
#		if ($howmany ge "3") {
# 27 Aug 2006:
		if ($howmany >= 3) {
			print qq~</tr>
<tr align="center">~;
			$howmany = 0;
		}
	}

	print qq~</table></td>
</tr>
</table>
~;

	if ($username ne $anonuser) { # show "mark as read" and "create new" links only to members - Jos
		print qq~<br>
<a href="$scripturl/$cgi?action=gallery&amp;op=galmarkasread">$gal{'006'}</a><br>
~;
		if (!$islisted) { # show "create new" link only to those with no gallery yet - Jos
			print qq~<br>$gal{'004'}  <a
 href="$scripturl/$cgi?action=gallery&amp;op=galview&amp;username=$username">$gal{'005'}</a><br>
~;
		}

		if ($username eq 'admin') { # clear out old pictures
			print qq~<br>
<a href="$scripturl/$cgi?action=gallery&amp;op=galclearold">$gal{'081'}</a><br>
~;
		}
	}

	print_bottom();
	exit;

}

###______________________________________________________________________________
###
### Sub View
### Viewing a particular Gallery
### Description:
###		This section views the gallery of the $username that you choose, if
###		the gallery is not found, and it's is YOUR username, then it will
###		automatically create a gallery for you!
###
### You can SHUT DOWN the create new galleries here by placing the sub nogallery();
###______________________________________________________________________________
###

##########
sub view {
##########

	if ($info{'username'} eq "") { error("$gal{'007'}"); }
	if ($info{'username'} eq "$anonuser") { error("$gal{'008'}"); }

	# Writing to the log once the site has bee viewed
	writelog("$info{'username'}");

	$navbar = "$btn{'014'} $gal{'001'} $btn{'014'} $info{'username'}";
	print_top();

	if ($username ne "$info{'username'}") {
		&views("$info{'username'}");
	}

	open(FILE, "<$memberdir/$info{'username'}.dat") || error("$info{'username'} $gal{'009'}");
	hold(FILE);
	chomp(@userdata = <FILE>);
	release(FILE);
	close(FILE);

	$userdata[1] =~ s/[\n\r]//g;

	if ($galleryon eq "1") {
		opendir (DIR, "$imagesdir/memberpics/$info{'username'}") || creategallery();
	} else {
		opendir (DIR, "$imagesdir/memberpics/$info{'username'}") || nogallery();
	}
	@files = readdir(DIR);
	closedir (DIR);
	@files = grep(/\./,@files);
	@sortedfiles = sort(@files);

	$totalit = 0;
	$howmany = 0;
	$empty = 0;
	$checking = 0;
	$finalcheck = 0;

	# Get the admins Config section for page customization

	my @data = ();
	if (open(FILE, "<$datadir/gallery/$info{'username'}/config.dat")) {
		hold(FILE);
		chomp(@data = <FILE>);
		release(FILE);
		close(FILE);
	}
	for ($c = 0; $c < @data; $c++) {
		$data[$c] =~ s/[\n\r]//g;
	}
	# End getting the config.dat file

	# adding in the "default" number of pics to show on a page

	if (($data[0] ne "0") && (!$data[0])) { $data[0] = 0; }
	if (($data[2] ne "0") && (!$data[2])) { $data[2] = 6; }
	if (($data[3] ne "0") && (!$data[3])) { $data[3] = 0; }

	foreach $countthefiles (@sortedfiles) {
		($name, $ext1) = split(/\./, $countthefiles);

		if ($ext1 eq "jpg" || $ext1 eq "JPG" || $ext1 eq "GIF" || $ext1 eq "gif" || $ext1 eq "png" || $ext1 eq "PNG") {
			if ($countthefiles =~ /_th/) { next; } else { $totalit++; }
		}
	}

	print qq~<h2>$userdata[1]$gal{'010'} $gal{'001'}</h2>
$totalit $gal{'011'} $userdata[1]$gal{'010'} $gal{'012'}<br>
~;

	if ($username ne $anonuser) { # send im link only for members - Jos
		print qq~[<a href="$scripturl/$cgi?action=imsend&amp;to=$info{'username'}"> $gal{'013'} $userdata[1] $gal{'063'}</a> ]&nbsp;~;
	}

	if ($data[3] eq "1") {
		print qq~[ <a href="$scripturl/$cgi?action=gallery&amp;op=galfeedback&amp;username=$info{'username'}">$gal{'014'}</a> ]~;
	}
	print qq~<br>
<br>
<table align="center" width="98%" cellpadding="3" cellspacing="0">
<tr>
~;

	use lib "$sourcedir";
	use Image::Size;

	foreach $sortedfiles (@sortedfiles) {

		($name, $ext) = split(/\./, $sortedfiles);

		if ($name =~ /_th/) { next; }

		if ($ext eq "jpg" || $ext eq "JPG" || $ext eq "GIF" || $ext eq "gif" || $ext eq "png" || $ext eq "PNG") {
			$howmany++;

			if (!$info{'num'}) {

				$imagename = "$imagesdir/memberpics/$info{'username'}/$sortedfiles";
				($x, $y) = imgsize($imagename);

				my $width = "";
				my $height = "";
				if ($x > $y) {
					if ($x > 150) { $width = " width=\"150\""; }
				} else {
					if ($y > 150) { $height = " height=\"150\""; }
				}

#				if ($empty ge "$data[2]") {next;}
# 27 Aug 2006:
				if ($empty >= $data[2]) {next;}
				$empty++;
				$datatocheck = $info{'username'};
				checkforth("$sortedfiles", "$datatocheck");

				if ($th_isthere eq "1") {
					# correct incorrect thumbnail display - sburg
					($x_th, $y_th) = imgsize($thumbnail);
					if ($x_th > $y_th) {
						if ($x_th > 150) { $th_width = " width=\"150\""; }
					} else {
						if ($y_th > 150) { $th_height = " height=\"150\""; }
					}
					print qq~<td align="center" width="33%" class="gallery"><a href="$imagesurl/memberpics/$info{'username'}/$sortedfiles" target="_blank"><img
 src="$imagesurl/memberpics/$info{'username'}/$thumbnail"$th_width$th_height border="0" alt=""></a></td>
~;
					# End of changes

				}

				elsif (!$width && !$height) {
					print qq~<td align="center" width="33%" class="gallery"><img
 src="$imagesurl/memberpics/$info{'username'}/$sortedfiles" alt=""></td>
~;

				} else {
					print qq~<td align="center" width="33%" class="gallery"><a
 href="$imagesurl/memberpics/$info{'username'}/$sortedfiles" target="_blank"><img
 src="$imagesurl/memberpics/$info{'username'}/$sortedfiles"$width$height alt=""></a></td>
~;
				}

#				if ($howmany ge "3") {
# 27 Aug 2006:
				if ($howmany >= 3) {
					print qq~</tr>
<tr>
~;
					$howmany = 0;
				}
#				if ($empty ge "$data[2]" && $empty < $totalit) {
# 27 Aug 2006:
				if ($empty >= $data[2] && $empty < $totalit) {
					print qq~</tr>
<tr>
<td><a href="$scripturl/$cgi?action=gallery&amp;op=galview&amp;username=$info{'username'}&amp;num=1">$gal{'021'}</a></td>
~;
				}

				if ($empty >= $totalit) { next; }
			} else {

				$wheretostart = $info{'num'} * $data[2];

				if ($checking < $wheretostart) { $checking++; next; }
				else {
					$wheretoend = $wheretostart + $data[2];
					if ($checking >= $wheretoend) { next; }
					else {
						$checking++;
						$empty++;
						$finalcheck++;

						$datatocheck = $info{'username'};
						checkforth("$sortedfiles", "$datatocheck");

						if ($th_isthere eq "1") {
							my $th_width = "";
							my $th_height = "";
							($x_th, $y_th) = imgsize($thumbnail);
							if ($x_th > $y_th) {
								if ($x_th > 150) { $th_width = " width=\"150\""; }
							} else {
								if ($y_th > 150) { $th_height = " height=\"150\""; }
							}
							print qq~<td align="center" width="33%" class="gallery"><a href="$imagesurl/memberpics/$info{'username'}/$sortedfiles" target="_blank"><img
 src="$imagesurl/memberpics/$info{'username'}/$thumbnail"$th_width$th_height border="0" alt=""></a></td>
~;
						} else {
							my $width = "";
							my $height = "";
							$imagename = "$imagesdir/memberpics/$info{'username'}/$sortedfiles";
							($x, $y) = imgsize($imagename);
							if ($x > $y) {
								if ($x > 150) { $width = " width=\"150\""; }
							} else {
								if ($y > 150) { $height = " height=\"150\""; }
							}

							if ($width || $height) {
								print qq~<td align="center" width="33%" class="gallery"><a href="$imagesurl/memberpics/$info{'username'}/$sortedfiles" target="_blank"><img
 src="$imagesurl/memberpics/$info{'username'}/$sortedfiles"$width$height border="0" alt=""></a></td>
~;
							} else {
								print qq~<td align="center" width="33%" class="gallery"><img
 src="$imagesurl/memberpics/$info{'username'}/$sortedfiles" border="0" alt=""></td>
~;
							}
						}

						if ($empty >= 3) {
							print qq~</tr>
<tr>
~;
							$empty = 0;
						}
						if ($checking >= $wheretoend && $checking < $totalit) {
							$comefrom = $info{'num'} - 1;
							$goto = $info{'num'} + 1;
							print qq~</tr>
<tr>
<td><a href="$scripturl/$cgi?action=gallery&amp;op=galview&amp;username=$info{'username'}&amp;num=$comefrom">$gal{'020'}</a></td><td><a href="$scripturl/$cgi?action=gallery&amp;op=galview&amp;username=$info{'username'}&amp;num=$goto">$gal{'021'}</a></td>
~;
						}
						if ($checking >= $totalit) {
							$comefrom = $info{'num'} - 1;
							print qq~</tr>
<tr>
<td><a href="$scripturl/$cgi?action=gallery&amp;op=galview&amp;username=$info{'username'}&amp;num=$comefrom">$gal{'020'}</a></td>
~;
						}
					}
				}
			}
		}
	}
	print qq~</tr>
</table>
~;

	# Commenting Section

	if ($data[0] eq "1") { &showcomments(); }

	if ($info{'username'} eq "$username") {
		print qq~<table>
<tr>
<td><a href="$scripturl/$cgi?action=gallery&amp;op=galadmin&amp;username=$info{'username'}">$gal{'016'}</a></td>
</tr>
</table>
<table>
<tr>
<td>&nbsp;</td>
</tr>
<tr>
<td>$gal{'017'} <a href="$scripturl/$cgi?action=gallery&amp;op=galview&amp;username=$username">$scripturl/$cgi?action=gallery&amp;op=galview&amp;username=$username</a></td>
</tr>
</table>
~;
	}

	if ($info{'username'} ne "$username") {
		print qq~<table align="center">
<tr align="center">
<td><br><br><center><a href="$scripturl/$cgi?action=gallery">$gal{'018'}</a><br>
<br>
</center></td>
</tr>
</table>
~;
	}

	print_bottom();
	exit;

}

###______________________________________________________________________________
###
### Sub Admin
### Administrating the Gallery
### Description:
###		This section allows the owner of the gallery to change / upload / delete
###		and get stats on their particular gallery
###
### Features: Uploading Files, Uploading Thumbnails, Allow Commenting, 
###		  Get Notification on a Comment Left, Stats on Times Viewed.
###______________________________________________________________________________
###

###########
sub admin {
###########

	if ($info{'username'} eq "") { error("$gal{'007'}"); }
	if ($info{'username'} eq "$anonuser") { error("$gal{'008'}"); }
	if ($info{'username'} ne "$username") { error("$gal{'071'}"); }

	$navbar = "$btn{'014'} <a href=\"$scripturl/$cgi?action=gallery\">$gal{'001'}</a> $btn{'014'} <a href=\"$scripturl/$cgi?action=gallery&op=galview&username=$username\">$info{'username'}</a> $btn{'014'} $gal{'015'}";
	print_top();

	# The Upload Javascript new Page Popup

	if ($info{'username'} eq "$username") {
		print qq~<script language="javascript" type="text/javascript">
<!--
function upload() {
window.open("$scripturl/$cgi?action=gallery&amp;op=galuploadpicture","","width=300,height=150,scrollbars")
}
// -->
</script>
~;
	}

	print qq~<table>
<tr>
<td>$gal{'019'}</td><td>&nbsp;$msg{'058'}?&nbsp;</td>
<td>&nbsp;$gal{'022'}&nbsp;</td>
<td>$gal{'023'}</td>
</tr>
~;

	opendir (DIR, "$imagesdir/memberpics/$username");
	@files = readdir(DIR);
	closedir (DIR);
	@files = grep(/./,@files);
	@sortedfiles = sort(@files);

	foreach $sortedfiles (@sortedfiles) {
		($name, $ext) = split(/\./, $sortedfiles);

		if ($ext eq "jpg" || $ext eq "JPG" || $ext eq "GIF" || $ext eq "gif" || $ext eq "png" || $ext eq "PNG") {

			if ($sortedfiles =~ /_th/) {
				print qq~<tr>
<td>$sortedfiles</td>
<td><a href="$scripturl/$cgi?action=gallery&amp;op=galdelete&amp;picture=$sortedfiles&amp;username=$username">$msg{'058'}?</a></td>
<td>$gal{'079'}</td>
</tr>
~;
			} else {
				$showthumbnail = addth($sortedfiles);
				print qq~<tr>
<td>$sortedfiles</td>
<td><a href="$scripturl/$cgi?action=gallery&amp;op=galdelete&amp;picture=$sortedfiles&amp;username=$username">$msg{'058'}?</a></td>
<td>NO</td>
<td>$showthumbnail</td>
</tr>
~;
			}
		}
	}

	print qq~<table>
<tr>
<td>&nbsp;</td>
<td class="formstextnormal" valign="top"><a href="javascript:upload()">$msg{'598'}</a></td>
</tr>
</table>
~;

	# Checking for how many views

	if (open(VIEWS, "<$datadir/gallery/$info{'username'}/views.dat")) {
		hold(VIEWS);
		chomp(@numofviews = <VIEWS>);
	} else {
		open(VIEWS, ">$datadir/gallery/$info{'username'}/views.dat");
	}
	close(VIEWS);

	if (!defined $numofviews[0]) { $numofviews[0] = 0; }
		$numofviews[0] =~ s/[\n\r]//g;

		print qq~<table align="center">
<tr>
<td align="center"><br>
<hr>
<br>
$gal{'024'} <b>$numofviews[0] $gal{'025'}</b></td>
</tr>
<tr>
<td>&nbsp;<!-- Written by M. Carter Brown --></td>
</tr>
</table>
~;

	# Seeing if allowing commenting is on or off

	if (open(FILE, "<$datadir/gallery/$username/config.dat")) {
		hold(FILE);
		chomp(@data = <FILE>);
		release(FILE);
		close(FILE);

		for ($c = 0; $c < @data; $c++) {
			$data[$c] =~ s/[\n\r]//g;
		}
	} else {
		$data[0] = '';
		$data[1] = '';
		$data[2] = 6;
		$data[3] = '';
	}

	# User administration - Choosing how many pictures to show on a page
	# Default is 6

	print qq~<form action="$scripturl/$cgi?action=gallery&amp;op=galmyadmin&amp;username=$username" method="post">
<table border="0" width="100%" cellpading="0" cellspacing="0">
<tr>
<td>$gal{'026'}<br>
<input type="text" class="textinput" name="numtoshow" value="$data[2]" size="2"></td>
</tr>
<tr>
<td><input type="submit" class="button" value="$gal{'027'}"></td>
</tr>
</table>
</form>
~;

	# Allow Commenting On / Off

	if ($data[0] eq "" || $data[0] eq "0") {
		print qq~<table>
<tr>
<td>&nbsp;</td>
</tr>
<tr>
<td><a href="$scripturl/$cgi?action=gallery&amp;op=galallowcomments&amp;username=$username">$gal{'028'} $gal{'029'}</a> $gal{'031'}</td>
</tr>
</table>
~;
	}
	if ($data[0] eq "1") {
		print qq~<table>
<tr>
<td>&nbsp;</td>
</tr>
<tr>
<td><a href="$scripturl/$cgi?action=gallery&amp;op=galallowcomments&amp;username=$username">$gal{'028'} $gal{'030'}</a> $gal{'031'}</td>
</tr>
</table>
~;
	}

	# Allow Feedback Module On / Off

	if ($data[3] eq "" || $data[3] eq "0") {
		print qq~<table>
<tr>
<td><a href="$scripturl/$cgi?action=gallery&amp;op=galallowfeedback&amp;username=$username">$gal{'032'} $gal{'029'}</a> $gal{'031'}</td>
</tr>
</table>
~;
	}
	if ($data[3] eq "1") {
		print qq~<table>
<tr>
<td><a href="$scripturl/$cgi?action=gallery&amp;op=galallowfeedback&amp;username=$username">$gal{'032'} $gal{'030'}</a> $gal{'031'}</td>
</tr>
</table>
~;
	}

	# Allow Notification On / Off

	if ($data[1] eq "" || $data[1] eq "0") {
		print qq~<table>
<tr>
<td><a href="$scripturl/$cgi?action=gallery&amp;op=galallownotification&amp;username=$username">$gal{'033'} $gal{'029'}</a> $gal{'031'}</td>
</tr>
</table>
~;
	}
	if ($data[1] eq "1") {
		print qq~<table>
<tr>
<td><a href="$scripturl/$cgi?action=gallery&amp;op=galallownotification&amp;username=$username">$gal{'033'} $gal{'030'}</a> $gal{'031'}</td>
</tr>
</table>
~;
	}

	# Admin ONLY allow create gallery

	if ($username eq "admin") {

		print qq~<table>
<tr>
<td><a href="$scripturl/$cgi?action=gallery&amp;op=galallowprivate">$gal{'034'}</a></td>
</tr>
<tr>
<td><a href="$scripturl/$cgi?action=gallery&amp;op=galdeleteempty">$gal{'035'}</a></td>
</tr>
<tr>
<td>&nbsp;</td>
</tr>
</table>
~;

	}

	# Thumbnail info section

	print qq~<table>
<tr>
<td>&nbsp;</td>
</tr>
<tr>
<td>$gal{'036'}<br>
<br>$gal{'037'}</td>
</tr>
</table>
<table>
<tr>
<td>&nbsp;</td>
</tr>
<tr>
<td>$gal{'017'} <a href="$scripturl/$cgi?action=gallery&amp;op=galview&amp;username=$username">$scripturl/$cgi?action=gallery&amp;op=galview&amp;username=$username</a></td>
</tr>
<tr>
<td>$gal{'038'}</td>
</tr>
<tr>
<td>\[url=$scripturl/$cgi?action=gallery&amp;op=galview&amp;username=$username\]$gal{'040'}\[/url\]</td>
</tr>
~;

	if ($data[3] eq "1") {
		print qq~<tr>
<td><b>$gal{'039'}</b>: $gal{'041'} \[url=$scripturl/$cgi?action=gallery&amp;op=galfeedback&amp;username=$username\]$gal{'014'}\[/url\]</td>
</tr>
~;
	}

	print qq~</table>~;

	print_bottom();
	exit;

}

################
sub markasread {
################

	open(FILE, "<$datadir/gallery/gallerylist.dat");
	hold(FILE);
	chomp(@data = <FILE>);
	release(FILE);
	close(FILE);

	@sortedfiles = sort(@data);

	foreach $sortedfiles (@sortedfiles) {
		$sortedfiles =~ s/[\n\r]//g;
		($dummy, $name, $dummy) = split(/\|/, $sortedfiles);
		writelog("$name");
	}

	print "Location: $scripturl/$cgi?action=gallery\n\n";

}

##############
sub clearold {
##############

	if ($username ne 'admin') { error("$gal{'071'}"); }

	$navbar = "$btn{'014'} $gal{'001'} $btn{'014'} $gal{'081'}";
	print_top();

	if ($galleryage < 7) { print qq~$gal{'084'}~; }

	# walk each member directory...
	my $count = 0;
	foreach my $dir (<$imagesdir/memberpics/*>) {
		next unless -d $dir;	# only directories
		next if $dir =~ /^\./;	# not hidden directories
		# now clear out old pictures
		foreach my $file (<$dir/*>) {
			my $age = int(-M $file);
			if (-M $file > $galleryage) {
				print qq~$gal{'085'} $file ($age)<br>~;
				$count++;
				unlink $file;
			}
		}
	}

	print qq~<br>$gal{'082'} $galleryage $gal{'083'}<br>
$gal{'086'}: $count
~;
	print_bottom();
	exit;
}

############
sub delete {
############

	if ($info{'username'} eq "") { error("$gal{'007'}"); }
	if ($info{'username'} eq "$anonuser") { error("$gal{'008'}"); }
	if ($info{'username'} ne "$username") { error("$gal{'071'}"); }

	unlink "$imagesdir/memberpics/$username/$info{'picture'}";

	$navbar = "$btn{'014'} $gal{'001'} $btn{'014'} $info{'username'} $btn{'014'} $gal{'015'}";
	print_top();

	print qq~&nbsp; $info{'picture'} $gal{'042'}<br>
<br>
<br>
<a href="$scripturl/$cgi?action=gallery&amp;op=galadmin&amp;username=$info{'username'}">$gal{'043'}</a><br>
~;

	print_bottom();
	exit;

}

################
sub notcreated {
################

	$navbar = " $btn{'014'} $gal{'001'} $btn{'014'} $gal{'044'}"; 
	print_top();

	print qq~The user gallery has not been created!!!<br>
<br>
<a href="$scripturl/$cgi?action=gallery&amp;op=galcreategallery">$gal{'045'}</a><br>
<br>$gal{'046'} $gal{'047'} <a href="$scripturl/$cgi">$gal{'048'}</a> $gal{'049'}<br>
~;

	print_bottom();
	exit;

}

##################
sub allowprivate {
##################

	if ($username ne "admin") { error("$msg{'630'}"); } # the only Stan message

	open(FILE, ">$datadir/gallery/private.file");
	hold(FILE);
	print FILE "1";
	release(FILE);
	close(FILE);

	open(DATA, "$datadir/gallery/private.file");
	hold(DATA);
	chomp(@db = <DATA>);
	release(DATA);
	close(DATA);

	if ($db[0] eq "1") {
		$navbar = " $btn{'014'} $gal{'001'} $btn{'014'} $gal{'050'}";
		print_top();

		print qq~$gal{'051'} <br>
$gal{'052'} $scripturl/$cgi?action=gallery&amp;op=galcreateprivate<br>
~;

		print_bottom();
		exit;
	}
	else { error("$gal{'053'}"); }

	exit;

}

###################
sub createprivate {
###################

	if ($username eq "$anonuser") { error("$gal{'054'}") }

	open(FILE, "$datadir/gallery/private.file") || error("$gal{'072'}");
	close(FILE);
	$navbar = " $btn{'014'} $gal{'001'} $btn{'014'} $gal{'050'}"; 
	print_top();

	mkdir("$imagesdir/memberpics/$username",0755); # corrected mkdir on some Linux Systems - sburg
	print qq~<br>$gal{'055'}<br>$gal{'047'} <a href="$scripturl/$cgi?action=gallery&amp;op=galview&amp;username=$username">$gal{'048'}</a> $gal{'056'}<br>~;

	print_bottom();

	unlink("$datadir/gallery/private.file");
	exit;

}

###################
sub creategallery {
###################

	if ($username eq "$anonuser") { error("$gal{'054'}") }

	$navbar = " $btn{'014'} $gal{'001'} $btn{'014'} $gal{'050'}"; 
	print_top();

	mkdir("$imagesdir/memberpics/$username",0755); # corrected mkdir on some Linux Systems - sburg
	mkdir("$datadir/gallery/$username",0755);
	open(FILE, ">$datadir/gallery/$username/lastupdated.dat");
	close(FILE);

	print qq~<br>$gal{'055'}<br>$gal{'047'} <a href="$scripturl/$cgi?action=gallery&amp;op=galview&amp;username=$username">$gal{'048'}</a> $gal{'056'}<br>~;

	print_bottom();
	exit;
}

###############
sub nogallery {
###############

	$navbar = " $btn{'014'} $gal{'001'} $btn{'014'} $gal{'057'}"; 
	print_top();
	print qq~<br>$gal{'058'}<br><br>~;
	print_bottom();
	exit;

}

###################
sub uploadpicture {
###################

	if ($username eq "$anonuser") { error("$gal{'054'}") }
	print "Content-type: text/html\n\n";
	updateme();
	print qq~<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN">
<html>
<head>
<title>$msg{'598'}</title>
</head>
<body>
<center>
<font face="Arial" size="2">$msg{'598'}</font>
<p><form action="$scripturl/admin/galupload.cgi" method="post" enctype="multipart/form-data">
<input type="File" name="FILE1">
<p><input type="submit" class="button" value="$btn{'016'}">
</form>
</center>
</body>
</html>
~;

	exit;

}

###################
sub uploadsuccess {
###################

	print "Content-type: text/html\n\n";
	updatedme();
	$thefile = $info{'yourfile'};
	print qq~<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN">
<html>
<head>
<title>Success</title>
</head>
<body>
<center><font face="Arial" size="2">$msg{'599'}</font><br>
$msg{'600'} $thefile $msg{'601'}<br>
<br><a href="javascript:window.close()">$msg{'603'}</a></center>
</body>
</html>
~;

	exit;

}

################
sub uploadfail {
################

	print "Content-type: text/html\n\n";
	$thefile = $info{'yourfile'};
	print qq~<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN">
<html>
<head>
<title>$msg{'604'}!</title>
</head>
<body>
<center><font face="Arial" size="2">$msg{'604'}!</font><br>
$thefile - $msg{'604'}<br>$gal{'059'} $maxuploadsize<br><a
 href="javascript:window.close()">$msg{'603'}</a></center>
</body>
</html>
~;
	exit;

}

###########
sub addth {
###########

	my $text = shift;
	$text =~ s~\.~_th\.~g;
	return $text;
}

##############
sub removeth {
##############

	my $text = shift;
	$text =~ s~_th\.~\.~g;
	return $text;
}

################
sub checkforth {
################

	my ($fileimchecking, $theusername) = @_;

	$th_isthere = "";

	opendir (FILEDIR, "$imagesdir/memberpics/$theusername");
	@thefiles = readdir(FILEDIR);
	closedir (FILEDIR);
	@thefiles = grep(/\./,@thefiles);

	foreach $thefiles (@thefiles) {

		if ($thefiles =~ /_th/) { 
			$myfirstcheck = addth($fileimchecking);
			if ($myfirstcheck eq "$thefiles") {
				$th_isthere = 1;
				$thumbnail = "$thefiles";
				return $thumbnail;
			}

			if ($th_isthere ne "1") {
				$casesensitive = lc($fileimchecking);
				$myfinalcheck = addth($casesensitive);
				if ($myfinalcheck eq "$thefiles") {
					$th_isthere = 1;
					$thumbnail = "$thefiles";
					return $thumbnail;
				}
				else { next; }
			}
		}
	}

}

##################
sub showcomments {
##################

	print qq~<table border="0" cellpadding="1" cellspacing="3" width="100%">
<tr>
<td colspan="2" align="center" class="commenttitleback">$msg{'023'}</td>
</tr>
<tr>
<td colspan="2" align="center" class="newssubtitle">$msg{'159'}</td>
</tr>
~;

	my @data = ();
	if (open(FILE, "<$datadir/gallery/$info{'username'}/comments.dat")) {
		hold(FILE);
		chomp(@data = <FILE>);
	} else {
		open(FILE, ">$datadir/gallery/$info{'username'}/comments.dat");
	}
	close(FILE);

	$thecount = 0;

	foreach $data (@data) {
		$data =~ s/[\n\r]//g;
		($number, $comment, $member, $dateleft) = split(/\|/, $data);

		$showcomment = showhtml($comment);

		print qq~<tr>
<td><small>$gal{'060'}</small> $member <small>$msg{'048'}: $dateleft</small> <br>
$showcomment</td>
</tr>
<tr>
<td>~;

		if ($info{'username'} eq "$username" || $username eq "admin") { 
			print qq~[ <a href="$scripturl/$cgi?action=gallery&amp;op=galdeletecomment&amp;username=$info{'username'}&amp;num=$number">$gal{'062'}</a> ]<br>~;
		}

		print qq~<hr></td>
</tr>
~;
	}

	if ($username ne "$anonuser") {
		print qq~</table>
<form action="$scripturl/$cgi?action=gallery&amp;op=galleavecomment" method="post">
<table>
<tr>
<td class="formstextnormal" valign="top">$msg{'023'}</td>
<td><textarea name="message" rows="5" cols="40"></textarea></td>
</tr>
<tr>
<td colspan="2"><input type="hidden" name="username" value="$info{'username'}">
<input type="submit" class="button" value="$btn{'012'}">
<input type="reset" class="button" value="$btn{'009'}"></td>
</tr>
</table>
</form>
~;
	}

}

##################
sub leavecomment {
##################

	if ($username eq "$anonuser") { error("$gal{'054'}"); }

	open(FILE, "<$datadir/gallery/$input{'username'}/comments.dat");
	hold(FILE);
	chomp(@data = <FILE>);
	release(FILE);
	close(FILE);

	$thecount = 0;

	foreach $data (@data) {
		$thecount++;
	}

	$convertedmessage = previewstrip($input{'message'});
	$convertedmessage =~ s/\n/<br>/g; # was in htmltotext here

	open(FILE, ">>$datadir/gallery/$input{'username'}/comments.dat");
	hold(FILE);
	print FILE "$thecount|$convertedmessage|$username|$date\n";
	release(FILE);
	close(FILE);

	open(FILE, "<$datadir/gallery/$input{'username'}/config.dat");
	hold(FILE);
	chomp(@data = <FILE>);
	release(FILE);
	close(FILE);

	for ($c = 0; $c < @data; $c++) {
		$data[$c] =~ s/[\n\r]//g;
	}

	if ($data[1] eq "1") { &notification("$input{'username'}"); }

	print "Location: $scripturl/$cgi?action=gallery&amp;op=galview&amp;username=$input{'username'}\n\n";

}

###################
sub deletecomment {
###################

	if ($info{'username'} eq "") { error("$gal{'007'}"); }
	if ($info{'username'} eq "$anonuser") { error("$gal{'008'}"); }

	if ($info{'username'} eq "$username" || $username eq "admin") {

		open(FILE, "<$datadir/gallery/$info{'username'}/comments.dat");
		hold(FILE);
		chomp(@data = <FILE>);
		release(FILE);
		close(FILE);

		$thecount = 0;

		open(DB, ">$datadir/gallery/$info{'username'}/comments.dat");
		hold(DB);

		foreach $data (@data) {
			$data =~ s/[\n\r]//g;
			($number, $comment, $member, $dateposted) = split(/\|/, $data);

			if ($info{'num'} eq "$number") { next; }
			else { print DB "$thecount|$comment|$member|$dateposted\n"; $thecount++;}

		}

		release(DB);
		close(DB);

		print "Location: $scripturl/$cgi?action=gallery&amp;op=galview&amp;username=$info{'username'}\n\n";

	}
	else { error("$gal{'071'}"); }

}

####################
sub deletefeedback {
####################

	if ($info{'username'} eq "") { error("$gal{'073'}"); }
	if ($username ne "admin") { error("$gal{'074'}"); }

	if ($username eq "admin") {
		open(FILE, "<$datadir/gallery/$info{'username'}/feedback.dat");
		hold(FILE);
		chomp(@data = <FILE>);
		release(FILE);
		close(FILE);

		$thecount = 0;

		open(DB, ">$datadir/gallery/$info{'username'}/feedback.dat");
		hold(DB);

		foreach $data (@data) {
			$data =~ s/[\n\r]//g;
			($number, $comment, $member, $dateposted) = split(/\|/, $data);

			if ($info{'num'} eq "$number") { next; }
			else { print DB "$thecount|$comment|$member|$dateposted\n"; $thecount++; }
		}

		release(DB);
		close(DB);

		print "Location: $scripturl/$cgi?action=gallery&amp;op=galfeedback&amp;username=$info{'username'}\n\n";
	}

	else { error("$gal{'071'}"); }

}

###______________________________________________________________________________
###
### Sub Deleteempty
###
### This code will read through all the member directories and remove all the members
### that no longer exist or never created the gallery
###______________________________________________________________________________
###

#################
sub deleteempty {
#################

	if ($username ne "admin") { error("$gal{'071'}"); }

	$navbar = " $btn{'014'} $gal{'001'} $btn{'014'} $gal{'015'}"; 
	print_top();

	open(FILE, "<$datadir/gallery/gallerylist.dat");
	hold(FILE);
	chomp(@data = <FILE>);
	release(FILE);
	close(FILE);

	@sortedfiles = sort(@data);

	foreach $sortedfiles (@sortedfiles) {
		($lcname, $regname, $updateddate) = split(/\|/, $sortedfiles);

		opendir (DIR, "$imagesdir/memberpics/$regname");
		@pics = readdir(DIR);
		closedir (DIR);
		@pics = grep(/\./,@pics);
		@sortedpics = sort(@pics);
		$foundit = 0;
		foreach $sortedpics (@sortedpics) {
			$sortedpics =~ s/[\n\r]//g;
			($dummy,$jpgfile) = split(/\./,$sortedpics);
			$checkit = lc($jpgfile);

			if ($checkit eq "jpg" || $checkit eq "gif") { $foundit++; }
		}

		# Corrected galdeletegallery to galdelete - sburg
		if ($foundit eq 0) {
			print qq~$regname - $gal{'079'} - <a href="$scripturl/$cgi?action=gallery&amp;op=galview&amp;username=$regname">Check It</a> - <a href="$scripturl/$cgi?action=gallery&amp;op=deletegallery&amp;username=$regname">$gal{'078'}</a><br>
~;
		}
		if ($foundit gt 0) {
			print qq~$regname - $gal{'080'} - $foundit<br>~;
		}
	}

	print_bottom();
	exit;

}

###################
sub deletegallery {
###################

	if ($username ne "admin") { error("$gal{'075'}"); }

	$navbar = "$btn{'014'} $gal{'001'} $btn{'014'} $msg{'058'}"; 
	print_top();

	open(FILE, "<$datadir/gallery/gallerylist.dat");
	hold(FILE);
	chomp(@data = <FILE>);
	release(FILE);
	close(FILE);

	open(DB, ">$datadir/gallery/gallerylist.dat");
	hold(DB);

	@sortedfiles = sort(@data);

	foreach $sortedfiles (@sortedfiles) {

		($lcname, $regname, $updateddate) = split(/\|/, $sortedfiles);

		# Added basic logic to delete files/directories of an empty gallery - sburg
		if ($info{'username'} ne "$regname") { print DB "$lcname|$regname|$updateddate\n"; }
		else { print DB ""; 
			opendir (MB, "$imagesdir/memberpics/$regname");
			@mem_files = readdir(MB);
			closedir (MB);
				foreach $mem_files (@mem_files) { 
					if ( ! -d $mem_files ) {
					unlink ("$imagesdir/memberpics/$regname/$mem_files") };
				rmdir ("$imagesdir/memberpics/$regname"); 
				}
			opendir (MB, "$datadir/gallery/$regname");
			@mem_files = readdir(MB);
			closedir (MB);
				foreach $mem_files (@mem_files) { 
					if ( ! -d $mem_files ) {
					unlink ("$datadir/gallery/$regname/$mem_files") };
			rmdir ("$datadir/gallery/$regname") ; 
			}
		}
	}
	
	release(DB);
	close(DB);

	print qq~$info{'username'}$gal{'010'} $gal{'064'}<br><br>
$gal{'047'} <a href="$scripturl/$cgi?action=gallery&amp;op=galdeleteempty">$gal{'048'}</a> $gal{'065'}<br><br>~;

	print_bottom();
	exit;

}

###______________________________________________________________________________
###
### sub Feedback
### Allowing the user to leave feedback
###
### this is the actual section where you read and leave feedback
###______________________________________________________________________________
###

##############
sub feedback {
##############

	if ($info{'username'} eq "") { error("$gal{'071'}"); }
	$navbar = "$btn{'014'} $gal{'001'} $btn{'014'} $gal{'066'}"; 
	print_top();

	open(FILE, "<$datadir/gallery/$username/config.dat");
	hold(FILE);
	chomp(@data = <FILE>);
	release(FILE);
	close(FILE);

	for ($c = 0; $c < @data; $c++) {
		$data[$c] =~ s/[\n\r]//g;
	}

	open(FILE, "<$memberdir/$info{'username'}.dat") || error("$info{'username'} $gal{'009'}");
	hold(FILE);
	chomp(@userdata = <FILE>);
	release(FILE);
	close(FILE);

	$userdata[1] =~ s/[\n\r]//g;

	if ($data[3] ne "1") {
		print qq~$userdata[1]$gal{'010'} $gal{'076'}~;
		print_bottom();
		exit;
	} else {
		print qq~<table border="0" cellpadding="1" cellspacing="3" width="100%">
<tr>
<td colspan="2" align="center" class="commenttitleback">$userdata[1]$gal{'010'} $gal{'066'}:</td>
</tr>
<tr>
<td colspan="2" align="center" class="newssubtitle">$msg{'159'}</td>
</tr>
~;

		my @data = ();
		if (open(FILE, "<$datadir/gallery/$info{'username'}/feedback.dat")) {
			hold(FILE);
			chomp(@data = <FILE>);
		} else {
			open(FILE, ">$datadir/gallery/$info{'username'}/feedback.dat");
		}
		close(FILE);

		$thecount = 0;

		foreach $data (@data) {
			$data =~ s/[\n\r]//g;
			($number, $comment, $member, $dateleft) = split(/\|/, $data);

			$showcomment = showhtml($comment);

			print qq~<tr>
<td><small>$gal{'060'}</small> $member <small>$msg{'048'}: $dateleft</small> <br>$showcomment</td>
</tr>
<tr>
<td>~;

			if ($username eq "admin") { 
				print qq~[ <a href="$scripturl/$cgi?action=gallery&amp;op=galdeletefeedback&amp;username=$info{'username'}&amp;num=$number">$gal{'062'}</a> ]<br>~;
			}

			print qq~<hr></td>
</tr>
~;

		}

		if ($username ne "$anonuser") {
			print qq~</table>
<form action="$scripturl/$cgi?action=gallery&amp;op=galfeedback2" method="post">
<table>
<tr>
<td class="formstextnormal" valign="top">$msg{'023'}</td>
<td><textarea name="message" rows="5" cols="40"></textarea></td>
</tr>
<tr>
<td colspan="2"><input type="hidden" name="username" value="$info{'username'}">
<input type="submit" class="button" value="$btn{'012'}">
<input type="reset" class="button" value="$btn{'009'}"></td>
</tr>
</table>
</form>
~;
		}
	}

	print_bottom();
	exit;

}

###______________________________________________________________________________
###
### sub Feedback2
### Allowing the user to leave feed back!
###______________________________________________________________________________
###

###############
sub feedback2 {
###############

	if ($username eq "$anonuser") { error("$gal{'054'}"); }
	if ($input{'username'} eq "") { error("$gal{'077'}"); }

	open(FILE, "<$datadir/gallery/$input{'username'}/feedback.dat");
	hold(FILE);
	chomp(@data = <FILE>);
	release(FILE);
	close(FILE);

	$thecount = 0;

	foreach $data (@data) {
		$data =~ s/[\n\r]//g;
		$thecount++;
	}

	$convertedmessage = previewstrip($input{'message'});
	$convertedmessage =~ s/\n/<br>/g; # was in htmltotext here

	open(FILE, ">>$datadir/gallery/$input{'username'}/feedback.dat");
	hold(FILE);
	print FILE "$thecount|$convertedmessage|$username|$date\n";
	release(FILE);
	close(FILE);

	open(FILE, "<$datadir/gallery/$input{'username'}/config.dat");
	hold(FILE);
	chomp(@data = <FILE>);
	release(FILE);
	close(FILE);

	for ($c = 0; $c < @data; $c++) {
		$data[$c] =~ s/[\n\r]//g;
	}

	if ($data[1] eq "1") { &notificationfeedback("$input{'username'}"); }

	print "Location: $scripturl/$cgi?action=gallery&amp;op=galfeedback&amp;username=$input{'username'}\n\n";

}

###______________________________________________________________________________
###
### Sub MyAdmin
### Editing the User Config File
### Description:
###		Currently only edits the $data[2] line, but can be used in conjunction
###		with the current <form> to edit and add more customizable info.
###______________________________________________________________________________
###

#############
sub myadmin {
#############

	if ($info{'username'} eq "") { error("$gal{'007'}"); }
	if ($info{'username'} eq "$anonuser") { error("$gal{'008'}"); }
	if ($info{'username'} ne "$username") { error("$gal{'071'}"); }

	my @data = ();
	if (open(FILE, "<$datadir/gallery/$username/config.dat")) {
		hold(FILE);
		chomp(@data = <FILE>);
	} else {
		open(FILE, ">$datadir/gallery/$username/config.dat");
	}
	close(FILE);

	for ($c = 0; $c < @data; $c++) {
		$data[$c] =~ s/[\n\r]//g;
	}

	if (($data[0] ne "0") && (!$data[0])) { $data[0] = 0; }
	if (($data[1] ne "0") && (!$data[1])) { $data[1] = 0; }
	if (($data[3] ne "0") && (!$data[3])) { $data[3] = 0; }
	if ((!$input{'numtoshow'}) && ($input{'numtoshow'} ne "0")) {
		$input{'numtoshow'} = 6;
	}

	open(FILE, ">$datadir/gallery/$username/config.dat");
	hold(FILE);

	print FILE "$data[0]\n";
	print FILE "$data[1]\n";
	print FILE "$input{'numtoshow'}\n";
	print FILE "$data[3]\n";

	close(FILE);

	print "Location: $scripturl/$cgi?action=gallery&amp;op=galadmin&amp;username=$info{'username'}\n\n";

}

###################
sub allowcomments {
###################

	if ($info{'username'} eq "") { error("$gal{'007'}"); }
	if ($info{'username'} eq "$anonuser") { error("$gal{'008'}"); }
	if ($info{'username'} ne "$username") { error("$gal{'071'}"); }

	my @data = ();
	if (open(FILE, "<$datadir/gallery/$username/config.dat")) {
		hold(FILE);
		chomp(@data = <FILE>);
	} else {
		open(FILE, ">$datadir/gallery/$username/config.dat");
	}
	close(FILE);

	for ($c = 0; $c < @data; $c++) {
		$data[$c] =~ s/[\n\r]//g;
	}

	if (($data[0] ne "0") && (!$data[0])) { $data[0] = 0; }
	if (($data[1] ne "0") && (!$data[1])) { $data[0] = 0; }
	if (($data[2] ne "0") && (!$data[2])) { $data[2] = 6; }
	if (($data[3] ne "0") && (!$data[3])) { $data[3] = 0; }

	open(FILE, ">$datadir/gallery/$username/config.dat");
	hold(FILE);

	if ($data[0] eq 1) { print FILE "0\n"; }
	else { print FILE "1\n"; }

	print FILE "$data[1]\n";
	print FILE "$data[2]\n";
	print FILE "$data[3]\n";

	close(FILE);

	print "Location: $scripturl/$cgi?action=gallery&amp;op=galadmin&amp;username=$info{'username'}\n\n";

}

###################
sub allowfeedback {
###################

	if ($info{'username'} eq "") { error("$gal{'007'}"); }
	if ($info{'username'} eq "$anonuser") { error("$gal{'008'}"); }
	if ($info{'username'} ne "$username") { error("$gal{'071'}"); }

	my @data = ();
	if (open(FILE, "<$datadir/gallery/$username/config.dat")) {
		hold(FILE);
		chomp(@data = <FILE>);
	} else {
		open(FILE, ">$datadir/gallery/$username/config.dat");
	}
	close(FILE);

	for ($c = 0; $c < @data; $c++) {
		$data[$c] =~ s/[\n\r]//g;
	}

	if (($data[0] ne "0") && (!$data[0])) { $data[0] = 0; }
	if (($data[1] ne "0") && (!$data[1])) { $data[0] = 0; }
	if (($data[2] ne "0") && (!$data[2])) { $data[2] = 6; }
	if (($data[3] ne "0") && (!$data[3])) { $data[3] = 0; }

	open(FILE, ">$datadir/gallery/$username/config.dat");
	hold(FILE);

	print FILE "$data[0]\n";
	print FILE "$data[1]\n";
	print FILE "$data[2]\n";

	if ($data[3] eq 1) { print FILE "0\n"; }
	else { print FILE "1\n"; }

	close(FILE);

	print "Location: $scripturl/$cgi?action=gallery&amp;op=galadmin&amp;username=$info{'username'}\n\n";

}

#######################
sub allownotification {
#######################

	if ($info{'username'} eq "") { error("$gal{'007'}"); }
	if ($info{'username'} eq "$anonuser") { error("$gal{'008'}"); }
	if ($info{'username'} ne "$username") { error("$gal{'071'}"); }

	my @data = ();
	if (open(FILE, "<$datadir/gallery/$username/config.dat")) {
		hold(FILE);
		chomp(@data = <FILE>);
	} else {
		open(FILE, ">$datadir/gallery/$username/config.dat");
	}
	close(FILE);

	for ($c = 0; $c < @data; $c++) {
		$data[$c] =~ s/[\n\r]//g;
	}

	if (($data[0] ne "0") && (!$data[0])) { $data[0] = 0; }
	if (($data[1] ne "0") && (!$data[1])) { $data[0] = 0; }
	if (($data[2] ne "0") && (!$data[2])) { $data[2] = 6; }
	if (($data[3] ne "0") && (!$data[3])) { $data[3] = 0; }

	open(FILE, ">$datadir/gallery/$username/config.dat");
	hold(FILE);

	print FILE "$data[0]\n";

	if ($data[1] eq 1) { print FILE "0\n"; }
	else { print FILE "1\n"; }

	print FILE "$data[2]\n";
	print FILE "$data[3]\n";

	close(FILE);

	print "Location: $scripturl/$cgi?action=gallery&amp;op=galadmin&amp;username=$info{'username'}\n\n";

}

###########
sub views {
###########

	my ($theusername) = @_;

	if (open(FILE, "<$datadir/gallery/$theusername/views.dat")) {
		hold(FILE);
		chomp(@data = <FILE>);
	} else {
		open(FILE, ">$datadir/gallery/$theusername/views.dat");
	}
	close(FILE);

	if (!$data[0]) { $data[0] = 0; }

	$data[0] =~ s/[\n\r]//g;

	$newcount = $data[0] + 1;

	open(DB, ">$datadir/gallery/$theusername/views.dat");
	hold(DB);
	print DB "$newcount\n";
	release(DB);
	close(DB);

}

##################
sub notification {
##################

	my ($theusername) = @_;

	$msgid = time;
	$imsubj = "$gal{'067'}";
	$formatmsg = "$gal{'068'}";

	open (FILE, "<$memberdir/$theusername.msg");
	hold(FILE);
	@messages = <FILE>;
	release(FILE);
	close (FILE);

	open(FILE, ">$memberdir/$theusername.msg");
	hold(FILE);
	print FILE "$theusername|$imsubj|$date|$formatmsg|$msgid\n";
	foreach $curm (@messages) { print FILE "$curm"; }
	release(FILE);
	close(FILE);

}

##########################
sub notificationfeedback {
##########################

	my ($theusername) = @_;

	$msgid = time;
	$imsubj = "$gal{'069'}";
	$formatmsg = "$gal{'070'}";

	open (FILE, "<$memberdir/$theusername.msg");
	hold(FILE);
	@messages = <FILE>;
	release(FILE);
	close (FILE);

	open(FILE, ">$memberdir/$theusername.msg");
	hold(FILE);
	print FILE "$theusername|$imsubj|$date|$formatmsg|$msgid\n";
	foreach $curm (@messages) { print FILE "$curm"; }
	release(FILE);
	close(FILE);

}

##############
sub updateme {
##############

	open(FILE, ">$datadir/gallery/$username/lastupdated.dat");
	hold(FILE);
	print FILE "$date\n";
	release(FILE);
	close(FILE);

}

if (-e "$user_lib/gallery.pl") {require "$user_lib/gallery.pl"}

1;
