#!/usr/bin/perl

###############################################################################
###############################################################################
# WebAPP NE (Network Edition) - Web Automated Perl Portal                     #
#-----------------------------------------------------------------------------#
# index.cgi                                                                   #
# v0.9.9.3.4                                                                  #
# carpout to webapperr.log file option by: Jos Brown (www.bantychick.com)     #
# requires for forum_display.pl and notify.pl at startup removed by:          #
# Jos Brown (www.bantychick.com) under consult by Ted Cambron (dsbapp.com)    #
# Gallery integration by: SimonJ and Jos                                      #
# user.cgi for custom actions by: SimonJ                                      #
#                                                                             #
# (WebAPP NE Copyright (c) WebAPP Network group - www.web-app.net)            # 
#                                                                             # 
# WebAPP NE is the continued development of WebAPP, beginning with            #
# upgrade from WebAPP v0.9.9.3.2 to WebAPP v0.9.9.3.3 NE in June 2006         #
# (WebAPP Copyright (c) WebAPP - www.web-app.org and                          #
# M. Carter Brown - www.mcarterbrown.com)                                     #
#                                                                             # 
# WebAPP was based on YaWPS in 2002 - yawps.sourceforge.net                   # 
# (YaWPS  Copyright (c) 2001 by d3m1g0d)                                      #
#                                                                             # 
# YaWPS was based on YaBB in 2001 by Zef Hemel - www.zefhemel.com             # 
# (YaBB Copyright (c) 2000 The YaBB Programming team)                         # 
#                                                                             #
# This file is part of WebAPP NE.                                             #
#                                                                             #
# WebAPP NE is free software; you can redistribute it and/or modify           #
# it under the terms of the GNU General Public License as published by        #
# the Free Software Foundation; either version 2 of the License, or           #
# (at your option) any later version.                                         #
#                                                                             #
# WebAPP NE is distributed in the hope that it will be useful,                #
# but WITHOUT ANY WARRANTY; without even the implied warranty of              #
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               #
# GNU General Public License for more details.                                #
#                                                                             #
# You should have received a copy of the GNU General Public License           #
# along with WebAPP NE; if not, write to the Free Software Foundation, Inc.,  #
# 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.               #
#                                                                             #
# File: Modified: 2005 by Jos Brown ("bantychick") for 0.9.9.3                #
# Modified: 18 Jan, 16 May, 26 May 2006 by Jos                                #
###############################################################################
###############################################################################

$| = 1; # do not buffer output on STDOUT

use CGI::Carp qw(fatalsToBrowser);
# also prints out Perl warnings from modules to browser

use vars qw($scriptname $forum $pageurl $scriptname $anonuser @months @days); # silence warnings

# BEGIN { ### UNCOMMENT THIS FOR TROUBLESHOOTING and ADD -w to the shebang ###
# require "config.pl";
# use CGI::Carp qw(carpout);
# open(LOG, ">>$datadir/webapperr.log") or die("Unable to open webapperr.log: $!\n");
# carpout(LOG);
# close(LOG);
# } # prints warnings to private file (slows things down but is handy)

eval {
	require "config.pl"; # comment if above block is ON
	require "$sourcedir/subs.pl";

#	if ($IIS != 2) {
#		if ($IIS == 0) {
#			if ($ENV{'SERVER_SOFTWARE'} =~ m!IIS!) { $IIS = 1; }
#		}
#		if (($IIS) && ($0 =~ m!(.*)(\\|\/)!)) { chdir($1); }
#		if ($IIS == 1) { print "HTTP/1.0 200 OK\n"; } # okay for windows perl with dll
#	}

};

if ($@) {
	print "Content-type: text/html\n\n";
	print qq~<h1>Software Error:</h1>
Execution of <b>$scriptname</b> has been aborted due a compilation error:<br>
<pre>$@</pre>
<p>If this problem persists, please contact the webmaster and inform him about date and time you've received this error.</p>
SD: $scriptdir~;
	exit;
}

# using these rather than calling the entire getlanguage twice
$anonuser = "Guest";
@months = qw(January February March April May June July August September October November December);
@days = qw(Sunday Monday Tuesday Wednesday Thursday Friday Saturday);

getcgi();
getdate();
loadcookie(); # needs months days
loaduser();
logips();
&ban; # needs username realname anonuser months days first
logvisitors();
&getver;

if ($ENV{QUERY_STRING} =~ /<|>|\&lt|\&gt\|/){data_error("Yes! We have no bananas today!"); # Fix by www.web-app.net for XSS issues discovered by the web-app.net security team 19.09.2006
 }
 
if ($action) {
	if ($action eq "register") { require "$sourcedir/user.pl"; register(); }
	elsif ($action eq "register2") { require "$sourcedir/user.pl"; register2(); }
	elsif ($action eq "help") { require "$sourcedir/help.pl"; help(); }
	elsif ($action eq "bannerredirect") { require "$sourcedir/ads.pl"; bannerredirect(); }
	elsif ($action eq "about") { require "$sourcedir/about.pl"; about(); }
	elsif ($action eq "contact") { require "$sourcedir/contact.pl"; contact(); }
	elsif ($action eq "login") { require "$sourcedir/user.pl"; login(); }
	elsif ($action eq "login2") { require "$sourcedir/user.pl"; login2(); }
	elsif ($action eq "logout") { require "$sourcedir/user.pl"; logout(); }
	elsif ($action eq "reminder") { require "$sourcedir/user.pl"; reminder(); }
	elsif ($action eq "reminder2") { require "$sourcedir/user.pl"; reminder2(); }
	elsif ($action eq "editprofile") { require "$sourcedir/user.pl"; editprofile(); }
	elsif ($action eq "editprofile2") { require "$sourcedir/user.pl"; editprofile2(); }
	elsif ($action eq "editprofile3") { require "$sourcedir/user.pl"; editprofile3(); }
	elsif ($action eq "deleteprofile") { require "$sourcedir/user.pl"; deleteprofile(); }
	elsif ($action eq "admindeleteprofile") { require "$sourcedir/admin.pl"; admindeleteprofile(); }
	elsif ($action eq "ver") { require "$sourcedir/subs.pl"; ver(); }
	elsif ($action eq "viewprofile") { require "$sourcedir/user.pl"; viewprofile(); }
	elsif ($action eq "memberlist") { require "$sourcedir/memberlist.pl"; mlist(); }
	elsif ($action eq "postnews") {
		require "$sourcedir/topics.pl";
		require "$sourcedir/forum_subs.pl";
		postnews();
	}
	elsif ($action eq "postnews2") {
		require "$sourcedir/topics.pl";
		require "$sourcedir/forum_subs.pl";
		require "$sourcedir/subs_post.pl";
		postnews2();
	}
	elsif ($action eq "viewnews") { require "$sourcedir/topics.pl"; viewnews(); }
	elsif ($action eq "commentnews") {
		require "$sourcedir/topics.pl";
		require "$sourcedir/subs_post.pl";
		commentnews();
	}

	elsif ($action eq "replycomment") { require "$sourcedir/topics.pl"; replycomment(); }
	elsif ($action eq "replycomment2") {
		require "$sourcedir/topics.pl";
		require "$sourcedir/subs_post.pl";
		replycomment2();
	}

	elsif ($action eq "otherarticles") {require "$sourcedir/topics.pl"; other_articles(); }
	elsif ($action eq "printtopic") {require "$sourcedir/topics.pl"; printtopic(); }
	elsif ($action eq "emailtopic") {require "$sourcedir/topics.pl"; emailtopic(); }
	elsif ($action eq "emailtopic2") {
		require "$sourcedir/topics.pl";
		require "$sourcedir/emailer.pl";
		emailtopic2();
	}
	elsif ($action eq "who") { require "$sourcedir/whosonline.pl"; readwho(); }
	elsif ($action eq "topics") { require "$sourcedir/topics.pl"; topics(); }
	elsif ($action eq "im") { require "$sourcedir/instantmessage.pl"; imindex(); }
	elsif ($action eq "imremove") { require "$sourcedir/instantmessage.pl"; imremove(); }
	elsif ($action eq "imsend") {
		require "$sourcedir/instantmessage.pl";
		require "$sourcedir/forum_subs.pl";
		impost();
	}
	elsif ($action eq "imsend2") { require "$sourcedir/instantmessage.pl"; impost2(); }
	elsif ($action eq "siteim") {
		require "$sourcedir/instantmessage.pl";
		require "$sourcedir/forum_subs.pl";
		siteim();
	}
	elsif ($action eq "siteim2") { require "$sourcedir/instantmessage.pl"; siteim2(); }
	elsif ($action eq "adminim") {
		require "$sourcedir/instantmessage.pl";
		require "$sourcedir/forum_subs.pl";
		adminim();
	}
	elsif ($action eq "adminim2") { require "$sourcedir/instantmessage.pl"; adminim2(); }
	elsif ($action eq "modim") {
		require "$sourcedir/instantmessage.pl";
		require "$sourcedir/forum_subs.pl";
		modim();
	}
	elsif ($action eq "modim2") { require "$sourcedir/instantmessage.pl"; modim2(); }
	elsif ($action eq "recommend") { require "$sourcedir/recommend.pl"; recommend(); }
	elsif ($action eq "recommend2") { require "$sourcedir/recommend.pl"; recommend2(); }
	elsif ($action eq "pollit") { require "$sourcedir/poll.pl"; pollit(); }
	elsif ($action eq "pollit2") { require "$sourcedir/poll.pl"; pollit2(); }
	elsif ($action eq "pollit3") { require "$sourcedir/poll.pl"; &pollit3; }
	elsif ($action eq "commentpoll") { require "$sourcedir/poll.pl"; commentpoll(); }
	elsif ($action eq "removepollcomment") { require "$sourcedir/poll.pl"; removepollcomment(); }
	elsif ($action eq "editpollcomment") { require "$sourcedir/poll.pl"; editpollcomment(); }
	elsif ($action eq "editpollcomment2") { require "$sourcedir/poll.pl"; editpollcomment2(); }
	elsif ($action eq "stats") { require "$sourcedir/stats.pl"; stats(); }
	elsif ($action eq "links") { require "$sourcedir/links.pl"; links(); }
	elsif ($action eq "palm") { require "$sourcedir/palm.pl"; palm(); }
	elsif ($action eq "addlink") { require "$sourcedir/links.pl"; addlink(); }
	elsif ($action eq "addlink2") { require "$sourcedir/links.pl"; addlink2(); }
	elsif ($action eq "editlinks") { require "$sourcedir/links.pl"; editlinks(); }
	elsif ($action eq "editlinks2") { require "$sourcedir/links.pl"; editlinks2(); }
	elsif ($action eq "deletelinks") { require "$sourcedir/links.pl"; deletelinks(); }
	elsif ($action eq "deletelinks2") { require "$sourcedir/links.pl"; deletelinks2(); }
	elsif ($action eq "movelinks") { require "$sourcedir/links.pl"; movelinks(); }
	elsif ($action eq "movelinks2") { require "$sourcedir/links.pl"; movelinks2(); }
	elsif ($action eq "ratelinks") { require "$sourcedir/links.pl"; ratelinks(); }
	elsif ($action eq "ratelinks2") { require "$sourcedir/links.pl"; ratelinks2(); }
	elsif ($action eq "linkinfo") { require "$sourcedir/links.pl"; link_info(); }
	elsif ($action eq "top10") { require "$sourcedir/top10.pl"; show_top10(); }
	elsif ($action eq "downloads") { require "$sourcedir/downloads.pl"; downloads(); }
	elsif ($action eq "adddownload") { require "$sourcedir/downloads.pl"; adddownload(); }
	elsif ($action eq "adddownload2") { require "$sourcedir/downloads.pl"; adddownload2(); }
	elsif ($action eq "editdownloads") { require "$sourcedir/downloads.pl"; editdownloads(); }
	elsif ($action eq "editdownloads2") { require "$sourcedir/downloads.pl"; editdownloads2(); }
	elsif ($action eq "deletedownload") { require "$sourcedir/downloads.pl"; deletedownload(); }
	elsif ($action eq "deletedownload2") { require "$sourcedir/downloads.pl"; deletedownload2(); }
	elsif ($action eq "movedownload") { require "$sourcedir/downloads.pl"; movedownload(); }
	elsif ($action eq "movedownload2") { require "$sourcedir/downloads.pl"; movedownload2(); }
	elsif ($action eq "redirect") { require "$sourcedir/links.pl"; redirect(); }
	elsif ($action eq "redirectd") { require "$sourcedir/downloads.pl"; redirect(); }
	elsif ($action eq "downloadinfo") { require "$sourcedir/downloads.pl"; download_info(); }
	elsif ($action eq "ratedownloads") { require "$sourcedir/downloads.pl"; ratedownloads(); }
	elsif ($action eq "ratedownloads2") { require "$sourcedir/downloads.pl"; ratedownloads2(); }
	elsif ($action eq "search") { require "$sourcedir/search.pl"; search(); }
	elsif ($action eq "subscribe") { require "$sourcedir/newsletter.pl"; subscribe(); }
	elsif ($action eq "searchuser") { require "$sourcedir/memberlist.pl"; searchuser(); }
	elsif ($action eq "anonemail") { require "$sourcedir/emailer.pl"; sendto(); }
	elsif ($action eq "sendto2") { require "$sourcedir/emailer.pl"; sendto2(); }
	elsif ($action eq "backup") { require "$sourcedir/admin.pl";  backup(); }
	elsif ($action eq "backup2") { require "$sourcedir/admin.pl";  backup2(); }
	elsif ($action eq "markasread") { require "$sourcedir/forum_mark.pl"; mark_as_read(); }
	elsif ($action eq "markpostsread") { require "$sourcedir/forum_mark.pl"; mark_posts_read(); }
	elsif ($action eq "uploadpicture") { require "$sourcedir/upload.pl";  uploadpicture(); }
	elsif ($action eq "uploadsuccess") { require "$sourcedir/upload.pl";  success(); }
	elsif ($action eq "uploadfail") { require "$sourcedir/upload.pl";  failure(); }
	elsif ($action eq "findip") { require "$sourcedir/forum_admin.pl";  findips(); }

#######################
# Edit user profile fix
#######################
	elsif ($action eq "admineditprofile" ) { require "$sourcedir/admin.pl"; admineditprofile(); }
	elsif ($action eq "admineditprofile2" ) { require "$sourcedir/admin.pl"; admineditprofile2(); }
	elsif ($action eq "done" ) { require "$sourcedir/admin.pl"; done(); }

#######################
# The Assistant Admin Stuff
#######################

	elsif ($action eq "adminlite") {
		$admin = qq~$cgi?action=admin~;
		require "$sourcedir/admin.pl"; siteadmin();
	}

#######################
# The Real Admin Stuff
#######################

	elsif ($action eq "admin") {
		$admin = qq~$cgi?action=admin~;
		if (!$op) { require "$sourcedir/admin.pl"; siteadmin(); }
		elsif ($op eq "siteadmin") { require "$sourcedir/admin.pl"; siteadmin(); }
		elsif ($op eq "siteconfig") { require "$sourcedir/admin.pl"; siteconfig(); }
		elsif ($op eq "siteconfig2") { require "$sourcedir/admin.pl"; siteconfig2(); }
		elsif ($op eq "adminsetup") { require "$sourcedir/admin.pl"; adminsetup(); }
		elsif ($op eq "adminsetup2") { require "$sourcedir/admin.pl"; adminsetup2(); }
		elsif ($op eq "welcomemsg") { require "$sourcedir/admin.pl"; welcomemsg(); }
		elsif ($op eq "welcomemsg2") { require "$sourcedir/admin.pl"; welcomemsg2(); }
		elsif ($op eq "welcomemsgm") { require "$sourcedir/admin.pl"; welcomemsgm(); }
		elsif ($op eq "welcomemsgm2") { require "$sourcedir/admin.pl"; welcomemsgm2(); }
		elsif ($op eq "aboutinfo") { require "$sourcedir/admin.pl"; aboutinfo(); }
		elsif ($op eq "aboutinfo2") { require "$sourcedir/admin.pl"; aboutinfo2(); }
		elsif ($op eq "agreement") { require "$sourcedir/admin.pl"; agreement(); }
		elsif ($op eq "agreement2") { require "$sourcedir/admin.pl"; agreement2(); }
		elsif ($op eq "welcomeim") { require "$sourcedir/admin.pl"; welcomeim(); }
		elsif ($op eq "welcomeim2") { require "$sourcedir/admin.pl"; welcomeim2(); }
		elsif ($op eq "userapproval") { require "$sourcedir/admin.pl"; userapproval(); }
		elsif ($op eq "userapproval2") { require "$sourcedir/admin.pl"; userapproval2(); }
		elsif ($op eq "userranks") { require "$sourcedir/admin.pl"; userranks(); }
		elsif ($op eq "userranks2") { require "$sourcedir/admin.pl"; userranks2(); }
		elsif ($op eq "userstate") { require "$sourcedir/admin.pl"; userstate(); }
		elsif ($op eq "userstate2") { require "$sourcedir/admin.pl"; userstate2(); }
		elsif ($op eq "managecats") { require "$sourcedir/admin.pl"; managecats(); }
		elsif ($op eq "reordercats") { require "$sourcedir/admin.pl"; reordercats(); }
		elsif ($op eq "removecat") { require "$sourcedir/admin.pl"; removecat(); }
		elsif ($op eq "createcat") { require "$sourcedir/admin.pl"; createcat(); }
		elsif ($op eq "manageboards") { require "$sourcedir/admin.pl"; manageboards(); }
		elsif ($op eq "reorderboards") { require "$sourcedir/admin.pl"; reorderboards(); }
		elsif ($op eq "reorderboards2") { require "$sourcedir/admin.pl"; reorderboards2(); }
		elsif ($op eq "modifyboard") { require "$sourcedir/admin.pl"; modifyboard(); }
		elsif ($op eq "createboard") { require "$sourcedir/admin.pl"; createboard(); }
		elsif ($op eq "setcensor") { require "$sourcedir/admin.pl"; setcensor(); }
		elsif ($op eq "setcensor2") { require "$sourcedir/admin.pl"; setcensor2(); }
		elsif ($op eq "polladmin") { require "$sourcedir/admin.pl"; polladmin(); }
		elsif ($op eq "createpoll") { require "$sourcedir/admin.pl"; createpoll(); }
		elsif ($op eq "editpoll") {
			require "$sourcedir/admin.pl";
			require "$sourcedir/subs_post.pl";
			editpoll();
		}
		elsif ($op eq "editpoll2") { require "$sourcedir/admin.pl"; editpoll2(); }
		elsif ($op eq "editpoll2a") { require "$sourcedir/admin.pl"; editpoll2a(); }
		elsif ($op eq "editpoll3") { require "$sourcedir/admin.pl"; editpoll3(); }
		elsif ($op eq "resetpoll") { require "$sourcedir/admin.pl"; resetpoll(); }
		elsif ($op eq "deletepoll") { require "$sourcedir/admin.pl"; deletepoll(); }
		elsif ($op eq "verifynews") {
			require "$sourcedir/admin.pl";
			require "$sourcedir/subs_post.pl";
			verifynews();
		}
		elsif ($op eq "verifynews2") {
			require "$sourcedir/admin.pl";
			require "$sourcedir/subs_post.pl";
			verifynews2();
		}
		elsif ($op eq "modifynews") { require "$sourcedir/admin.pl"; modifynews(); }
		elsif ($op eq "modifynews2") { require "$sourcedir/admin.pl"; modifynews2(); }
		elsif ($op eq "modifynews3") {
			require "$sourcedir/admin.pl";
			require "$sourcedir/subs_post.pl";
			modifynews3();
		}
		elsif ($op eq "movetopic") {
			require "$sourcedir/admin.pl";
			require "$sourcedir/subs_post.pl";
			movetopic();
		}
		elsif ($op eq "topicadmin") { require "$sourcedir/admin.pl"; topicadmin(); }
		elsif ($op eq "topicadmin2") { require "$sourcedir/admin.pl"; topicadmin2(); }
		elsif ($op eq "topicadmin3") { require "$sourcedir/admin.pl"; topicadmin3(); }
		elsif ($op eq "newsletter") { require "$sourcedir/newsletter.pl"; newsletter(); }
		elsif ($op eq "sendnewsletter") { require "$sourcedir/newsletter.pl"; sendnewsletter(); }
		elsif ($op eq "sendnewsletter2") {
			require "$sourcedir/newsletter.pl";
			require "$sourcedir/emailer.pl";
			sendnewsletter2();
		}
		elsif ($op eq "newslettermsg") { require "$sourcedir/newsletter.pl"; newslettermsg(); 	}
		elsif ($op eq "newslettermsg2") { require "$sourcedir/newsletter.pl"; 	newslettermsg2(); }
		elsif ($op eq "editemails") { require "$sourcedir/newsletter.pl"; editemails(); 	}
		elsif ($op eq "editemails2") { require "$sourcedir/newsletter.pl"; 	editemails2(); }
		elsif ($op eq "editbanip") { require "$sourcedir/admin.pl"; 	editbanip(); }
		elsif ($op eq "deletebannedip") { require "$sourcedir/admin.pl"; 	deletebannedip(); }
		elsif ($op eq "addbannedip") { require "$sourcedir/admin.pl"; 	addbannedip(); }
# not yet in use:
#		elsif ($op eq "installupgrade") { require "$sourcedir/admin.pl"; 	installupgrade(); }
#		elsif ($op eq "installupgrade2") { require "$sourcedir/admin.pl"; 	installupgrade2(); }
		elsif ($op eq "archive") { require "$sourcedir/admin.pl"; archive(); }
		elsif ($op eq "archive2") { require "$sourcedir/admin.pl"; archive2(); }
		elsif ($op eq "removeoldposts") { require "$sourcedir/admin.pl"; removeoldposts(); }
		elsif ($op eq "removeoldposts2") { require "$sourcedir/admin.pl"; removeoldposts2(); }
		elsif ($op eq "captchaadmin") { require "$sourcedir/captcha.pl"; captcha_admin(); }
		elsif ($op eq "captchaadmin2") { require "$sourcedir/captcha.pl"; captcha_admin2(); }
		else { require "$sourcedir/admin.pl"; siteadmin(); }
	}
	elsif ($action eq "viewarchive") {
		$archiveboard = $currentboard || "";
		if (!defined $op) { $op = ""; }
		$forum = qq~$pageurl/$cgi?action=viewarchive&amp;board=$archiveboard~;
		if ($archiveboard ne "" and $op eq "") {
			require "$sourcedir/archive.pl";
			require "$sourcedir/forum_subs.pl";
			archivemessageindex();
		}
		elsif ($archiveboard ne "" and $op eq "archivedisplay") {
			require "$sourcedir/archive.pl";
			require "$sourcedir/forum_subs.pl";
			archivedisplay();
		}
		elsif ($archiveboard eq "") { require "$sourcedir/archive.pl"; archiveindex(); }
	}
	elsif ($action eq "forum") {
		if (!defined $currentboard) { $currentboard = ""; }
		if (!defined $op) { $op = ""; }
		$forum = qq~$pageurl/$cgi?action=forum&amp;board=$currentboard~; # used in all forum pls except forum_mark
		if ($currentboard ne "" and $op eq "") {
			require "$sourcedir/forum.pl";
			require "$sourcedir/forum_subs.pl"; # Nov 25 2005
			messageindex();
		}
# forum_display.pl
		elsif ($currentboard ne "" and $op eq "display") {
			require "$sourcedir/forum_display.pl";
			require "$sourcedir/forum_subs.pl";
			display();
		}
		elsif ($currentboard ne "" and $op eq "displaysticky") {
			require "$sourcedir/forum_display.pl";
			require "$sourcedir/forum_subs.pl";
			displaysticky();
		}
		elsif ($currentboard ne "" and $op eq "printpage" and $action ne "index") { require "$sourcedir/forum_display.pl"; printpage(); }
# forum_post.pl
		elsif ($currentboard ne "" and $op eq "poststicky" and $action ne "index") {
			require "$sourcedir/forum_post.pl";
			require "$sourcedir/forum_subs.pl";
			poststicky();
		}
		elsif ($currentboard ne "" and $op eq "poststicky2" and $action ne "index") {
			require "$sourcedir/forum_post.pl";
			require "$sourcedir/subs_post.pl";
			poststicky2();
		}
		elsif ($currentboard ne "" and $op eq "post" and $action ne "index") {
			require "$sourcedir/forum_post.pl";
			require "$sourcedir/forum_subs.pl";
			post();
		}
		elsif ($currentboard ne "" and $op eq "post2" and $action ne "index") {
			require "$sourcedir/forum_post.pl";
			require "$sourcedir/subs_post.pl";
			post2();
		}
# forum_admin.pl
		elsif ($currentboard ne "" and $op eq "modifysticky" and $action ne "index") {
			require "$sourcedir/forum_admin.pl";
			require "$sourcedir/forum_subs.pl";
			modifystickymessage();
		}
		elsif ($currentboard ne "" and $op eq "modifysticky2" and $action ne "index") { require "$sourcedir/forum_admin.pl"; modifystickymessage2(); }
		elsif ($currentboard ne "" and $op eq "modify" and $action ne "index") {
			require "$sourcedir/forum_admin.pl";
			require "$sourcedir/forum_subs.pl";
			modifymessage();
		}
		elsif ($currentboard ne "" and $op eq "modify2" and $action ne "index") { require "$sourcedir/forum_admin.pl"; modifymessage2(); }
		elsif ($currentboard ne "" and $op eq "movestickythread" and $action ne "index") { require "$sourcedir/forum_admin.pl"; movestickythread(); }
		elsif ($currentboard ne "" and $op eq "movestickythread2" and $action ne "index") { require "$sourcedir/forum_admin.pl"; movestickythread2(); }
		elsif ($currentboard ne "" and $op eq "removestickythread" and $action ne "index") { require "$sourcedir/forum_admin.pl"; removestickythread(); }
		elsif ($currentboard ne "" and $op eq "removestickythread2" and $action ne "index") { require "$sourcedir/forum_admin.pl"; removestickythread2(); }
		elsif ($currentboard ne "" and $op eq "lockstickythread" and $action ne "index") { require "$sourcedir/forum_admin.pl"; lockstickythread(); }
		elsif ($currentboard ne "" and $op eq "movethread" and $action ne "index") { require "$sourcedir/forum_admin.pl"; movethread(); }
		elsif ($currentboard ne "" and $op eq "movethread2" and $action ne "index") { require "$sourcedir/forum_admin.pl"; movethread2(); }
		elsif ($currentboard ne "" and $op eq "removethread" and $action ne "index") { require "$sourcedir/forum_admin.pl"; removethread(); }
		elsif ($currentboard ne "" and $op eq "removethread2" and $action ne "index") { require "$sourcedir/forum_admin.pl"; removethread2(); }
		elsif ($currentboard ne "" and $op eq "lockthread" and $action ne "index") { require "$sourcedir/forum_admin.pl"; lockthread(); }
# make sticky
		elsif ($currentboard ne "" and $op eq "makesticky" and $action ne "index") { require "$sourcedir/forum_admin.pl"; makesticky(); }
		elsif ($currentboard ne "" and $op eq "makesticky2" and $action ne "index") { require "$sourcedir/forum_admin.pl"; makesticky2(); }
		elsif ($currentboard ne "" and $op eq "unmakesticky" and $action ne "index") { require "$sourcedir/forum_admin.pl"; unmakesticky(); }
		elsif ($currentboard ne "" and $op eq "unmakesticky2" and $action ne "index") { require "$sourcedir/forum_admin.pl"; unmakesticky2(); }
# notify.pl
		elsif ($currentboard ne "" and $op eq "notifysticky" and $action ne "index") { require "$sourcedir/notify.pl"; notifysticky(); }
		elsif ($currentboard ne "" and $op eq "notifysticky2" and $action ne "index") { require "$sourcedir/notify.pl"; notifysticky2(); }
		elsif ($currentboard ne "" and $op eq "notify" and $action ne "index") { require "$sourcedir/notify.pl"; notify(); }
		elsif ($currentboard ne "" and $op eq "notify2" and $action ne "index") { require "$sourcedir/notify.pl"; notify2(); }
		elsif ($currentboard ne "" and $op eq "notify_remove" and $action ne "index") { require "$sourcedir/notify.pl"; notify_remove(); }
		elsif ($currentboard ne "" and $op eq "notify_remove_success" and $action ne "index") { require "$sourcedir/notify.pl"; notify_remove_success(); }
		elsif ($currentboard eq "") { require "$sourcedir/forum.pl"; boardindex(); }
	}
	elsif ($action eq "test_theme") { require "$sourcedir/test_theme.pl"; test_theme(); }
	elsif ($action eq "bannerfarm") { require "$sourcedir/ads.pl"; bannerfarm(); }
	elsif ($action eq "data_error") { &data_error; }
	elsif ($action eq "goodies") { require "$sourcedir/bans.pl"; banbot(); }  #spambot ban
	elsif ($action eq "showhtml") { require "$sourcedir/showhtml.pl"; &show_html; } 
#for IMX
	elsif ($action eq "deletefromylog") { require "$sourcedir/instantmessage.pl"; deletefromylog(); }
	elsif ($action eq "messageadmin") { require "$sourcedir/instantmessage.pl"; messageadmin(); }
	elsif ($action eq "messageadmin2") { require "$sourcedir/instantmessage.pl"; messageadmin2();}
	elsif ($action eq "messageadmin3") { require "$sourcedir/instantmessage.pl"; messageadmin3();}
	elsif ($action eq "messageadmin4") { require "$sourcedir/instantmessage.pl"; messageadmin4();}
	elsif (($action eq "im2") || ($action eq "imfolder")) { require "$sourcedir/instantmessage.pl"; imfolder(); }
	elsif (($action eq "im3") || ($action eq "saveim")) { require "$sourcedir/instantmessage.pl"; imsaved(); }
	elsif ($action eq "moveim") { require "$sourcedir/instantmessage.pl"; moveim(); }
	elsif ($action eq "imremove2") { require "$sourcedir/instantmessage.pl"; imremove2(); }
	elsif ($action eq "imremove3") { require "$sourcedir/instantmessage.pl"; imremove3(); }
# Gallery: 
	elsif ($action eq "gallery") {
		require "$sourcedir/gallery.pl";
		if ($op) {
			if ($op eq "galview") { &view; }
			elsif ($op eq "galallowprivate") { &allowprivate; }
			elsif ($op eq "galcreateprivate") { &createprivate; }
			elsif ($op eq "galcreategallery") { &creategallery; }
			elsif ($op eq "galuploadpicture") { &uploadpicture; }
			elsif ($op eq "galuploadsuccess") { &uploadsuccess; }
			elsif ($op eq "galuploadfail") { &uploadfail; }
			elsif ($op eq "galadmin") { &admin; }
			elsif ($op eq "galclearold") { &clearold; }
			elsif ($op eq "galmyadmin") { &myadmin; }
			elsif ($op eq "galdelete") { &delete; }
			elsif ($op eq "galallowcomments") { &allowcomments; }
			elsif ($op eq "galallowfeedback") { &allowfeedback; }
			elsif ($op eq "galleavecomment") {
				require "$sourcedir/subs_post.pl"; # added this Jan 18 2006
				&leavecomment;
			}
			elsif ($op eq "galdeletecomment") { &deletecomment; }
			elsif ($op eq "galdeletefeedback") { &deletefeedback; }
			elsif ($op eq "galallownotification") { &allownotification; }
			elsif ($op eq "galmarkasread") { &markasread; }
			elsif ($op eq "galfeedback") { &feedback; }
			elsif ($op eq "galfeedback2") {
				require "$sourcedir/subs_post.pl"; # added this Jan 18 2006
				&feedback2;
			}
			elsif ($op eq "galdeleteempty") { &deleteempty; }
			elsif ($op eq "deletegallery") { &deletegallery; }
			else {
				require "$sourcedir/forum_subs.pl";
				&start;
			}
		} else {
			require "$sourcedir/forum_subs.pl";
			&start;
		}
	}
# Menu Manager:
	elsif ($action eq "menu") {
		require "$sourcedir/mmedit.pl";
		if ($op) {
			if (($op eq "Edit") || ($op eq "Add")) { &editmenuitem; }
			elsif (($op eq "Up") || ($op eq "Down")) { &reordermenu; }
			elsif (($op eq "EditSave") || ($op eq "Delete")) { &savemenuitem; }
			else { &viewmenu; }
		} else { &viewmenu; }
	}
	elsif ($action eq "refernote") { error("$err{'049'}"); }

	elsif ($action eq "fpcatchup") { require "$sourcedir/extras.pl"; &fpcatchup; }
	elsif ($action eq "latestcomments") { require "$sourcedir/extras.pl"; &latestcomments; }

	else { 
		if (-e "user.cgi") { # you can add custom actions here
			require "user.cgi";
		}
		else {
			error("$err{'006'}"); # No such page.
		}
	}
} else {
	print_main(); # print main if no action
}

exit; # all done

1;
