#!/usr/bin/perl -w

########################################################################
#
# program: index.cgi
# system : Blog Calendar Mod for WebAPP NE (Network Edition)
# author : Copyright (C) 2007 Steven L. Reid
# purpose: Display a calendar of articles (main).
# history:
# 12/06/2006, Steven Reid
#	- script created
# 01/27/2007, Steven Reid
#	- fixed issues with blogcal.cgi overwriting variables
#
########################################################################

# setup environment
$|++;
#use strict; # turned off due to WebAPP not supporting it

# Read configuration file
BEGIN {
  use CGI::Carp qw(fatalsToBrowser);
  # include WebAPP configuration
  require "../../config.pl";
  require "$lang";
  require "$sourcedir/subs.pl";
  # include configurations
  require "data/blogcal-paths.cfg";
  require "data/blogcal.cfg";
}

# load libraries
use File::Basename;

# define variables
my $bc_date;
my $bc_month; my $bc_day; $bc_year;
my $bc_weekday       =  0;
my $bc_monthlen      = 31;
my @bc_blog_dates    = ();

########################################################################
# begin main

bci_display_header();
bci_load_parms();
bci_display_blog_calendar();
bci_display_footer();

# end main
########################################################################

########################################################################
# Slideshow Display Header - load WebAPP stuff and print header
########################################################################
sub bci_display_header() {

  # WebAPP specific stuff
  eval {
    if ($IIS != 2) {
      if ($IIS == 0) {
        if ($ENV{'SERVER_SOFTWARE'} =~ m!IIS!) { $IIS = 1; }
      }
      if (($IIS) && ($0 =~ m!(.*)(\\|\/)!)) { chdir($1); }
	if ($IIS == 1) { print "HTTP/1.0 200 OK\n"; }
      }
  };

  if ($@) {
    print <<END_HTML;
Content-type: text/html\n\n
<html><head><title>Software Error</title></head>
<body><h1>Software Error:</h1>
Execution of <b>$scriptname</b> has been aborted due a compilation error:<br />
<pre>$@</pre>
<p>If this problem persists, please contact the webmaster and inform him about the date and time you've received this error.</p>
</body></html>
END_HTML
    exit;
  }

  # include default sub stuff
  getcgi();
  getdate();
  loadcookie();
  loaduser();
  logips();
  ban();
  logvisitors();
  getver();

  # include language file (if exists)
  if ( -e "$bc_langDir/$userlang") {
    require "$bc_langDir/$userlang";
  } else {
    require "$bc_langDir/$bc_defaultLang";
  }

  # print top
  $navbar = "&nbsp;$btn{'014'}&nbsp; $cm_title $cal_msg{'017'}";
  print_top();
}
########################################################################

########################################################################
# Slideshow Display Footer - print footer after doing work
########################################################################
sub bci_display_footer {
  print_bottom();
}
########################################################################

########################################################################
# Display Blog Calendar
########################################################################
sub bci_display_blog_calendar {
  bci_do_math();		# perform date math
  bci_view_arts_on_date();	# display articles
}
########################################################################

########################################################################
# Load params - get the form variables if need be
########################################################################
sub bci_load_parms {
  # load parameters
  my $date = $info{'date'} or return;
  my ($y,$m,$d) = ($date =~ /(\d\d)(\d\d)(\d\d)/);
  return unless $d;
  $bc_month = $m;
  $bc_day = $d;
  $bc_year = $y;
  if ($user_check_date eq "american") {
    $bc_date = "$bc_month/$bc_day/$bc_year";
  } elsif ($user_check_date eq "european") {
    $bc_date = "$bc_day/$bc_month/$bc_year";
  }
  $bc_month--;	# make it unix format month (subtract 1)
  $bc_year+=100 if $bc_year < 100; $bc_year+=1900;
}
########################################################################

########################################################################
# Perform date math (leap year, month length and week day of the first)
########################################################################
sub bci_do_math {
  # grab today if date not passed
  unless ($bc_date) {
    getTimezones(); # convert to current time
    ($bc_month, $bc_day, $bc_year) = getNewtime(split(/\s-\s/, $date));
    # get pretty date format
    if ($user_check_date eq "american") {
      $bc_date = "$bc_month/$bc_day/$bc_year";
    } elsif ($user_check_date eq "european") {
      $bc_date = "$bc_day/$bc_month/$bc_year";
    }

    $bc_month--;	# make it unix format month (subtract 1)
    $bc_year+=100 if $bc_year < 100; $bc_year+=1900;
  }

  # determine leap year
  my $leap = 0;
  $leap = 1 unless $bc_year % 4;
  $leap = 0 unless $bc_year % 100;
  $leap = 1 unless $bc_year % 400;

  # determine length of month
  $bc_monthlen = 28 + $leap if $bc_month == 1;	# February
  $bc_monthlen-- if $bc_month =~ /3|5|8|10/;	# months with 30 days

  # week day of the first of the month using Zeller's Congruence
  my $m = $bc_month + 1; my $d = 1; my $y = $bc_year;
  if ($m < 3) { $m+=12; $y--; }
  $bc_weekday = ( $d + $m*2 + int(($m+1)*0.6) + 1 + $y +
               int($y/4) - int($y/100) + int($y/400)  ) % 7;
}
########################################################################

########################################################################
# View Articles on Date - ########################################################################
sub bci_view_arts_on_date {

  # convert bc_date to nice date format
  $navbar = "$btn{'014'} $bc_msg{'003'} $btn{'014'} $bc_date";
  $navbar = "&nbsp;$btn{'014'}&nbsp; $sc_title $msg{'430'}";
  print_top();
  print qq~<div align="center" class="articlecattitle">$bc_msg{'001'} $bc_date</div>
<br />
~;

  # walk blog tree, matching any criteria and placing into
  # @blog
  my $d = $bc_day;
  my $m = $bc_month + 1;  $m = "0$m" if $m < 10;
  my $y = $bc_year - 1900; $y -= 100 if $y > 100; $y = "0$y" if $y < 10;

  # get list of catagories
  @cats = chomp_database("$topicsdir/cats.dat"); 

  for my $cat(@cats) {
    my ($curcatname, $curcat) = split (/\|/, $cat);
    $curcatname =~ s/[\n\r]//g;
    $curcat =~ s/[\n\r]//g;
    @articles = chomp_database("$topicsdir/$curcat.cat"); 

    foreach my $line (@articles) { 
      my ($topic,$adate) = (split ( /\|/, $line))[0,5];
      # format: 02/25/06 - 22:53:30
      my ($month, $day, $year)
        = getNewtime(split(/\s-\s/, $adate));
      next unless $day == $d && $month == $m && $year == $y;
      push @topics, "$line|$curcat|$curcatname";
    }
  }

  require "$sourcedir/topics.pl";
  my $max = $bc_numToDisplay == 0 || $#topics < $bc_numToDisplay-1
    ? $#topics : $bc_numToDisplay-1;
  for my $topic (sort @topics[0..$max]) {
    ($id, $subject, $nick, $poster, $email, $postdate, $commentscnt, $curcat, $curcatname) = split(/\|/, $topic);
    display_date($postdate);
    $postdatenew = $user_display_date;
    $postdateold = $postdate;

    if ($commentscnt == 1) { $commentscnt = "$commentscnt $msg{'040'}"; }
    elsif ($commentscnt == -1) { $commentscnt = "0 $msg{'041'}"; }
    else { $commentscnt = "$commentscnt $msg{'041'}"; }

    read_count($id);

    open (FILE, "$topicsdir/articles/$id.txt");
    hold(FILE);
    chomp($text = <FILE>);
    release(FILE);
    close(FILE);

    $message = (split(/\|/, $text))[5];

    $postdate = $postdatenew;
    newstop();
    $postdate = $postdateold;

    if ($enable_ubbc) { doubbctopic(); }
    if ($enable_smile) { dosmilies(); }

    $morelink = qq~ ... <a href="$pageurl/$cgi?action=viewnews&amp;id=$id" class="morelink"><i>$bc_msg{'015'}</i></a>~;
    $message .= $morelink;

    newsshort();

    print $post;
  }
}
########################################################################

########################################################################
# common functions
########################################################################
sub trim { # trim leading and trailing whitespace
  local $_ = shift || ''; /^\s*(.*?)\s*$/; return $1 }
########################################################################

1;