#!/usr/bin/perl -w

########################################################################
#
# program: admin.cgi
# system : Blog Calendar Mod for WebAPP NE (Network Edition)
# author : Copyright (C) 2007 Steven L. Reid
# purpose: Administer mod configuration information.
# history:
# 12/16/2006, Steven Reid
#	- script created.
# 01/27/2007, Steven Reid
#	- fixed issues with blogcal.cgi overwriting variables
#
########################################################################

# setup environment
$|++;
#use strict; # turned off due to WebAPP not supporting it

# Read configuration file
BEGIN {
  use CGI::Carp qw(fatalsToBrowser);
  # include WebAPP configuration
  require "../../../config.pl";
  require "$lang";
  require "$sourcedir/subs.pl";
  # include configurations
  require "../data/blogcal-paths.cfg";
  require "../data/blogcal.cfg";
}

# load libraries
use File::Basename;

# define globals
my $bc_save = 0; # save config?

########################################################################
# begin main

bc_display_header();
bc_load_admin_parms();
bc_save_settings() if $bc_save;
bc_display_prompt();
bc_display_footer();

# end main
########################################################################

########################################################################
# BlogCal Display Header - load WebAPP stuff and print header
########################################################################
sub bc_display_header() {

  # WebAPP specific stuff
  eval {
    if ($IIS != 2) {
      if ($IIS == 0) {
        if ($ENV{'SERVER_SOFTWARE'} =~ m!IIS!) { $IIS = 1; }
      }
      if (($IIS) && ($0 =~ m!(.*)(\\|\/)!)) { chdir($1); }
	if ($IIS == 1) { print "HTTP/1.0 200 OK\n"; }
      }
  };

  if ($@) {
    print <<END_HTML;
Content-type: text/html\n\n
<html><head><title>Software Error</title></head>
<body><h1>Software Error:</h1>
Execution of <b>$scriptname</b> has been aborted due a compilation error:<br />
<pre>$@</pre>
<p>If this problem persists, please contact the webmaster and inform him about date and time you've received this error.</p>
</body></html>
END_HTML
    exit;
  }

  # include default sub stuff
  getcgi();
  getdate();
  loadcookie();
  loaduser();
  logips();
  ban();
  logvisitors();
  getver();

  # assume that if access to modadmin, grant access to blogcal's admin
  check_access('modadmin');
  error($err{'011'}) unless $access_granted == 1;

  # include language file (if exists)
  if ( -e "$bc_langDir/$userlang") {
    require "$bc_langDir/$userlang";
  } else {
    require "$bc_langDir/$bc_defaultLang";
  }

  # print top
  $navbar = "&nbsp;$btn{'014'}&nbsp;$bc_title $msg{'430'}";
  print_top();
}
########################################################################

########################################################################
# BlogCal Display Footer - print footer after doing work
########################################################################
sub bc_display_footer {
  print_bottom();
}
########################################################################

########################################################################
# Load params - get the form variables if need be
########################################################################
sub bc_load_admin_parms {
  # load parameters
  $bc_title		= isdef($input{'bca_title'},
  				$bc_title, 'Article Calendar');
  $bc_defaultLang	= isdef($input{'bca_defaultLang'},
  				$bc_defaultLang, 'english.lng');
  $bc_dual_cal		= isnum($input{'bca_dual_cal'},
				$bc_dual_cal, 0);
  $bc_numToDisplay	= isnum($input{'bca_numToDisplay'},
				$bc_numToDisplay, 5);
  $bc_style_blogcal	= isdef($input{'bca_style_blogcal'},
				$bc_style_blogcal, '');
  $bc_style_month	= isdef($input{'bca_style_month'},
				$bc_style_month, '');
  $bc_style_week	= isdef($input{'bca_style_week'},
				$bc_style_week, '');
  $bc_style_day		= isdef($input{'bca_style_day'},
				$bc_style_day, '');
  $bc_style_daypost	= isdef($input{'bca_style_daypost'},
				$bc_style_daypost, '');
  $bc_style_navigation	= isdef($input{'bca_style_navigation'},
				$bc_style_navigation, '');
  $bc_noday_color	= isdef($input{'bca_noday_color'},
				$bc_noday_color, '#008080');
  $bc_day_color		= isdef($input{'bca_day_color'},
				$bc_day_color, '#FFFFAA');
  $bc_weekend_color	= isdef($input{'bca_weekend_color'},
				$bc_weekend_color, '#AAFFFF');
  $bc_today_color	= isdef($input{'bca_today_color'},
				$bc_today_color, '#FFCCCC');

  $bc_save = $input{'bca_save'} ? 1 : 0;
}
########################################################################

########################################################################
# Show Settings -- show current configuration
########################################################################
sub bc_display_prompt() {

  # get language list
  my @bc_langs;
  for my $bc_lang (sort <$bc_langDir/*.lng>) {
    push @bc_langs, basename($bc_lang);
  }  

  print <<END_HTML;
<form action="$bc_adminScriptURL" method="post">
<h2>$bc_msg{'100'}</h2>
  <table summary="$bc_msg{'100'}" width="100%"
    cellpadding="0" cellspacing="0">
    <tr><td>$bc_msg{'101'}</td><td><input type="text"
      name="bca_title" value="$bc_title" size="32" /></td></tr>
    <tr><td>$bc_msg{'102'}</td><td><select size="1"
      name="bca_defaultLang">
END_HTML
  for my $bc_lang (@bc_langs) {
    my $selected = q~ selected="selected"~
      if $bc_lang eq $bc_defaultLang;
  print <<END_HTML;
      <option value='$bc_lang'$selected>$bc_lang</option>
END_HTML
    }
  print <<END_HTML;
      </select></td></tr>
    <tr><td>$bc_msg{'115'}</td><td><select size="1"
      name="bca_dual_cal">
END_HTML
    if ($bc_dual_cal == 1) {
  print <<END_HTML;
      <option value='1' selected="selected">$bc_msg{'003'}</option>
      <option value='0'>$bc_msg{'004'}</option>
END_HTML
    } else {
  print <<END_HTML;
      <option value='1'>$bc_msg{'003'}</option>
      <option value='0' selected="selected">$bc_msg{'004'}</option>
END_HTML
    }
  print <<END_HTML;
      </select></td></tr>
    <tr><td>$bc_msg{'103'}</td><td><input type="text"
      name="bca_numToDisplay" value="$bc_numToDisplay" size="4" /></td></tr>
    <tr><td>$bc_msg{'104'}</td><td><input type="text"
      name="bca_style_blogcal" value="$bc_style_blogcal" size="32" /></td></tr>
    <tr><td>$bc_msg{'105'}</td><td><input type="text"
      name="bca_style_title" value="$bc_style_title" size=32" /></td></tr>
    <tr><td>$bc_msg{'106'}</td><td><input type="text"
      name="bca_style_month" value="$bc_style_month" size=32" /></td></tr>
    <tr><td>$bc_msg{'107'}</td><td><input type="text"
      name="bca_style_week" value="$bc_style_week" size="32" /></td></tr>
    <tr><td>$bc_msg{'108'}</td><td><input type="text"
      name="bca_style_day" value="$bc_style_day" size="32" /></td></tr>
    <tr><td>$bc_msg{'109'}</td><td><input type="text"
      name="bca_style_daypost" value="$bc_style_daypost" size="32" /></td></tr>
    <tr><td>$bc_msg{'110'}</td><td><input type="text"
      name="bca_style_navigation" value="$bc_style_navigation" size="32" /></td></tr>
    <tr><td>$bc_msg{'111'}</td><td><input type="text"
      name="bca_noday_color" value="$bc_noday_color" size="8" /></td></tr>
    <tr><td>$bc_msg{'112'}</td><td><input type="text"
      name="bca_day_color" value="$bc_day_color" size="8" /></td></tr>
    <tr><td>$bc_msg{'113'}</td><td><input type="text"
      name="bca_weekend_color" value="$bc_weekend_color" size="8" /></td></tr>
    <tr><td>$bc_msg{'114'}</td><td><input type="text"
      name="bca_today_color" value="$bc_today_color" size=8" /></td></tr>
    <tr><td colspan="2" align="center">
      <input type="hidden" name="bca_save" value="bc_save" />
      <input type="submit" value="$bc_msg{'005'}" />
      <input type="reset" value="$bc_msg{'006'}" /></td></tr>
</table></form>
END_HTML
}
########################################################################

########################################################################
# Slideshow Save Settings - save any changes in settings
########################################################################
sub bc_save_settings {
  
  # open configuration file
  open CONFIG, ">../data/blogcal.cfg"
    or error("$err{'016'} $bc_dataDir/blogcal.cfg");
  hold(CONFIG);

  print CONFIG <<END_CONFIG;
########################################################################
#
# file   : blogcal.cfg
# system : Blog Calendar Mod for WebAPP NE (Network Edition)
# author : Copyright (C) 2006 Steven L. Reid
# purpose: Define global configuration options.
#
########################################################################

########################################################################
# General Settings
########################################################################
\$bc_title		= q~$bc_title~;
\$bc_defaultLang		= q~$bc_defaultLang~;
\$bc_dual_cal		= $bc_dual_cal;
\$bc_numToDisplay	= $bc_numToDisplay;
\$bc_style_blogcal	= q~$bc_style_blogcal~;
\$bc_style_title	= q~$bc_style_title~;
\$bc_style_month	= q~$bc_style_month~;
\$bc_style_week		= q~$bc_style_week~;
\$bc_style_day		= q~$bc_style_day~;
\$bc_style_daypost	= q~$bc_style_daypost~;
\$bc_style_navigation	= q~$bc_style_navigation~;
\$bc_noday_color	= q~$bc_noday_color~;
\$bc_day_color		= q~$bc_day_color~;
\$bc_weekend_color	= q~$bc_weekend_color~;
\$bc_today_color	= q~$bc_today_color~;
########################################################################

1; #return true
END_CONFIG

	release(CONFIG); close(CONFIG);
	
	print "<h3>$bc_msg{'007'}</h3>";
}
########################################################################

########################################################################
# common functions
########################################################################
sub trim { # trim leading and trailing whitespace
  local $_ = shift || ''; /^\s*(.*?)\s*$/; return $1 }
########################################################################
sub isnum { # check if a number, otherwise load defaults
  my $retval; my $lastval;
  for my $val (@_) {
    $lastval = $val;
    next unless defined $val;
    next unless $val =~ /^\s*(\d+)\s*$/;
    return $1;
  }
  return $lastval;
}
########################################################################
sub isdef { # check if defined, otherwise load defaults
  my $retval; my $lastval;
  for my $val (@_) {
    $lastval = $val;
    next unless defined $val;
    next unless trim($val);
    return trim($val);
  }
  return $lastval;
}
########################################################################

1;